/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.jdktimezone;

import java.io.Serializable;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.logging.Logger;
import org.jboss.seam.international.jdktimezone.ForwardingTimeZone;
import org.jboss.seam.international.timezone.DefaultTimeZone;

@ApplicationScoped
public class DefaultTimeZoneProducer
implements Serializable {
    private static final long serialVersionUID = 3277798729003795202L;
    @Inject
    @DefaultTimeZone
    private Instance<String> defaultTimeZoneId;
    private final Logger log = Logger.getLogger(DefaultTimeZoneProducer.class);
    @Produces
    @Named
    private TimeZone defaultTimeZone = null;

    @PostConstruct
    public void init() {
        if (!this.defaultTimeZoneId.isUnsatisfied()) {
            try {
                String id = (String)this.defaultTimeZoneId.get();
                TimeZone dtz = TimeZone.getTimeZone(id);
                if (!dtz.getID().equals(id)) {
                    throw new IllegalArgumentException();
                }
                this.defaultTimeZone = this.constructTimeZone(dtz);
            }
            catch (IllegalArgumentException e) {
                this.log.warn((Object)("DefaultTimeZoneProducer: Default TimeZone Id of " + (String)this.defaultTimeZoneId.get() + " was not found"));
            }
        }
        if (null == this.defaultTimeZone) {
            TimeZone dtz = TimeZone.getDefault();
            this.defaultTimeZone = this.constructTimeZone(dtz);
        }
    }

    private ForwardingTimeZone constructTimeZone(final TimeZone dtz) {
        return new ForwardingTimeZone(dtz.getID()){
            private static final long serialVersionUID = 8409832600089507805L;

            @Override
            protected TimeZone delegate() {
                return dtz;
            }

            @Override
            public void setRawOffset(int offsetMillis) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

