/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.status;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.jboss.seam.international.status.Message;
import org.jboss.seam.international.status.MessageBuilder;
import org.jboss.seam.international.status.MessageFactory;
import org.jboss.seam.international.status.Messages;
import org.jboss.seam.international.status.builder.BundleKey;
import org.jboss.seam.international.status.builder.BundleTemplateMessage;
import org.jboss.seam.international.status.builder.TemplateMessage;

@RequestScoped
public class MessagesImpl
implements Messages {
    private static final long serialVersionUID = -2908193057765795662L;
    private final Set<Message> messages = Collections.synchronizedSet(new HashSet());
    private final Set<MessageBuilder> builders = Collections.synchronizedSet(new HashSet());
    @Inject
    private MessageFactory factory;

    @Override
    public void clear() {
        this.messages.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.messages.isEmpty() && this.builders.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Message> getAll() {
        HashSet<Message> result = new HashSet<Message>();
        Set<Object> set = this.builders;
        synchronized (set) {
            for (MessageBuilder builder : this.builders) {
                this.messages.add(builder.build());
            }
            this.builders.clear();
        }
        set = this.messages;
        synchronized (set) {
            result.addAll(this.messages);
        }
        return result;
    }

    @Override
    public void add(Message message) {
        this.messages.add(message);
    }

    @Override
    public void add(MessageBuilder builder) {
        this.builders.add(builder);
    }

    private <T extends MessageBuilder> T enqueueBuilder(T builder) {
        this.add(builder);
        return builder;
    }

    @Override
    public BundleTemplateMessage info(BundleKey message) {
        return this.enqueueBuilder(this.factory.info(message));
    }

    @Override
    public BundleTemplateMessage info(BundleKey message, Object ... params) {
        return this.enqueueBuilder(this.factory.info(message, params));
    }

    @Override
    public BundleTemplateMessage warn(BundleKey message) {
        return this.enqueueBuilder(this.factory.warn(message));
    }

    @Override
    public BundleTemplateMessage warn(BundleKey message, Object ... params) {
        return this.enqueueBuilder(this.factory.warn(message, params));
    }

    @Override
    public BundleTemplateMessage error(BundleKey message) {
        return this.enqueueBuilder(this.factory.error(message));
    }

    @Override
    public BundleTemplateMessage error(BundleKey message, Object ... params) {
        return this.enqueueBuilder(this.factory.error(message, params));
    }

    @Override
    public BundleTemplateMessage fatal(BundleKey message) {
        return this.enqueueBuilder(this.factory.fatal(message));
    }

    @Override
    public BundleTemplateMessage fatal(BundleKey message, Object ... params) {
        return this.enqueueBuilder(this.factory.fatal(message, params));
    }

    @Override
    public TemplateMessage info(String message) {
        return this.enqueueBuilder(this.factory.info(message));
    }

    @Override
    public TemplateMessage info(String message, Object ... params) {
        return this.enqueueBuilder(this.factory.info(message, params));
    }

    @Override
    public TemplateMessage warn(String message) {
        return this.enqueueBuilder(this.factory.warn(message));
    }

    @Override
    public TemplateMessage warn(String message, Object ... params) {
        return this.enqueueBuilder(this.factory.warn(message, params));
    }

    @Override
    public TemplateMessage error(String message) {
        return this.enqueueBuilder(this.factory.error(message));
    }

    @Override
    public TemplateMessage error(String message, Object ... params) {
        return this.enqueueBuilder(this.factory.error(message, params));
    }

    @Override
    public TemplateMessage fatal(String message) {
        return this.enqueueBuilder(this.factory.fatal(message));
    }

    @Override
    public TemplateMessage fatal(String message, Object ... params) {
        return this.enqueueBuilder(this.factory.fatal(message, params));
    }
}

