/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.status.builder;

import java.util.Arrays;
import org.jboss.seam.international.status.Level;
import org.jboss.seam.international.status.Message;
import org.jboss.seam.international.status.MessageBuilder;
import org.jboss.seam.international.status.MessageImpl;
import org.jboss.seam.international.status.builder.Interpolator;
import org.jboss.seam.international.status.builder.TemplateMessage;

public class TemplateMessageImpl
implements MessageBuilder,
TemplateMessage {
    private final Interpolator interpolator = new Interpolator();
    private String summary;
    private String detail;
    private Object[] summaryParams;
    private Object[] detailParams;
    private String targets;
    private Level level;

    public Message build() {
        MessageImpl message = new MessageImpl();
        message.setLevel(this.level);
        message.setText(this.interpolator.populate(this.summary, this.summaryParams));
        if (this.detail != null && !this.detail.equals("")) {
            message.setDetail(this.interpolator.populate(this.detail, this.detailParams));
        }
        message.setTargets(this.targets);
        return message;
    }

    public TemplateMessageImpl text(String summary) {
        this.summary = summary;
        return this;
    }

    public TemplateMessageImpl detail(String detail) {
        this.detail = detail;
        return this;
    }

    public TemplateMessageImpl textParams(Object ... summaryParams) {
        this.summaryParams = summaryParams;
        return this;
    }

    public TemplateMessageImpl detailParams(Object ... detailParams) {
        this.detailParams = detailParams;
        return this;
    }

    public TemplateMessage targets(String targets) {
        this.targets = targets;
        return this;
    }

    public TemplateMessage level(Level level) {
        this.level = level;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
        result = 31 * result + (this.summary == null ? 0 : this.summary.hashCode());
        result = 31 * result + (this.detail == null ? 0 : this.detail.hashCode());
        result = 31 * result + Arrays.hashCode(this.summaryParams);
        result = 31 * result + Arrays.hashCode(this.detailParams);
        result = 31 * result + (this.targets == null ? 0 : this.targets.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateMessageImpl other = (TemplateMessageImpl)obj;
        if (this.level == null ? other.level != null : !this.level.equals((Object)other.level)) {
            return false;
        }
        if (this.summary == null ? other.summary != null : !this.summary.equals(other.summary)) {
            return false;
        }
        if (this.detail == null ? other.detail != null : !this.detail.equals(other.detail)) {
            return false;
        }
        if (!Arrays.equals(this.summaryParams, other.summaryParams)) {
            return false;
        }
        if (!Arrays.equals(this.detailParams, other.detailParams)) {
            return false;
        }
        return !(this.targets == null ? other.targets != null : !this.targets.equals(other.targets));
    }
}

