/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.status.builder;

import java.util.Locale;
import javax.inject.Inject;
import org.jboss.seam.international.status.ApplicationBundles;
import org.jboss.seam.international.status.Level;
import org.jboss.seam.international.status.Message;
import org.jboss.seam.international.status.builder.BundleKey;
import org.jboss.seam.international.status.builder.BundleTemplateMessage;
import org.jboss.seam.international.status.builder.TemplateMessage;
import org.jboss.solder.core.Client;
import org.jboss.solder.logging.Logger;

public class BundleTemplateMessageImpl
implements BundleTemplateMessage {
    @Inject
    TemplateMessage template;
    private String textDefault;
    private BundleKey textKey;
    private BundleKey detailKey;
    @Inject
    ApplicationBundles bundles;
    @Inject
    @Client
    Locale clientLocale;
    private final Logger log = Logger.getLogger(BundleTemplateMessageImpl.class);

    public Message build() {
        String text;
        String detail = null;
        try {
            text = this.bundles.get(this.clientLocale, (Object)this.textKey.getBundle()).getString(this.textKey.getKey());
            if (this.detailKey != null) {
                detail = this.bundles.get(this.clientLocale, (Object)this.detailKey.getBundle()).getString(this.detailKey.getKey());
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Could not load bundle: " + this.textKey));
            text = this.textDefault;
        }
        if (text == null || "".equals(text)) {
            text = this.textKey.toString();
        }
        this.template.text(text);
        if (detail != null) {
            this.template.detail(detail);
        }
        return this.template.build();
    }

    public BundleTemplateMessageImpl key(BundleKey text) {
        this.textKey = text;
        return this;
    }

    public BundleTemplateMessageImpl detail(BundleKey detailKey) {
        this.detailKey = detailKey;
        return this;
    }

    public BundleTemplateMessage defaults(String text) {
        this.textDefault = text;
        return this;
    }

    public BundleTemplateMessageImpl params(Object ... textParams) {
        this.template.textParams(textParams);
        return this;
    }

    public BundleTemplateMessageImpl detailParams(Object ... detailParams) {
        this.template.detailParams(detailParams);
        return this;
    }

    public BundleTemplateMessage targets(String targets) {
        this.template.targets(targets);
        return this;
    }

    public BundleTemplateMessage level(Level level) {
        this.template.level(level);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        result = 31 * result + (this.textDefault == null ? 0 : this.textDefault.hashCode());
        result = 31 * result + (this.textKey == null ? 0 : this.textKey.hashCode());
        result = 31 * result + (this.detailKey == null ? 0 : this.detailKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleTemplateMessageImpl other = (BundleTemplateMessageImpl)obj;
        if (this.template == null ? other.template != null : !this.template.equals(other.template)) {
            return false;
        }
        if (this.textDefault == null ? other.textDefault != null : !this.textDefault.equals(other.textDefault)) {
            return false;
        }
        if (this.textKey == null ? other.textKey != null : !this.textKey.equals((Object)other.textKey)) {
            return false;
        }
        return !(this.detailKey == null ? other.detailKey != null : !this.detailKey.equals((Object)other.detailKey));
    }
}

