/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.util.Exceptions;

@Name(value="org.jboss.seam.debug.contexts")
@Scope(value=ScopeType.APPLICATION)
@Install(debug=true, precedence=0)
public class Contexts {
    public List<ConversationEntry> getConversationEntries() {
        return new ArrayList<ConversationEntry>(ConversationEntries.instance().getConversationEntries());
    }

    public String[] getApplication() {
        Object[] names = org.jboss.seam.contexts.Contexts.getApplicationContext().getNames();
        Arrays.sort(names);
        return names;
    }

    public String[] getSession() {
        Object[] names = new String[]{};
        if (org.jboss.seam.contexts.Contexts.isSessionContextActive()) {
            names = org.jboss.seam.contexts.Contexts.getSessionContext().getNames();
        }
        Arrays.sort(names);
        return names;
    }

    public String[] getConversation() {
        Object[] names = new String[]{};
        if (org.jboss.seam.contexts.Contexts.isConversationContextActive()) {
            names = org.jboss.seam.contexts.Contexts.getConversationContext().getNames();
        }
        Arrays.sort(names);
        return names;
    }

    public String[] getBusinessProcess() {
        if (org.jboss.seam.contexts.Contexts.isBusinessProcessContextActive()) {
            Object[] names = org.jboss.seam.contexts.Contexts.getBusinessProcessContext().getNames();
            Arrays.sort(names);
            return names;
        }
        return null;
    }

    public Exception getException() {
        Exception e = null;
        if (org.jboss.seam.contexts.Contexts.isConversationContextActive()) {
            if (org.jboss.seam.contexts.Contexts.getConversationContext().get("org.jboss.seam.caughtException") == null) {
                return null;
            }
            e = (Exception)org.jboss.seam.contexts.Contexts.getConversationContext().get("org.jboss.seam.caughtException");
        }
        return e;
    }

    public List<Exception> getExceptionCauses() {
        ArrayList<Exception> causes = new ArrayList<Exception>();
        Exception cause = this.getException();
        while (cause != null) {
            causes.add(cause);
            cause = Exceptions.getCause((Exception)cause);
        }
        return causes;
    }

    public boolean isExceptionExists() {
        return this.getException() != null;
    }
}

