/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.jxl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jxl.SheetSettings;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.Template;
import org.jboss.seam.excel.jxl.JXLExcelFactory;
import org.jboss.seam.excel.ui.UICell;
import org.jboss.seam.excel.ui.UICellFormat;
import org.jboss.seam.excel.ui.UICellTemplate;
import org.jboss.seam.excel.ui.UIWorksheet;
import org.jboss.seam.excel.ui.UIWorksheetSettings;
import org.jboss.seam.excel.ui.UIWorksheetTemplate;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXLTemplates {
    private Log log = Logging.getLog(this.getClass());
    private static final String TEMPLATE_SEPARATOR_CHAR = ",";
    private Map<String, UICellTemplate> cellTemplates = new HashMap<String, UICellTemplate>();
    private Map<String, UIWorksheetTemplate> worksheetTemplates = new HashMap<String, UIWorksheetTemplate>();
    private Map<String, UICell.CellType> cellDataTypeCache = new HashMap<String, UICell.CellType>();
    private Map<String, WritableCellFormat> cellFormatCache = new HashMap<String, WritableCellFormat>();
    private Map<String, WritableCellFeatures> cellFeaturesCache = new HashMap<String, WritableCellFeatures>();

    private UICell.CellType getCellDataType(UICell uiCell) {
        UICell.CellType cellDataType;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Getting cell data type from cache for #0", new Object[]{uiCell.getId()});
        }
        if ((cellDataType = this.cellDataTypeCache.get(uiCell.getId())) == null) {
            cellDataType = uiCell.getDataType();
            this.cellDataTypeCache.put(uiCell.getId(), cellDataType);
        }
        return cellDataType;
    }

    private WritableCellFormat getCellFormat(UICell uiCell) {
        WritableCellFormat cellFormat;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Getting cell format for #0", new Object[]{uiCell.getId()});
        }
        if ((cellFormat = this.cellFormatCache.get(uiCell.getId())) == null) {
            cellFormat = this.createCellFormat(uiCell);
            this.cellFormatCache.put(uiCell.getId(), cellFormat);
        }
        return cellFormat;
    }

    protected CellInfo getCellInfo(UICell uiCell) {
        CellInfo cellInfo = new CellInfo();
        cellInfo.setCellFeatures(this.createCellFeatures(uiCell));
        cellInfo.setCellType(this.getCellDataType(uiCell));
        cellInfo.setCellFormat(this.getCellFormat(uiCell));
        return cellInfo;
    }

    protected void addTemplate(Template template) {
        switch (template.getType()) {
            case cell: {
                if (this.cellTemplates.containsKey(template.getName())) {
                    throw new ExcelWorkbookException(Interpolator.instance().interpolate("The cell template {0} is already registered", new Object[]{template.getName()}));
                }
                this.cellTemplates.put(template.getName(), (UICellTemplate)template);
                break;
            }
            case worksheet: {
                if (this.worksheetTemplates.containsKey(template.getName())) {
                    throw new ExcelWorkbookException(Interpolator.instance().interpolate("The worksheet template {0} is already registered", new Object[]{template.getName()}));
                }
                this.worksheetTemplates.put(template.getName(), (UIWorksheetTemplate)template);
                break;
            }
            default: {
                throw new ExcelWorkbookException(Interpolator.instance().interpolate("Unknown template type {0}", new Object[]{template.getType()}));
            }
        }
    }

    private List<UICellFormat> mergeTemplates(UICell uiCell) {
        ArrayList<UICellFormat> mergeList = new ArrayList<UICellFormat>();
        if (uiCell.getTemplates() != null) {
            for (String templateName : uiCell.getTemplates().split(TEMPLATE_SEPARATOR_CHAR)) {
                UICellTemplate cellTemplate = this.cellTemplates.get(templateName.trim());
                if (cellTemplate == null) {
                    String validNames = this.getValidTemplateNames(this.cellTemplates.keySet());
                    this.log.trace((Object)Interpolator.instance().interpolate("Could not find cell template {0}, try {1}", new Object[]{templateName, validNames}), new Object[0]);
                    continue;
                }
                mergeList.add(cellTemplate);
            }
        }
        mergeList.add(uiCell);
        return mergeList;
    }

    private String getValidTemplateNames(Set<String> keys) {
        StringBuffer names = new StringBuffer();
        int i = 0;
        for (String name : keys) {
            names.append(i++ == 0 ? name : ", " + name);
        }
        return names.toString();
    }

    private WritableCellFeatures createCellFeatures(UICell uiCell) {
        List<UICellFormat> mergeList = this.mergeTemplates(uiCell);
        WritableCellFeatures mergedCellFeatures = null;
        for (UICellFormat mergeCellFeature : mergeList) {
            mergedCellFeatures = JXLExcelFactory.createCellFeatures(mergeCellFeature, mergedCellFeatures);
        }
        return mergedCellFeatures;
    }

    private WritableCellFormat createCellFormat(UICell uiCell) {
        List<UICellFormat> mergeList = this.mergeTemplates(uiCell);
        WritableCellFormat mergedCellFormat = null;
        for (UICellFormat mergeCellFormat : mergeList) {
            try {
                mergedCellFormat = JXLExcelFactory.createCellFormat(mergeCellFormat, mergedCellFormat, uiCell.getDataType());
            }
            catch (WriteException e) {
                throw new ExcelWorkbookException("Could not crete cell format", e);
            }
        }
        return mergedCellFormat;
    }

    protected void applyWorksheetSettings(WritableSheet worksheet, UIWorksheet uiWorksheet) {
        ArrayList<UIWorksheetSettings> mergeList = new ArrayList<UIWorksheetSettings>();
        if (uiWorksheet.getTemplates() != null) {
            for (String templateName : uiWorksheet.getTemplates().split(TEMPLATE_SEPARATOR_CHAR)) {
                UIWorksheetTemplate worksheetTemplate = this.worksheetTemplates.get(templateName.trim());
                if (worksheetTemplate == null) {
                    String validNames = this.getValidTemplateNames(this.worksheetTemplates.keySet());
                    throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not find worksheet template #0, try [#1]", new Object[]{templateName, validNames}));
                }
                mergeList.add(worksheetTemplate);
            }
        }
        mergeList.add(uiWorksheet);
        SheetSettings oldSettings = worksheet.getSettings();
        for (UIWorksheetSettings template : mergeList) {
            JXLExcelFactory.applyWorksheetSettings(oldSettings, template);
        }
    }

    protected class CellInfo {
        private WritableCellFormat cellFormat;
        private WritableCellFeatures cellFeatures;
        private UICell.CellType cellType;

        protected CellInfo() {
        }

        public UICell.CellType getCellType() {
            return this.cellType;
        }

        public void setCellType(UICell.CellType cellType) {
            this.cellType = cellType;
        }

        public WritableCellFormat getCellFormat() {
            return this.cellFormat;
        }

        public WritableCellFeatures getCellFeatures() {
            return this.cellFeatures;
        }

        public void setCellFormat(WritableCellFormat cellFormat) {
            this.cellFormat = cellFormat;
        }

        public void setCellFeatures(WritableCellFeatures cellFeatures) {
            this.cellFeatures = cellFeatures;
        }
    }
}

