/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.ui;

import java.io.IOException;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import org.jboss.seam.core.Manager;
import org.jboss.seam.document.DocumentData;
import org.jboss.seam.document.DocumentStore;
import org.jboss.seam.excel.ExcelFactory;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.Template;
import org.jboss.seam.excel.ui.ExcelComponent;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Pages;

public class UIWorkbook
extends ExcelComponent {
    private Log log = Logging.getLog(((Object)((Object)this)).getClass());
    public static final String COMPONENT_TYPE = "org.jboss.seam.excel.ui.UIWorkbook";
    private boolean sendRedirect = true;
    private ExcelWorkbook excelWorkbook = null;
    private String type = "";
    private String templateURI;
    private Integer arrayGrowSize;
    private Boolean autoFilterDisabled;
    private Boolean cellValidationDisabled;
    private Integer characterSet;
    private Boolean drawingsDisabled;
    private String encoding;
    private String excelDisplayLanguage;
    private String excelRegionalSettings;
    private Boolean formulaAdjust;
    private Boolean gcDisabled;
    private Boolean ignoreBlanks;
    private Integer initialFileSize;
    private String locale;
    private Boolean mergedCellCheckingDisabled;
    private Boolean namesDisabled;
    private Boolean propertySets;
    private Boolean rationalization;
    private Boolean supressWarnings;
    private String temporaryFileDuringWriteDirectory;
    private Boolean useTemporaryFileDuringWrite;
    private Boolean workbookProtected;
    private long timing;

    public CreationType getCreationType() {
        if (this.hasSettings()) {
            if (this.getTemplateURI() != null) {
                return CreationType.WITH_SETTNGS_AND_TEMPLATE;
            }
            return CreationType.WITH_SETTINGS_WITHOUT_TEMPLATE;
        }
        if (this.getTemplateURI() != null) {
            return CreationType.WITHOUT_SETTINGS_WITH_TEMPLATE;
        }
        return CreationType.WITHOUT_SETTINGS_OR_TEMPLATE;
    }

    public Integer getArrayGrowSize() {
        return (Integer)this.valueOf("arrayGrowSize", this.arrayGrowSize);
    }

    public void setArrayGrowSize(Integer arrayGrowSize) {
        this.arrayGrowSize = arrayGrowSize;
    }

    public Boolean getAutoFilterDisabled() {
        return (Boolean)this.valueOf("autoFilterDisabled", this.autoFilterDisabled);
    }

    public void setAutoFilterDisabled(Boolean autoFilterDisabled) {
        this.autoFilterDisabled = autoFilterDisabled;
    }

    public Boolean getCellValidationDisabled() {
        return (Boolean)this.valueOf("cellValidationDisabled", this.cellValidationDisabled);
    }

    public void setCellValidationDisabled(Boolean cellValidationDisabled) {
        this.cellValidationDisabled = cellValidationDisabled;
    }

    public Integer getCharacterSet() {
        return (Integer)this.valueOf("characterSet", this.characterSet);
    }

    public void setCharacterSet(Integer characterSet) {
        this.characterSet = characterSet;
    }

    public Boolean getDrawingsDisabled() {
        return (Boolean)this.valueOf("drawingsDisabled", this.drawingsDisabled);
    }

    public void setDrawingsDisabled(Boolean drawingsDisabled) {
        this.drawingsDisabled = drawingsDisabled;
    }

    public String getEncoding() {
        return (String)this.valueOf("encoding", this.encoding);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getExcelDisplayLanguage() {
        return (String)this.valueOf("excelDisplayLanguage", this.excelDisplayLanguage);
    }

    public void setExcelDisplayLanguage(String excelDisplayLanguage) {
        this.excelDisplayLanguage = excelDisplayLanguage;
    }

    public String getExcelRegionalSettings() {
        return (String)this.valueOf("excelRegionalSettings", this.excelRegionalSettings);
    }

    public void setExcelRegionalSettings(String excelRegionalSettings) {
        this.excelRegionalSettings = excelRegionalSettings;
    }

    public Boolean getFormulaAdjust() {
        return (Boolean)this.valueOf("formulaAdjust", this.formulaAdjust);
    }

    public void setFormulaAdjust(Boolean formulaAdjust) {
        this.formulaAdjust = formulaAdjust;
    }

    public Boolean getGcDisabled() {
        return (Boolean)this.valueOf("gcDisabled", this.gcDisabled);
    }

    public void setGcDisabled(Boolean gcDisabled) {
        this.gcDisabled = gcDisabled;
    }

    public Boolean getIgnoreBlanks() {
        return (Boolean)this.valueOf("ignoreBlanks", this.ignoreBlanks);
    }

    public void setIgnoreBlanks(Boolean ignoreBlanks) {
        this.ignoreBlanks = ignoreBlanks;
    }

    public Integer getInitialFileSize() {
        return (Integer)this.valueOf("initialFileSize", this.initialFileSize);
    }

    public void setInitialFileSize(Integer initialFileSize) {
        this.initialFileSize = initialFileSize;
    }

    public String getLocale() {
        return (String)this.valueOf("locale", this.locale);
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Boolean getMergedCellCheckingDisabled() {
        return (Boolean)this.valueOf("mergedCellCheckingDisabled", this.mergedCellCheckingDisabled);
    }

    public void setMergedCellCheckingDisabled(Boolean mergedCellCheckingDisabled) {
        this.mergedCellCheckingDisabled = mergedCellCheckingDisabled;
    }

    public Boolean getNamesDisabled() {
        return (Boolean)this.valueOf("namesDisabled", this.namesDisabled);
    }

    public void setNamesDisabled(Boolean namesDisabled) {
        this.namesDisabled = namesDisabled;
    }

    public Boolean getPropertySets() {
        return (Boolean)this.valueOf("propertySets", this.propertySets);
    }

    public void setPropertySets(Boolean propertySets) {
        this.propertySets = propertySets;
    }

    public Boolean getRationalization() {
        return (Boolean)this.valueOf("rationalization", this.rationalization);
    }

    public void setRationalization(Boolean rationalization) {
        this.rationalization = rationalization;
    }

    public Boolean getSupressWarnings() {
        return (Boolean)this.valueOf("supressWarnings", this.supressWarnings);
    }

    public void setSupressWarnings(Boolean supressWarnings) {
        this.supressWarnings = supressWarnings;
    }

    public String getTemporaryFileDuringWriteDirectory() {
        return (String)this.valueOf("temporaryFileDuringWriteDirectory", this.temporaryFileDuringWriteDirectory);
    }

    public void setTemporaryFileDuringWriteDirectory(String temporaryFileDuringWriteDirectory) {
        this.temporaryFileDuringWriteDirectory = temporaryFileDuringWriteDirectory;
    }

    public Boolean getUseTemporaryFileDuringWrite() {
        return (Boolean)this.valueOf("useTemporaryFileDuringWrite", this.useTemporaryFileDuringWrite);
    }

    public void setUseTemporaryFileDuringWrite(Boolean useTemporaryFileDuringWrite) {
        this.useTemporaryFileDuringWrite = useTemporaryFileDuringWrite;
    }

    public void encodeBegin(FacesContext arg0) throws IOException {
        this.timing = new Date().getTime();
        this.excelWorkbook = ExcelFactory.instance().getExcelWorkbook(this.type);
        this.excelWorkbook.createWorkbook(this);
        for (Template template : UIWorkbook.getTemplates(this.getChildren())) {
            this.excelWorkbook.addTemplate(template);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        byte[] bytes = new byte[]{};
        bytes = this.excelWorkbook.getBytes();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Prosessed for {0}ms", new Object[]{new Date().getTime() - this.timing});
        }
        DocumentData.DocumentType type = this.excelWorkbook.getDocumentType();
        String viewId = Pages.getViewId((FacesContext)context);
        String baseName = UIWorkbook.baseNameForViewId(viewId);
        DocumentData documentData = new DocumentData(baseName, type, bytes);
        if (this.sendRedirect) {
            DocumentStore store = DocumentStore.instance();
            String id = store.newId();
            String url = store.preferredUrlForContent(baseName, type.getExtension(), id);
            url = Manager.instance().encodeConversationId(url, viewId);
            store.saveData(id, documentData);
            context.getExternalContext().redirect(url);
        } else {
            UIComponent parent = this.getParent();
            if (parent instanceof ValueHolder) {
                ValueHolder holder = (ValueHolder)parent;
                holder.setValue((Object)documentData);
            }
        }
    }

    public static String baseNameForViewId(String viewId) {
        int pos = viewId.lastIndexOf("/");
        if (pos != -1) {
            viewId = viewId.substring(pos + 1);
        }
        if ((pos = viewId.lastIndexOf(".")) != -1) {
            viewId = viewId.substring(0, pos);
        }
        return viewId;
    }

    public boolean isSendRedirect() {
        return this.sendRedirect;
    }

    public void setSendRedirect(boolean sendRedirect) {
        this.sendRedirect = sendRedirect;
    }

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ExcelWorkbook getExcelWorkbook() {
        return this.excelWorkbook;
    }

    public void setExcelWorkbook(ExcelWorkbook excelWorkbook) {
        this.excelWorkbook = excelWorkbook;
    }

    public String getTemplateURI() {
        return (String)this.valueOf("templateURI", this.templateURI);
    }

    public void setTemplateURI(String templateURI) {
        this.templateURI = templateURI;
    }

    public boolean hasSettings() {
        return this.arrayGrowSize != null || this.autoFilterDisabled != null || this.cellValidationDisabled != null || this.characterSet != null || this.drawingsDisabled != null || this.encoding != null || this.excelDisplayLanguage != null || this.excelRegionalSettings != null || this.formulaAdjust != null || this.gcDisabled != null || this.ignoreBlanks != null || this.initialFileSize != null || this.locale != null || this.mergedCellCheckingDisabled != null || this.namesDisabled != null || this.propertySets != null || this.rationalization != null || this.supressWarnings != null || this.temporaryFileDuringWriteDirectory != null || this.useTemporaryFileDuringWrite != null;
    }

    public Boolean getWorkbookProtected() {
        return (Boolean)this.valueOf("workbookProtected", this.workbookProtected);
    }

    public void setWorkbookProtected(Boolean workbookProtected) {
        this.workbookProtected = workbookProtected;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CreationType {
        WITHOUT_SETTINGS_OR_TEMPLATE,
        WITHOUT_SETTINGS_WITH_TEMPLATE,
        WITH_SETTINGS_WITHOUT_TEMPLATE,
        WITH_SETTNGS_AND_TEMPLATE;

    }
}

