/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.css;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.apache.commons.beanutils.PropertyUtils;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.css.PropertyBuilder;
import org.jboss.seam.excel.css.PropertyBuilders;
import org.jboss.seam.excel.css.StyleMap;
import org.jboss.seam.excel.ui.UILink;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final String STYLE_ATTRIBUTE = "style";
    private static final String STYLE_CLASS_ATTRIBUTE = "styleClass";
    private static final String STYLES_SEPARATOR = ";";
    private static final String STYLE_NAME_VALUE_SEPARATOR = ":";
    private static final String STYLE_SHORTHAND_SEPARATOR = " ";
    private static final String LEFT_BRACE = "{";
    private static final String RIGHT_BRACE = "}";
    private Map<String, StyleMap> definedStyleClasses = new HashMap<String, StyleMap>();
    private Map<String, PropertyBuilder> propertyBuilders = new HashMap<String, PropertyBuilder>();
    private Map<UIComponent, StyleMap> cellStyleCache = new HashMap<UIComponent, StyleMap>();
    private Log log = Logging.getLog(Parser.class);

    public Parser() {
        this.initPropertyBuilders();
    }

    public Parser(List<UILink> stylesheets) throws MalformedURLException, IOException {
        this.initPropertyBuilders();
        this.loadStylesheets(stylesheets);
    }

    private void loadStylesheets(List<UILink> stylesheets) throws MalformedURLException, IOException {
        for (UILink stylesheet : stylesheets) {
            this.definedStyleClasses.putAll(this.parseStylesheet(stylesheet.getURL()));
        }
    }

    private void initPropertyBuilders() {
        this.propertyBuilders.put("xls-font-family", new PropertyBuilders.FontFamily());
        this.propertyBuilders.put("xls-font-size", new PropertyBuilders.FontSize());
        this.propertyBuilders.put("xls-font-color", new PropertyBuilders.FontColor());
        this.propertyBuilders.put("xls-font-italic", new PropertyBuilders.FontItalic());
        this.propertyBuilders.put("xls-font-script-style", new PropertyBuilders.FontScriptStyle());
        this.propertyBuilders.put("xls-font-struck-out", new PropertyBuilders.FontStruckOut());
        this.propertyBuilders.put("xls-font-underline-style", new PropertyBuilders.FontUnderlineStyle());
        this.propertyBuilders.put("xls-font-bold", new PropertyBuilders.FontBold());
        this.propertyBuilders.put("xls-font", new PropertyBuilders.FontShorthand());
        this.propertyBuilders.put("xls-background-pattern", new PropertyBuilders.BackgroundPattern());
        this.propertyBuilders.put("xls-background-color", new PropertyBuilders.BackgroundColor());
        this.propertyBuilders.put("xls-background", new PropertyBuilders.BackgroundShorthand());
        this.propertyBuilders.put("xls-border-left-color", new PropertyBuilders.BorderLeftColor());
        this.propertyBuilders.put("xls-border-left-line-style", new PropertyBuilders.BorderLeftLineStyle());
        this.propertyBuilders.put("xls-border-left", new PropertyBuilders.BorderLeftShorthand());
        this.propertyBuilders.put("xls-border-top-color", new PropertyBuilders.BorderTopColor());
        this.propertyBuilders.put("xls-border-top-line-style", new PropertyBuilders.BorderTopLineStyle());
        this.propertyBuilders.put("xls-border-top", new PropertyBuilders.BorderTopShorthand());
        this.propertyBuilders.put("xls-border-right-color", new PropertyBuilders.BorderRightColor());
        this.propertyBuilders.put("xls-border-right-line-style", new PropertyBuilders.BorderRightLineStyle());
        this.propertyBuilders.put("xls-border-right", new PropertyBuilders.BorderRightShorthand());
        this.propertyBuilders.put("xls-border-bottom-color", new PropertyBuilders.BorderBottomColor());
        this.propertyBuilders.put("xls-border-bottom-line-style", new PropertyBuilders.BorderBottomLineStyle());
        this.propertyBuilders.put("xls-border-bottom", new PropertyBuilders.BorderBottomShorthand());
        this.propertyBuilders.put("xls-border", new PropertyBuilders.BorderShorthand());
        this.propertyBuilders.put("xls-format-mask", new PropertyBuilders.FormatMask());
        this.propertyBuilders.put("xls-alignment", new PropertyBuilders.Alignment());
        this.propertyBuilders.put("xls-indentation", new PropertyBuilders.Indentation());
        this.propertyBuilders.put("xls-orientation", new PropertyBuilders.Orientation());
        this.propertyBuilders.put("xls-locked", new PropertyBuilders.Locked());
        this.propertyBuilders.put("xls-shrink-to-fit", new PropertyBuilders.ShrinkToFit());
        this.propertyBuilders.put("xls-wrap", new PropertyBuilders.Wrap());
        this.propertyBuilders.put("xls-vertical-alignment", new PropertyBuilders.VericalAlignment());
        this.propertyBuilders.put("xls-column-width", new PropertyBuilders.ColumnWidth());
        this.propertyBuilders.put("xls-column-autosize", new PropertyBuilders.ColumnAutoSize());
        this.propertyBuilders.put("xls-column-hidden", new PropertyBuilders.ColumnHidden());
        this.propertyBuilders.put("xls-column-widths", new PropertyBuilders.ColumnWidths());
    }

    private static String readCSS(URL url) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        reader.close();
        return buffer.toString();
    }

    private Map<String, StyleMap> parseStylesheet(String URL2) throws MalformedURLException, IOException {
        HashMap<String, StyleMap> styleClasses = new HashMap<String, StyleMap>();
        String css = Parser.readCSS(new URL(URL2)).toLowerCase();
        int firstBrace = -1;
        int secondBrace = -1;
        while (!"".equals(css)) {
            firstBrace = css.indexOf(LEFT_BRACE);
            if (firstBrace >= 0) {
                secondBrace = css.indexOf(RIGHT_BRACE, firstBrace + 1);
            }
            if (firstBrace >= 0 && secondBrace >= 0 && firstBrace != secondBrace) {
                String styleName = css.substring(0, firstBrace).trim();
                String styleString = css.substring(firstBrace + 1, secondBrace).trim();
                StyleMap styleMap = this.parseStyleString(styleString);
                styleClasses.put(styleName, styleMap);
                css = css.substring(secondBrace + 1);
                continue;
            }
            css = "";
        }
        return styleClasses;
    }

    public static String getStyle(UIComponent component) {
        return Parser.getStyleProperty(component, STYLE_ATTRIBUTE);
    }

    public static String getStyleClass(UIComponent component) {
        return Parser.getStyleProperty(component, STYLE_CLASS_ATTRIBUTE);
    }

    private static String getStyleProperty(UIComponent component, String field) {
        try {
            return (String)PropertyUtils.getProperty((Object)component, (String)field);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            String message = Interpolator.instance().interpolate("Could not read field #0 of bean #1", new Object[]{field, component.getId()});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private List<StyleMap> cascadeStyleMap(UIComponent component, List<StyleMap> styleMaps) {
        styleMaps.add(this.getStyleMap(component));
        if (component.getParent() != null) {
            this.cascadeStyleMap(component.getParent(), styleMaps);
        }
        return styleMaps;
    }

    public StyleMap getCascadedStyleMap(UIComponent component) {
        List<StyleMap> styleMaps = this.cascadeStyleMap(component, new ArrayList<StyleMap>());
        Collections.reverse(styleMaps);
        StyleMap cascadedStyleMap = new StyleMap();
        for (StyleMap styleMap : styleMaps) {
            cascadedStyleMap.putAll(styleMap);
        }
        return cascadedStyleMap;
    }

    private StyleMap getStyleMap(UIComponent component) {
        String componentStyle;
        if (this.cellStyleCache.containsKey(component)) {
            return this.cellStyleCache.get(component);
        }
        StyleMap styleMap = new StyleMap();
        String componentStyleClass = Parser.getStyleProperty(component, STYLE_CLASS_ATTRIBUTE);
        if (componentStyleClass != null) {
            String[] styleClasses;
            for (String styleClass : styleClasses = this.trimArray(componentStyleClass.split(STYLE_SHORTHAND_SEPARATOR))) {
                if (!this.definedStyleClasses.containsKey(styleClass)) {
                    this.log.warn((Object)"Uknown style class #0", new Object[]{styleClass});
                    continue;
                }
                styleMap.putAll(this.definedStyleClasses.get(styleClass));
            }
        }
        if ((componentStyle = Parser.getStyleProperty(component, STYLE_ATTRIBUTE)) != null) {
            styleMap.putAll(this.parseStyleString(componentStyle));
        }
        this.cellStyleCache.put(component, styleMap);
        return styleMap;
    }

    private StyleMap parseStyleString(String styleString) {
        String[] styles;
        StyleMap styleMap = new StyleMap();
        for (String style : styles = this.trimArray(styleString.split(STYLES_SEPARATOR))) {
            String[] styleParts = style.split(STYLE_NAME_VALUE_SEPARATOR);
            if (styleParts.length != 2) {
                this.log.warn((Object)"Style component #0 should be of form <key>#1<value>", new Object[]{style, STYLE_NAME_VALUE_SEPARATOR});
                continue;
            }
            String styleName = styleParts[0].toLowerCase().trim();
            if (!this.propertyBuilders.containsKey(styleName)) {
                this.log.warn((Object)"No property builder (unknown style) for property #0", new Object[]{styleName});
                continue;
            }
            PropertyBuilder propertyBuilder = this.propertyBuilders.get(styleName);
            String styleValue = styleParts[1];
            String[] styleValues = this.trimArray(styleValue.trim().split(STYLE_SHORTHAND_SEPARATOR));
            styleMap.putAll(propertyBuilder.parseProperty(styleName, styleValues));
        }
        return styleMap;
    }

    private String[] trimArray(String[] array) {
        ArrayList<String> validValues = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            if ("".equals(array[i]) || STYLE_SHORTHAND_SEPARATOR.equals(array[i])) continue;
            validValues.add(array[i].toLowerCase().trim());
        }
        return validValues.toArray(new String[validValues.size()]);
    }

    public void setStylesheets(List<UILink> stylesheets) throws MalformedURLException, IOException {
        this.loadStylesheets(stylesheets);
    }
}

