/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.jxl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIComponent;
import jxl.CellView;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.format.CellFormat;
import jxl.write.Boolean;
import jxl.write.DateFormat;
import jxl.write.DateFormats;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.ResourceBundle;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.css.CSSParser;
import org.jboss.seam.excel.css.CellStyle;
import org.jboss.seam.excel.css.ColumnStyle;
import org.jboss.seam.excel.jxl.CellInfo;
import org.jboss.seam.excel.jxl.CellInfoCache;
import org.jboss.seam.excel.jxl.JXLFactory;
import org.jboss.seam.excel.ui.ExcelComponent;
import org.jboss.seam.excel.ui.UICell;
import org.jboss.seam.excel.ui.UICellBase;
import org.jboss.seam.excel.ui.UIColumn;
import org.jboss.seam.excel.ui.UIFooter;
import org.jboss.seam.excel.ui.UIHeader;
import org.jboss.seam.excel.ui.UILink;
import org.jboss.seam.excel.ui.UIPrintArea;
import org.jboss.seam.excel.ui.UIPrintTitles;
import org.jboss.seam.excel.ui.UIWorkbook;
import org.jboss.seam.excel.ui.UIWorksheet;
import org.jboss.seam.excel.ui.validation.UIListValidation;
import org.jboss.seam.excel.ui.validation.UIListValidationItem;
import org.jboss.seam.excel.ui.validation.UINumericValidation;
import org.jboss.seam.excel.ui.validation.UIRangeValidation;
import org.jboss.seam.excel.ui.validation.Validation;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXLHelper {
    private static Log log = Logging.getLog(JXLHelper.class);
    private CSSParser parser = new CSSParser();
    private CellInfoCache cellInfoCache = new CellInfoCache();

    private DisplayFormat getGenericDisplayFormat(String formatMask) {
        if (formatMask == null) {
            return null;
        }
        DisplayFormat displayFormat = JXLFactory.createNumberFormat(formatMask);
        if (displayFormat != null) {
            return displayFormat;
        }
        displayFormat = JXLFactory.createDateFormat(formatMask);
        if (displayFormat != null) {
            return displayFormat;
        }
        try {
            displayFormat = new NumberFormat(formatMask);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (displayFormat != null) {
            return displayFormat;
        }
        try {
            displayFormat = new DateFormat(formatMask);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return displayFormat;
    }

    public WritableCellFormat createCellFormat(UICell uiCell, UICell.CellType cellType) throws WriteException {
        WritableCellFormat cellFormat = null;
        CellStyle cellStyle = new CellStyle(this.parser.getCascadedStyleMap((UIComponent)uiCell));
        switch (cellType) {
            case text: {
                cellFormat = new WritableCellFormat(NumberFormats.TEXT);
                break;
            }
            case number: {
                if (cellStyle.formatMask == null) {
                    cellFormat = new WritableCellFormat(NumberFormats.DEFAULT);
                    break;
                }
                DisplayFormat displayFormat = JXLFactory.createNumberFormat(cellStyle.formatMask);
                if (displayFormat != null) {
                    cellFormat = new WritableCellFormat(displayFormat);
                    break;
                }
                try {
                    cellFormat = new WritableCellFormat((DisplayFormat)new NumberFormat(cellStyle.formatMask));
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not create number format for mask {0}", new Object[]{cellStyle.formatMask}), e);
                }
            }
            case date: {
                if (cellStyle.formatMask == null) {
                    cellFormat = new WritableCellFormat(DateFormats.DEFAULT);
                    break;
                }
                DisplayFormat displayFormat = JXLFactory.createDateFormat(cellStyle.formatMask);
                if (displayFormat != null) {
                    cellFormat = new WritableCellFormat(displayFormat);
                    break;
                }
                try {
                    cellFormat = new WritableCellFormat((DisplayFormat)new DateFormat(cellStyle.formatMask));
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not create date format for mask {0}", new Object[]{cellStyle.formatMask}), e);
                }
            }
            case formula: {
                DisplayFormat displayFormat = this.getGenericDisplayFormat(cellStyle.formatMask);
                cellFormat = displayFormat != null ? new WritableCellFormat(displayFormat) : new WritableCellFormat();
                break;
            }
            case bool: {
                cellFormat = new WritableCellFormat();
                break;
            }
            default: {
                cellFormat = new WritableCellFormat();
            }
        }
        if (cellStyle.alignment != null) {
            cellFormat.setAlignment(JXLFactory.createAlignment(cellStyle.alignment));
        }
        if (cellStyle.indentation != null) {
            cellFormat.setIndentation(cellStyle.indentation.intValue());
        }
        if (cellStyle.locked != null) {
            cellFormat.setLocked(cellStyle.locked.booleanValue());
        }
        if (cellStyle.orientation != null) {
            cellFormat.setOrientation(JXLFactory.createOrientation(cellStyle.orientation));
        }
        if (cellStyle.shrinkToFit != null) {
            cellFormat.setShrinkToFit(cellStyle.shrinkToFit.booleanValue());
        }
        if (cellStyle.verticalAlignment != null) {
            cellFormat.setVerticalAlignment(JXLFactory.createVerticalAlignment(cellStyle.verticalAlignment));
        }
        if (cellStyle.wrap != null) {
            cellFormat.setWrap(cellStyle.wrap.booleanValue());
        }
        if (cellStyle.font.isUsed()) {
            cellFormat.setFont(JXLFactory.createFont(cellStyle.font));
        }
        if (cellStyle.leftBorder.isUsed()) {
            cellFormat.setBorder(JXLFactory.createBorder("left"), JXLFactory.createLineStyle(cellStyle.leftBorder.lineStyle), JXLFactory.createColor(cellStyle.leftBorder.color));
        }
        if (cellStyle.topBorder.isUsed()) {
            cellFormat.setBorder(JXLFactory.createBorder("top"), JXLFactory.createLineStyle(cellStyle.topBorder.lineStyle), JXLFactory.createColor(cellStyle.topBorder.color));
        }
        if (cellStyle.rightBorder.isUsed()) {
            cellFormat.setBorder(JXLFactory.createBorder("right"), JXLFactory.createLineStyle(cellStyle.rightBorder.lineStyle), JXLFactory.createColor(cellStyle.rightBorder.color));
        }
        if (cellStyle.bottomBorder.isUsed()) {
            cellFormat.setBorder(JXLFactory.createBorder("bottom"), JXLFactory.createLineStyle(cellStyle.bottomBorder.lineStyle), JXLFactory.createColor(cellStyle.bottomBorder.color));
        }
        if (cellStyle.background.isUsed()) {
            cellFormat.setBackground(JXLFactory.createColor(cellStyle.background.color), JXLFactory.createPattern(cellStyle.background.pattern));
        }
        return cellFormat;
    }

    public void setStylesheets(List<UILink> stylesheets) throws MalformedURLException, IOException {
        this.parser.setStylesheets(stylesheets);
    }

    protected void applyWorksheetSettings(WritableSheet worksheet, UIWorksheet uiWorksheet) {
        SheetSettings settings = worksheet.getSettings();
        if (uiWorksheet.getAutomaticFormulaCalculation() != null) {
            settings.setAutomaticFormulaCalculation(uiWorksheet.getAutomaticFormulaCalculation().booleanValue());
        }
        if (uiWorksheet.getBottomMargin() != null) {
            settings.setBottomMargin(uiWorksheet.getBottomMargin().doubleValue());
        }
        if (uiWorksheet.getCopies() != null) {
            settings.setCopies(uiWorksheet.getCopies().intValue());
        }
        if (uiWorksheet.getDefaultColumnWidth() != null) {
            settings.setDefaultColumnWidth(uiWorksheet.getDefaultColumnWidth().intValue());
        }
        if (uiWorksheet.getDefaultRowHeight() != null) {
            settings.setDefaultRowHeight(uiWorksheet.getDefaultRowHeight().intValue());
        }
        if (uiWorksheet.getDisplayZeroValues() != null) {
            settings.setDisplayZeroValues(uiWorksheet.getDisplayZeroValues().booleanValue());
        }
        if (uiWorksheet.getFitHeight() != null) {
            settings.setFitHeight(uiWorksheet.getFitHeight().intValue());
        }
        if (uiWorksheet.getFitToPages() != null) {
            settings.setFitToPages(uiWorksheet.getFitToPages().booleanValue());
        }
        if (uiWorksheet.getFitWidth() != null) {
            settings.setFitWidth(uiWorksheet.getFitWidth().intValue());
        }
        if (uiWorksheet.getFooterMargin() != null) {
            settings.setFooterMargin(uiWorksheet.getFooterMargin().doubleValue());
        }
        if (uiWorksheet.getHeaderMargin() != null) {
            settings.setHeaderMargin(uiWorksheet.getHeaderMargin().doubleValue());
        }
        if (uiWorksheet.getHidden() != null) {
            settings.setHidden(uiWorksheet.getHidden().booleanValue());
        }
        if (uiWorksheet.getHorizontalCentre() != null) {
            settings.setHorizontalCentre(uiWorksheet.getHorizontalCentre().booleanValue());
        }
        if (uiWorksheet.getHorizontalFreeze() != null) {
            settings.setHorizontalFreeze(uiWorksheet.getHorizontalFreeze().intValue());
        }
        if (uiWorksheet.getHorizontalPrintResolution() != null) {
            settings.setHorizontalPrintResolution(uiWorksheet.getHorizontalPrintResolution().intValue());
        }
        if (uiWorksheet.getLeftMargin() != null) {
            settings.setLeftMargin(uiWorksheet.getLeftMargin().doubleValue());
        }
        if (uiWorksheet.getNormalMagnification() != null) {
            settings.setNormalMagnification(uiWorksheet.getNormalMagnification().intValue());
        }
        if (uiWorksheet.getOrientation() != null) {
            settings.setOrientation(JXLFactory.createPageOrientation(uiWorksheet.getOrientation()));
        }
        if (uiWorksheet.getPageBreakPreviewMagnification() != null) {
            settings.setPageBreakPreviewMagnification(uiWorksheet.getPageBreakPreviewMagnification().intValue());
        }
        if (uiWorksheet.getPageBreakPreviewMode() != null) {
            settings.setPageBreakPreviewMode(uiWorksheet.getPageBreakPreviewMode().booleanValue());
        }
        if (uiWorksheet.getPageStart() != null) {
            settings.setPageStart(uiWorksheet.getPageStart().intValue());
        }
        if (uiWorksheet.getPaperSize() != null) {
            settings.setPaperSize(JXLFactory.createPaperSize(uiWorksheet.getPaperSize()));
        }
        if (uiWorksheet.getPassword() != null) {
            settings.setPassword(uiWorksheet.getPassword());
        }
        if (uiWorksheet.getPasswordHash() != null) {
            settings.setPasswordHash(uiWorksheet.getPasswordHash().intValue());
        }
        if (uiWorksheet.getPrintGridLines() != null) {
            settings.setPrintGridLines(uiWorksheet.getPrintGridLines().booleanValue());
        }
        if (uiWorksheet.getPrintHeaders() != null) {
            settings.setPrintHeaders(uiWorksheet.getPrintHeaders().booleanValue());
        }
        if (uiWorksheet.getSheetProtected() != null) {
            settings.setProtected(uiWorksheet.getSheetProtected().booleanValue());
        }
        if (uiWorksheet.getRecalculateFormulasBeforeSave() != null) {
            settings.setRecalculateFormulasBeforeSave(uiWorksheet.getRecalculateFormulasBeforeSave().booleanValue());
        }
        if (uiWorksheet.getRightMargin() != null) {
            settings.setRightMargin(uiWorksheet.getRightMargin().doubleValue());
        }
        if (uiWorksheet.getScaleFactor() != null) {
            settings.setScaleFactor(uiWorksheet.getScaleFactor().intValue());
        }
        if (uiWorksheet.getSelected() != null) {
            settings.setSelected(uiWorksheet.getSelected().booleanValue());
        }
        if (uiWorksheet.getShowGridLines() != null) {
            settings.setShowGridLines(uiWorksheet.getShowGridLines().booleanValue());
        }
        if (uiWorksheet.getTopMargin() != null) {
            settings.setTopMargin(uiWorksheet.getTopMargin().doubleValue());
        }
        if (uiWorksheet.getVerticalCentre() != null) {
            settings.setVerticalCentre(uiWorksheet.getVerticalCentre().booleanValue());
        }
        if (uiWorksheet.getVerticalFreeze() != null) {
            settings.setVerticalFreeze(uiWorksheet.getVerticalFreeze().intValue());
        }
        if (uiWorksheet.getVerticalPrintResolution() != null) {
            settings.setVerticalPrintResolution(uiWorksheet.getVerticalPrintResolution().intValue());
        }
        if (uiWorksheet.getZoomFactor() != null) {
            settings.setZoomFactor(uiWorksheet.getZoomFactor().intValue());
        }
        for (UIComponent child : uiWorksheet.getChildren()) {
            if (child.getClass() == UIPrintArea.class) {
                UIPrintArea printArea = (UIPrintArea)child;
                settings.setPrintArea(printArea.getFirstColumn().intValue(), printArea.getFirstRow().intValue(), printArea.getLastColumn().intValue(), printArea.getLastRow().intValue());
                continue;
            }
            if (child.getClass() == UIPrintTitles.class) {
                UIPrintTitles printTitles = (UIPrintTitles)child;
                settings.setPrintTitles(printTitles.getFirstCol().intValue(), printTitles.getFirstRow().intValue(), printTitles.getLastCol().intValue(), printTitles.getLastRow().intValue());
                continue;
            }
            if (child.getClass() == UIHeader.class) {
                UIHeader uiHeader = (UIHeader)child;
                settings.setHeader(JXLFactory.createHeaderFooter((UIComponent)uiHeader, settings.getHeader()));
                continue;
            }
            if (child.getClass() != UIFooter.class) continue;
            UIFooter uiFooter = (UIFooter)child;
            settings.setFooter(JXLFactory.createHeaderFooter((UIComponent)uiFooter, settings.getFooter()));
        }
    }

    protected CellInfo getCellInfo(UICell uiCell) {
        CellInfo cellInfo = new CellInfo();
        cellInfo.setCellFeatures(this.createCellFeatures(uiCell));
        cellInfo.setCellType(this.getCellDataType(uiCell));
        cellInfo.setCellFormat(this.getCellFormat(uiCell, cellInfo.getCellType()));
        return cellInfo;
    }

    public WritableCellFeatures createCellFeatures(UICellBase uiCellFormat) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating cell features for #0", new Object[]{uiCellFormat});
        }
        WritableCellFeatures cellFeatures = new WritableCellFeatures();
        if (uiCellFormat.getComment() != null) {
            if (uiCellFormat.getCommentHeight() != null && uiCellFormat.getCommentWidth() != null) {
                cellFeatures.setComment(uiCellFormat.getComment(), (double)uiCellFormat.getCommentWidth().intValue(), (double)uiCellFormat.getCommentHeight().intValue());
            } else {
                cellFeatures.setComment(uiCellFormat.getComment());
            }
        }
        List<Validation> validations = ExcelComponent.getChildrenOfType(uiCellFormat.getChildren(), Validation.class);
        for (Validation validation : validations) {
            switch (validation.getType()) {
                case numeric: {
                    JXLHelper.addNumericValidation(cellFeatures, (UINumericValidation)validation);
                    break;
                }
                case range: {
                    JXLHelper.addRangeValidation(cellFeatures, (UIRangeValidation)validation);
                    break;
                }
                case list: {
                    JXLHelper.addListValidation(cellFeatures, (UIListValidation)validation);
                    break;
                }
                default: {
                    throw new ExcelWorkbookException(Interpolator.instance().interpolate("Unknown validation type {0}", new Object[]{validation.getType()}));
                }
            }
        }
        return cellFeatures;
    }

    private UICell.CellType getCellDataType(UICell uiCell) {
        UICell.CellType cellDataType;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Getting cell data type from cache for #0", new Object[]{uiCell.getId()});
        }
        if ((cellDataType = this.cellInfoCache.getCachedCellType(uiCell.getId())) == null) {
            CellStyle cellStyle = new CellStyle(this.parser.getCascadedStyleMap((UIComponent)uiCell));
            cellDataType = cellStyle.forceType != null ? UICell.CellType.valueOf(cellStyle.forceType) : uiCell.getDataType();
            this.cellInfoCache.setCachedCellType(uiCell.getId(), cellDataType);
        }
        return cellDataType;
    }

    private WritableCellFormat getCellFormat(UICell uiCell, UICell.CellType cellType) {
        WritableCellFormat cellFormat;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Getting cell format for #0", new Object[]{uiCell.getId()});
        }
        if ((cellFormat = this.cellInfoCache.getCachedCellFormat(uiCell.getId())) == null) {
            try {
                cellFormat = this.createCellFormat(uiCell, cellType);
            }
            catch (WriteException e) {
                throw new ExcelWorkbookException("Could not create cellformat", e);
            }
            this.cellInfoCache.setCachedCellFormat(uiCell.getId(), cellFormat);
        }
        return cellFormat;
    }

    private static void addListValidation(WritableCellFeatures cellFeatures, UIListValidation validation) {
        List<UIListValidationItem> items = ExcelComponent.getChildrenOfType(validation.getChildren(), UIListValidationItem.class);
        if (items.isEmpty()) {
            throw new ExcelWorkbookException("No items in validation list");
        }
        ArrayList<String> validations = new ArrayList<String>();
        for (UIListValidationItem item : items) {
            validations.add(item.getValue());
        }
        cellFeatures.setDataValidationList(validations);
    }

    private static void addRangeValidation(WritableCellFeatures cellFeatures, UIRangeValidation validation) {
        if (validation.getStartColumn() == null || validation.getStartRow() == null || validation.getEndColumn() == null || validation.getEndRow() == null) {
            throw new ExcelWorkbookException("Must set all start/end columns/rows for range validation");
        }
        cellFeatures.setDataValidationRange(validation.getStartColumn().intValue(), validation.getStartRow().intValue(), validation.getEndColumn().intValue(), validation.getEndRow().intValue());
    }

    private static void addNumericValidation(WritableCellFeatures cellFeatures, UINumericValidation validation) {
        if (validation.getValue() == null) {
            throw new ExcelWorkbookException("Must define value in validation");
        }
        if ((UINumericValidation.ValidationCondition.between.equals((Object)validation.getCondition()) || UINumericValidation.ValidationCondition.not_between.equals((Object)validation.getCondition())) && validation.getValue2() == null) {
            throw new ExcelWorkbookException("Must define both values in validation for between/not_between");
        }
        switch (validation.getCondition()) {
            case equal: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), WritableCellFeatures.EQUAL);
                break;
            }
            case not_equal: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), WritableCellFeatures.NOT_EQUAL);
                break;
            }
            case greater_equal: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), WritableCellFeatures.GREATER_EQUAL);
                break;
            }
            case less_equal: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), WritableCellFeatures.LESS_EQUAL);
                break;
            }
            case less_than: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), WritableCellFeatures.LESS_THAN);
                break;
            }
            case between: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), validation.getValue2().doubleValue(), WritableCellFeatures.BETWEEN);
                break;
            }
            case not_between: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), validation.getValue2().doubleValue(), WritableCellFeatures.NOT_BETWEEN);
            }
        }
    }

    public static WritableCell createCell(int column, int row, UICell.CellType type, Object data, WritableCellFormat cellFormat) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating cell at (#0,#1) of type #2 with data #3", new Object[]{column, row, type, data});
        }
        switch (type) {
            case text: {
                return new Label(column, row, data.toString(), (CellFormat)cellFormat);
            }
            case number: {
                try {
                    return new Number(column, row, Double.parseDouble(data.toString()), (CellFormat)cellFormat);
                }
                catch (NumberFormatException numberFormatException) {
                    String message = Interpolator.instance().interpolate(ResourceBundle.instance().getString("org.jboss.seam.excel.not_a_number"), new Object[]{data.toString()});
                    return new Label(column, row, message, (CellFormat)cellFormat);
                }
            }
            case date: {
                try {
                    return new DateTime(column, row, (Date)data, (CellFormat)cellFormat);
                }
                catch (ClassCastException classCastException) {
                    String message = Interpolator.instance().interpolate(ResourceBundle.instance().getString("org.jboss.seam.excel.not_a_date"), new Object[]{data.toString()});
                    return new Label(column, row, message, (CellFormat)cellFormat);
                }
            }
            case formula: {
                return new Formula(column, row, data.toString(), (CellFormat)cellFormat);
            }
            case bool: {
                return new Boolean(column, row, java.lang.Boolean.parseBoolean(data.toString()), (CellFormat)cellFormat);
            }
        }
        return new Label(column, row, data.toString(), (CellFormat)cellFormat);
    }

    public WorkbookSettings createWorkbookSettings(UIWorkbook uiWorkbook) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating workbook settings from #0", new Object[]{uiWorkbook});
        }
        WorkbookSettings workbookSettings = new WorkbookSettings();
        if (uiWorkbook.getArrayGrowSize() != null) {
            workbookSettings.setArrayGrowSize(uiWorkbook.getArrayGrowSize().intValue());
        }
        if (uiWorkbook.getAutoFilterDisabled() != null) {
            workbookSettings.setAutoFilterDisabled(uiWorkbook.getAutoFilterDisabled().booleanValue());
        }
        if (uiWorkbook.getAutoFilterDisabled() != null) {
            workbookSettings.setCellValidationDisabled(uiWorkbook.getAutoFilterDisabled().booleanValue());
        }
        if (uiWorkbook.getCharacterSet() != null) {
            workbookSettings.setCharacterSet(uiWorkbook.getCharacterSet().intValue());
        }
        if (uiWorkbook.getDrawingsDisabled() != null) {
            workbookSettings.setDrawingsDisabled(uiWorkbook.getDrawingsDisabled().booleanValue());
        }
        if (uiWorkbook.getEncoding() != null) {
            workbookSettings.setEncoding(uiWorkbook.getEncoding());
        }
        if (uiWorkbook.getExcelDisplayLanguage() != null) {
            workbookSettings.setExcelDisplayLanguage(uiWorkbook.getExcelDisplayLanguage());
        }
        if (uiWorkbook.getExcelRegionalSettings() != null) {
            workbookSettings.setExcelRegionalSettings(uiWorkbook.getExcelRegionalSettings());
        }
        if (uiWorkbook.getFormulaAdjust() != null) {
            workbookSettings.setFormulaAdjust(uiWorkbook.getFormulaAdjust().booleanValue());
        }
        if (uiWorkbook.getGcDisabled() != null) {
            workbookSettings.setGCDisabled(uiWorkbook.getGcDisabled().booleanValue());
        }
        if (uiWorkbook.getIgnoreBlanks() != null) {
            workbookSettings.setIgnoreBlanks(uiWorkbook.getIgnoreBlanks().booleanValue());
        }
        if (uiWorkbook.getLocale() != null) {
            workbookSettings.setLocale(new Locale(uiWorkbook.getLocale()));
        }
        if (uiWorkbook.getMergedCellCheckingDisabled() != null) {
            workbookSettings.setMergedCellChecking(uiWorkbook.getMergedCellCheckingDisabled().booleanValue());
        }
        if (uiWorkbook.getNamesDisabled() != null) {
            workbookSettings.setNamesDisabled(uiWorkbook.getNamesDisabled().booleanValue());
        }
        if (uiWorkbook.getPropertySets() != null) {
            workbookSettings.setPropertySets(uiWorkbook.getPropertySets().booleanValue());
        }
        if (uiWorkbook.getRationalization() != null) {
            workbookSettings.setRationalization(uiWorkbook.getRationalization().booleanValue());
        }
        if (uiWorkbook.getSupressWarnings() != null) {
            workbookSettings.setSuppressWarnings(uiWorkbook.getSupressWarnings().booleanValue());
        }
        if (uiWorkbook.getTemporaryFileDuringWriteDirectory() != null) {
            workbookSettings.setTemporaryFileDuringWriteDirectory(new File(uiWorkbook.getTemporaryFileDuringWriteDirectory()));
        }
        if (uiWorkbook.getUseTemporaryFileDuringWrite() != null) {
            workbookSettings.setUseTemporaryFileDuringWrite(uiWorkbook.getUseTemporaryFileDuringWrite().booleanValue());
        }
        return workbookSettings;
    }

    public void applyColumnSettings(UIColumn uiColumn, WritableSheet worksheet, int columnIndex) {
        ColumnStyle columnStyle = new ColumnStyle(this.parser.getCascadedStyleMap((UIComponent)uiColumn));
        if (log.isTraceEnabled()) {
            log.trace((Object)"Applying column settings #0 on column #1", new Object[]{columnStyle, columnIndex});
        }
        CellView cellView = worksheet.getColumnView(columnIndex);
        if (columnStyle.autoSize != null) {
            cellView.setAutosize(columnStyle.autoSize.booleanValue());
        }
        if (columnStyle.hidden != null) {
            cellView.setHidden(columnStyle.hidden.booleanValue());
        }
        if (columnStyle.width != null) {
            cellView.setSize(columnStyle.width.intValue());
        }
        worksheet.setColumnView(columnIndex, cellView);
    }
}

