/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class EclipseClasspathTask
extends Task {
    private String file;
    private String toFile;
    private String filterProperty;
    private List<Path> paths = new ArrayList<Path>();

    public void execute() throws BuildException {
        Path uberPath = new Path(this.getProject());
        for (Path path : this.paths) {
            uberPath.add(path);
        }
        String eclipsepaths = "";
        for (String path : uberPath.list()) {
            if (path.contains("jboss-seam")) continue;
            String sourcePath = path.substring(0, path.lastIndexOf(".jar")) + "-sources.jar";
            String javadocPath = path.substring(0, path.lastIndexOf(".jar")) + "-javadoc.jar";
            String eclipsepath = "\t<classpathentry kind=\"lib\" path=\"" + path + "\"";
            if (new File(sourcePath).exists()) {
                eclipsepath = eclipsepath + " sourcepath=\"" + sourcePath + "\"";
            }
            if (new File(javadocPath).exists()) {
                eclipsepath = eclipsepath + ">\r\n";
                eclipsepath = eclipsepath + "\t\t<attributes>\n";
                eclipsepath = eclipsepath + "\t\t\t<attribute name=\"javadoc_location\" value=\"jar:file:" + javadocPath + "!/\"/>\n";
                eclipsepath = eclipsepath + "\t\t</attributes>\n";
                eclipsepath = eclipsepath + "\t</classpathentry>\n";
            } else {
                eclipsepath = eclipsepath + "/>\r\n";
            }
            eclipsepaths = eclipsepaths + eclipsepath;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(this.file)));
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.toFile)));
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.contains(this.filterProperty)) {
                    line = line.replace("@" + this.filterProperty + "@", eclipsepaths);
                }
                writer.write(line + "\r\n");
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setToFile(String toFile) {
        this.toFile = toFile;
    }

    public void setFilterProperty(String filterProperty) {
        this.filterProperty = filterProperty;
    }

    public void addPath(Path path) {
        this.paths.add(path);
    }
}

