/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.guice;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.ioc.guice.injector")
@Scope(value=ScopeType.APPLICATION)
@Startup
@Install(value=false, precedence=10)
public class Injector
implements Serializable {
    private static final long serialVersionUID = 8935525407647910950L;
    private static final LogProvider log = Logging.getLogProvider(Injector.class);
    private String[] modules;
    private com.google.inject.Injector injector = null;

    @Unwrap
    public com.google.inject.Injector getInjector() {
        return this.injector;
    }

    @Create
    public void createInjector() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.modules == null || this.modules.length == 0) {
            throw new IllegalArgumentException("No Guice module specified.");
        }
        log.debug((Object)("Creating injector ''from modules: " + Arrays.toString(this.modules)));
        List<Module> moduleList = Injector.getModuleList(this.modules);
        this.injector = Guice.createInjector(moduleList);
    }

    private static List<Module> getModuleList(String[] modules) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        ArrayList<Module> moduleList = new ArrayList<Module>();
        String[] stringArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            Module module = Injector.getModule(m);
            moduleList.add(module);
            ++n2;
        }
        return moduleList;
    }

    private static Module getModule(String className) {
        try {
            Class<?> clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            return (Module)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create guice module: " + className, e);
        }
    }

    public String[] getModules() {
        return this.modules;
    }

    public void setModules(String[] modules) {
        this.modules = modules;
    }
}

