/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Init;
import org.jboss.seam.ioc.spring.SeamScope;
import org.jboss.seam.ioc.spring.SpringComponent;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;

public class SeamScopePostProcessor
implements BeanFactoryPostProcessor,
InitializingBean {
    private static final LogProvider log = Logging.getLogProvider(SeamScopePostProcessor.class);
    public static final String DEFAULT_SCOPE_PREFIX = "seam.";
    private String prefix;
    private boolean defaultAutoCreate = false;

    public void afterPropertiesSet() throws Exception {
        if (this.prefix == null || "".equals(this.prefix)) {
            this.prefix = DEFAULT_SCOPE_PREFIX;
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ScopeType[] scopeTypeArray = ScopeType.values();
        int n = scopeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScopeType scope = scopeTypeArray[n2];
            if (scope != ScopeType.UNSPECIFIED) {
                beanFactory.registerScope(String.valueOf(this.prefix) + scope.name(), (Scope)new SeamScope(scope));
                beanFactory.registerScope(String.valueOf(this.prefix) + scope.name().toLowerCase(), (Scope)new SeamScope(scope));
            }
            ++n2;
        }
        boolean unmockApplication = false;
        if (!Contexts.isApplicationContextActive()) {
            Lifecycle.setupApplication();
            unmockApplication = true;
        }
        try {
            String[] stringArray = beanFactory.getBeanDefinitionNames();
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String beanName = stringArray[n];
                BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
                if (!definition.getScope().startsWith(this.prefix)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No scope could be derived for bean with name: " + beanName));
                    }
                } else {
                    ScopeType scope = ScopeType.valueOf((String)definition.getScope().replaceFirst(this.prefix, "").toUpperCase());
                    if (scope == ScopeType.UNSPECIFIED) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Discarding bean with scope UNSPECIFIED.  Spring will throw an error later: " + beanName));
                        }
                    } else if (definition.getBeanClassName() == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Unable to create component for bean: " + beanName + ".  No class defined try seam:component instead."));
                        }
                    } else {
                        SpringComponent.addSpringComponent(beanName, beanName, definition.getBeanClassName(), scope, (BeanFactory)beanFactory, null);
                        if (this.defaultAutoCreate) {
                            Init.instance().addAutocreateVariable(beanName);
                        }
                    }
                }
                ++n;
            }
        }
        finally {
            if (unmockApplication) {
                Lifecycle.cleanupApplication();
            }
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDefaultAutoCreate(boolean defaultAutoCreate) {
        this.defaultAutoCreate = defaultAutoCreate;
    }
}

