/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.Barcode39;
import com.lowagie.text.pdf.BarcodeCodabar;
import com.lowagie.text.pdf.BarcodeEAN;
import com.lowagie.text.pdf.BarcodeInter25;
import com.lowagie.text.pdf.BarcodePostnet;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.imageio.ImageIO;
import org.jboss.seam.core.Manager;
import org.jboss.seam.pdf.ITextUtils;
import org.jboss.seam.pdf.ui.ITextComponent;
import org.jboss.seam.pdf.ui.UIDocument;
import org.jboss.seam.ui.graphicImage.GraphicImageStore;
import org.jboss.seam.ui.graphicImage.Image;

public class UIBarCode
extends ITextComponent {
    private Barcode barcode;
    private Object itextObject;
    private String type;
    private String code;
    private String codeType;
    private Float xpos;
    private Float ypos;
    private Float rotDegrees;
    private String altText;
    private Float barHeight;
    private Float textSize;
    private Float minBarWidth;
    private Float barMultiplier;
    String barColor;
    String textColor;

    public String getCode() {
        return (String)this.valueBinding("code", this.code);
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return (String)this.valueBinding("type", this.type);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCodeType() {
        return (String)this.valueBinding("codeType", this.codeType);
    }

    public void setCodeType(String codeType) {
        this.codeType = codeType;
    }

    public Float getRotDegrees() {
        return (Float)this.valueBinding("rotDegrees", this.rotDegrees);
    }

    public void setRotDegrees(Float rotDegrees) {
        this.rotDegrees = rotDegrees;
    }

    public Float getXpos() {
        return (Float)this.valueBinding("xpos", this.xpos);
    }

    public void setXpos(Float xpos) {
        this.xpos = xpos;
    }

    public Float getYpos() {
        return (Float)this.valueBinding("ypos", this.ypos);
    }

    public void setYpos(Float ypos) {
        this.ypos = ypos;
    }

    public String getAltText() {
        return (String)this.valueBinding("altText", this.altText);
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public Float getBarHeight() {
        return (Float)this.valueBinding("barHeight", this.barHeight);
    }

    public void setBarHeight(Float barHeight) {
        this.barHeight = barHeight;
    }

    public Float getBarMultiplier() {
        return (Float)this.valueBinding("barMultiplier", this.barMultiplier);
    }

    public void setBarMultiplier(Float barMultiplier) {
        this.barMultiplier = barMultiplier;
    }

    public Float getMinBarWidth() {
        return (Float)this.valueBinding("minBarWidth", this.minBarWidth);
    }

    public void setMinBarWidth(Float minBarWidth) {
        this.minBarWidth = minBarWidth;
    }

    public Float getTextSize() {
        return (Float)this.valueBinding("textSize", this.textSize);
    }

    public void setTextSize(Float textSize) {
        this.textSize = textSize;
    }

    public String getBarColor() {
        return (String)this.valueBinding("barColor", this.barColor);
    }

    public void setBarColor(String barColor) {
        this.barColor = barColor;
    }

    public String getTextColor() {
        return (String)this.valueBinding("textColor", this.textColor);
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.type = (String)values[1];
        this.code = (String)values[2];
        this.xpos = (Float)values[5];
        this.ypos = (Float)values[6];
        this.rotDegrees = (Float)values[7];
        this.altText = (String)values[8];
        this.barHeight = (Float)values[9];
        this.textSize = (Float)values[10];
        this.minBarWidth = (Float)values[11];
        this.barMultiplier = (Float)values[12];
        this.codeType = (String)values[13];
        this.barColor = (String)values[14];
        this.textColor = (String)values[15];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[16];
        values[0] = super.saveState(context);
        values[1] = this.type;
        values[2] = this.code;
        values[5] = this.xpos;
        values[6] = this.ypos;
        values[7] = this.rotDegrees;
        values[8] = this.altText;
        values[9] = this.barHeight;
        values[10] = this.textSize;
        values[11] = this.minBarWidth;
        values[12] = this.barMultiplier;
        values[13] = this.codeType;
        values[14] = this.barColor;
        values[15] = this.textColor;
        return values;
    }

    public Object getITextObject() {
        return this.itextObject;
    }

    public void createITextObject(FacesContext context) {
        UIDocument doc;
        this.barcode = this.createBarcodeType(this.getType());
        this.barcode.setCode(this.getCode());
        Integer codeVal = this.lookupCodeType(this.getCodeType());
        if (codeVal != null) {
            this.barcode.setCodeType(codeVal.intValue());
        }
        if (this.getAltText() != null) {
            this.barcode.setAltText(this.getAltText());
        }
        if (this.getBarHeight() != null) {
            this.barcode.setBarHeight(this.getBarHeight().floatValue());
        }
        if (this.getBarMultiplier() != null) {
            this.barcode.setN(this.getBarMultiplier().floatValue());
        }
        if (this.getMinBarWidth() != null) {
            this.barcode.setX(this.getMinBarWidth().floatValue());
        }
        if ((doc = (UIDocument)this.findITextParent(this.getParent(), UIDocument.class)) != null) {
            PdfWriter writer = (PdfWriter)doc.getWriter();
            PdfContentByte cb = writer.getDirectContent();
            com.lowagie.text.Image image = this.barcode.createImageWithBarcode(cb, ITextUtils.colorValue(this.getBarColor()), ITextUtils.colorValue(this.getTextColor()));
            if (this.getRotDegrees() != null) {
                image.setRotationDegrees(this.getRotDegrees().floatValue());
            }
            if (this.getXpos() != null && this.getYpos() != null) {
                image.setAbsolutePosition(this.getXpos().floatValue(), this.getYpos().floatValue());
            }
            this.itextObject = image;
        } else {
            Color bars = ITextUtils.colorValue(this.getBarColor());
            if (bars == null) {
                bars = Color.BLACK;
            }
            try {
                byte[] imageData = UIBarCode.imageToByteArray(this.barcode.createAwtImage(bars, Color.WHITE));
                this.itextObject = new GraphicImageStore.ImageWrapper(imageData, Image.Type.IMAGE_JPEG);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Integer lookupCodeType(String codeType) {
        if (codeType == null || codeType.length() == 0) {
            return null;
        }
        try {
            Field field = Barcode.class.getDeclaredField(codeType.toUpperCase());
            return field.getInt(Barcode.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Barcode createBarcodeType(String barcodeType) {
        if (barcodeType == null || barcodeType.length() == 0) {
            return new Barcode128();
        }
        if (barcodeType.equalsIgnoreCase("code128")) {
            return new Barcode128();
        }
        if (barcodeType.equalsIgnoreCase("code39")) {
            return new Barcode39();
        }
        if (barcodeType.equalsIgnoreCase("codabar")) {
            return new BarcodeCodabar();
        }
        if (barcodeType.equalsIgnoreCase("ean")) {
            return new BarcodeEAN();
        }
        if (barcodeType.equalsIgnoreCase("inter25")) {
            return new BarcodeInter25();
        }
        if (barcodeType.equalsIgnoreCase("postnet")) {
            return new BarcodePostnet();
        }
        throw new RuntimeException("Unknown barcode type " + barcodeType);
    }

    public void removeITextObject() {
        this.itextObject = null;
    }

    public void handleAdd(Object other) {
        throw new RuntimeException("can't add " + other.getClass().getName() + " to barcode");
    }

    public static byte[] imageToByteArray(Image image) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D gc = bufferedImage.createGraphics();
        gc.drawImage(image, 0, 0, null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "jpeg", stream);
        return stream.toByteArray();
    }

    public void noITextParentFound() {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            ResponseWriter response = context.getResponseWriter();
            response.startElement("img", null);
            GraphicImageStore store = GraphicImageStore.instance();
            String key = store.put((GraphicImageStore.ImageWrapper)this.itextObject);
            String url = context.getExternalContext().getRequestContextPath() + "/seam/resource/graphicImage" + "/" + key + Image.Type.IMAGE_JPEG.getExtension();
            response.writeAttribute("src", (Object)url, null);
            response.endElement("img");
            Manager.instance().beforeRedirect();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

