/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.jboss.seam.pdf.ui.ITextComponent;
import org.jboss.seam.pdf.ui.UIChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;

public class UIChartSeries
extends ITextComponent {
    private String key;
    private String seriesPaint;
    private String seriesFillPaint;
    private String seriesOutlinePaint;
    private String seriesOutlineStroke;
    private String seriesStroke;
    private Boolean seriesVisible;
    private Boolean seriesVisibleInLegend;

    public String getKey() {
        return (String)this.valueBinding("key", this.key);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSeriesPaint() {
        return (String)this.valueBinding("seriesPaint", this.seriesPaint);
    }

    public void setSeriesPaint(String seriesPaint) {
        this.seriesPaint = seriesPaint;
    }

    public String getSeriesFillPaint() {
        return (String)this.valueBinding("seriesFillPaint", this.seriesFillPaint);
    }

    public void setSeriesFillPaint(String seriesFillPaint) {
        this.seriesFillPaint = seriesFillPaint;
    }

    public String getSeriesOutlinePaint() {
        return (String)this.valueBinding("seriesOutlinePaint", this.seriesOutlinePaint);
    }

    public void setSeriesOutlinePaint(String seriesOutlinePaint) {
        this.seriesOutlinePaint = seriesOutlinePaint;
    }

    public String getSeriesOutlineStroke() {
        return (String)this.valueBinding("seriesOutlineStroke", this.seriesOutlineStroke);
    }

    public void setSeriesOutlineStroke(String seriesOutlineStroke) {
        this.seriesOutlineStroke = seriesOutlineStroke;
    }

    public String getSeriesStroke() {
        return (String)this.valueBinding("seriesStroke", this.seriesStroke);
    }

    public void setSeriesStroke(String seriesStroke) {
        this.seriesStroke = seriesStroke;
    }

    public Boolean getSeriesVisible() {
        return (Boolean)this.valueBinding("seriesVisible", this.seriesVisible);
    }

    public void setSeriesVisible(Boolean seriesVisible) {
        this.seriesVisible = seriesVisible;
    }

    public Boolean getSeriesVisibleInLegend() {
        return (Boolean)this.valueBinding("seriesVisibleInLegend", this.seriesVisibleInLegend);
    }

    public void setSeriesVisibleInLegend(Boolean seriesVisibleInLegend) {
        this.seriesVisibleInLegend = seriesVisibleInLegend;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.key = (String)values[1];
        this.seriesPaint = (String)values[2];
        this.seriesFillPaint = (String)values[3];
        this.seriesOutlinePaint = (String)values[4];
        this.seriesOutlineStroke = (String)values[5];
        this.seriesStroke = (String)values[6];
        this.seriesVisible = (Boolean)values[7];
        this.seriesVisibleInLegend = (Boolean)values[8];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.key, this.seriesPaint, this.seriesFillPaint, this.seriesOutlinePaint, this.seriesOutlineStroke, this.seriesStroke, this.seriesVisible, this.seriesVisibleInLegend};
        return values;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        Plot p;
        UIChart chart = (UIChart)this.findITextParent(this.getParent(), UIChart.class);
        Dataset dataset = chart.getDataset();
        if (chart != null && (p = chart.getChart().getPlot()) instanceof CategoryPlot) {
            CategoryPlot plot = (CategoryPlot)p;
            int seriesIndex = ((CategoryDataset)dataset).getRowIndex((Comparable)((Object)this.getKey()));
            CategoryItemRenderer renderer = plot.getRenderer();
            if (renderer instanceof AbstractRenderer) {
                this.configureSeries((AbstractRenderer)renderer, seriesIndex);
            } else {
                System.out.println("render is not AbtractRenderer" + renderer);
            }
        }
    }

    private void configureSeries(AbstractRenderer renderer, int seriesIndex) {
        if (this.getSeriesPaint() != null) {
            renderer.setSeriesPaint(seriesIndex, UIChart.findColor(this.getSeriesPaint()));
        }
        if (this.getSeriesFillPaint() != null) {
            renderer.setSeriesFillPaint(seriesIndex, UIChart.findColor(this.getSeriesFillPaint()));
        }
        if (this.getSeriesOutlinePaint() != null) {
            renderer.setSeriesOutlinePaint(seriesIndex, UIChart.findColor(this.getSeriesOutlinePaint()));
        }
        if (this.getSeriesOutlineStroke() != null) {
            renderer.setSeriesOutlineStroke(seriesIndex, UIChart.findStroke(this.getSeriesOutlineStroke()));
        }
        if (this.getSeriesStroke() != null) {
            renderer.setSeriesStroke(seriesIndex, UIChart.findStroke(this.getSeriesStroke()));
        }
        if (this.getSeriesVisible() != null) {
            renderer.setSeriesVisible(seriesIndex, this.getSeriesVisible());
        }
        if (this.getSeriesVisibleInLegend() != null) {
            renderer.setSeriesVisibleInLegend(seriesIndex, this.getSeriesVisibleInLegend());
        }
    }

    public void createITextObject(FacesContext context) {
    }

    public Object getITextObject() {
        return null;
    }

    public void removeITextObject() {
    }

    public void handleAdd(Object other) {
    }
}

