/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Manager;
import org.jboss.seam.document.DocumentData;
import org.jboss.seam.document.DocumentStore;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pdf.ui.FormComponent;

public class UIForm
extends FormComponent {
    public static final String COMPONENT_FAMILY = "org.jboss.seam.pdf.UIForm";
    private Log log = Logging.getLog(((Object)((Object)this)).getClass());
    private String URL;
    private String filename;
    private String exportKey;
    PdfReader reader;
    PdfStamper stamper;
    AcroFields fields;
    ByteArrayOutputStream buffer;

    public String getURL() {
        return (String)this.valueOf("URL", this.URL);
    }

    public void setURL(String url) {
        this.URL = url;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        this.reader = this.getURL().indexOf("://") < 0 ? new PdfReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getURL())) : new PdfReader(new URL(this.getURL()));
        this.log.debug((Object)"Loading template #0", new Object[]{this.getURL()});
        this.buffer = new ByteArrayOutputStream();
        try {
            this.stamper = new PdfStamper(this.reader, (OutputStream)this.buffer);
            Contexts.getEventContext().set("acrostamper", (Object)this.stamper);
        }
        catch (DocumentException e) {
            throw new FacesException("Could not create PDF stamper", (Throwable)e);
        }
        this.fields = this.stamper.getAcroFields();
        Contexts.getEventContext().set("acrofields", (Object)this.fields);
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        UIComponent parent;
        this.stamper.setFormFlattening(true);
        try {
            this.stamper.close();
        }
        catch (DocumentException e) {
            throw new FacesException("Could not flush PDF", (Throwable)e);
        }
        if (this.getExportKey() == null && (parent = this.getParent()) != null && parent instanceof ValueHolder) {
            this.log.debug((Object)"Storing PDF data in ValueHolder parent", new Object[0]);
            ValueHolder valueHolder = (ValueHolder)parent;
            valueHolder.setValue((Object)this.buffer.toByteArray());
            return;
        }
        String viewId = Pages.getViewId((FacesContext)facesContext);
        String baseName = UIForm.baseNameForViewId(viewId);
        DocumentStore store = DocumentStore.instance();
        DocumentData.DocumentType documentType = new DocumentData.DocumentType("pdf", "application/pdf");
        DocumentData documentData = new DocumentData(baseName, documentType, this.buffer.toByteArray());
        documentData.setFilename(this.getFilename());
        if (this.getExportKey() != null) {
            this.log.debug((Object)"Exporting PDF data to event key #0", new Object[]{this.getExportKey()});
            Contexts.getEventContext().set(this.getExportKey(), (Object)documentData);
            return;
        }
        String id = store.newId();
        String url = store.preferredUrlForContent(baseName, documentType.getExtension(), id);
        url = Manager.instance().encodeConversationId(url, viewId);
        store.saveData(id, documentData);
        this.log.debug((Object)"Redirecting to #0 for PDF view", new Object[]{url});
        facesContext.getExternalContext().redirect(url);
    }

    public static String baseNameForViewId(String viewId) {
        int pos = viewId.lastIndexOf("/");
        if (pos != -1) {
            viewId = viewId.substring(pos + 1);
        }
        if ((pos = viewId.lastIndexOf(".")) != -1) {
            viewId = viewId.substring(0, pos);
        }
        return viewId;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getFilename() {
        return (String)this.valueOf("filename", this.filename);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getExportKey() {
        return (String)this.valueOf("exportKey", this.exportKey);
    }

    public void setExportKey(String exportKey) {
        this.exportKey = exportKey;
    }
}

