/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.rtf.RtfWriter2;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import org.jboss.seam.core.Manager;
import org.jboss.seam.document.ByteArrayDocumentData;
import org.jboss.seam.document.DocumentData;
import org.jboss.seam.document.DocumentStore;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pdf.ITextUtils;
import org.jboss.seam.pdf.ui.ITextComponent;
import org.jboss.seam.pdf.ui.UISignature;

public class UIDocument
extends ITextComponent {
    public static final String COMPONENT_TYPE = "org.jboss.seam.pdf.ui.UIDocument";
    public static DocumentData.DocumentType PDF = new DocumentData.DocumentType("pdf", "application/pdf");
    public static DocumentData.DocumentType RTF = new DocumentData.DocumentType("rtf", "text/rtf");
    public static DocumentData.DocumentType HTML = new DocumentData.DocumentType("html", "text/html");
    DocWriter writer;
    Document document;
    ByteArrayOutputStream stream;
    DocumentData.DocumentType documentType;
    String type;
    String title;
    String subject;
    String keywords;
    String author;
    String creator;
    String orientation;
    String pageSize;
    String margins;
    Boolean marginMirroring;
    String disposition;
    String fileName;
    boolean sendRedirect = true;
    UISignature signatureField;

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMargins(String margins) {
        this.margins = margins;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public void setMarginMirroring(Boolean marginMirroring) {
        this.marginMirroring = marginMirroring;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public void setSendRedirect(boolean sendRedirect) {
        this.sendRedirect = sendRedirect;
    }

    public boolean getSendRedirect() {
        return this.sendRedirect;
    }

    public Object getITextObject() {
        return this.document;
    }

    public void createITextObject(FacesContext context) {
        this.type = (String)this.valueBinding(context, "type", this.type);
        this.documentType = this.documentTypeForName(this.type);
        this.document = new Document();
        this.pageSize = (String)this.valueBinding(context, "pageSize", this.pageSize);
        if (this.pageSize != null) {
            this.document.setPageSize(ITextUtils.pageSizeValue(this.pageSize));
        }
        this.orientation = (String)this.valueBinding(context, "orientation", this.orientation);
        if (this.orientation != null && !this.orientation.equalsIgnoreCase("portrait")) {
            if (this.orientation.equalsIgnoreCase("landscape")) {
                Rectangle currentSize = this.document.getPageSize();
                this.document.setPageSize(new Rectangle(currentSize.getHeight(), currentSize.getWidth()));
            } else {
                throw new RuntimeException("orientation value " + this.orientation + "unknown");
            }
        }
        this.margins = (String)this.valueBinding(context, "margins", this.margins);
        if (this.margins != null) {
            float[] vals = ITextUtils.stringToFloatArray(this.margins);
            if (vals.length != 4) {
                throw new RuntimeException("margins must contain 4 float values");
            }
            this.document.setMargins(vals[0], vals[1], vals[2], vals[3]);
        }
        this.marginMirroring = (Boolean)this.valueBinding(context, "marginMirroring", this.marginMirroring);
        if (this.marginMirroring != null) {
            this.document.setMarginMirroring(this.marginMirroring.booleanValue());
        }
    }

    protected void initMetaData(FacesContext context) {
        this.title = (String)this.valueBinding(context, "title", this.title);
        if (this.title != null) {
            this.document.addTitle(this.title);
        }
        this.subject = (String)this.valueBinding(context, "subject", this.subject);
        if (this.subject != null) {
            this.document.addSubject(this.subject);
        }
        this.keywords = (String)this.valueBinding(context, "keywords", this.keywords);
        if (this.keywords != null) {
            this.document.addKeywords(this.keywords);
        }
        this.author = (String)this.valueBinding(context, "author", this.author);
        if (this.author != null) {
            this.document.addAuthor(this.author);
        }
        this.creator = (String)this.valueBinding(context, "creator", this.creator);
        if (this.creator != null) {
            this.document.addCreator(this.creator);
        }
    }

    public void removeITextObject() {
        this.document = null;
    }

    public void handleAdd(Object o) {
        if (o instanceof Element) {
            try {
                this.document.add((Element)o);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("cannot add " + o);
        }
    }

    public void addSignature(UISignature signatureField) {
        this.signatureField = signatureField;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.stream = new ByteArrayOutputStream();
        try {
            this.writer = this.createWriterForStream(this.stream);
            this.initMetaData(context);
            this.processHeaders();
            this.document.open();
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processHeaders() {
        UIComponent facet = this.getFacet("header");
        if (facet == null) {
            return;
        }
        try {
            this.encode(FacesContext.getCurrentInstance(), facet);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        String fileNameValue;
        this.document.resetHeader();
        this.document.resetFooter();
        this.document.close();
        byte[] bytes = this.stream.toByteArray();
        if (this.signatureField != null) {
            bytes = this.signatureField.sign(bytes);
        }
        String viewId = Pages.getViewId((FacesContext)context);
        String baseName = Pages.getCurrentBaseName();
        ByteArrayDocumentData documentData = new ByteArrayDocumentData(baseName, this.documentType, bytes);
        String dispositionValue = (String)this.valueBinding(context, "disposition", this.disposition);
        if (dispositionValue != null) {
            documentData.setDisposition(dispositionValue);
        }
        if ((fileNameValue = (String)this.valueBinding(context, "fileName", this.fileName)) != null) {
            documentData.setFilename(fileNameValue);
        }
        if (this.sendRedirect) {
            DocumentStore store = DocumentStore.instance();
            String id = store.newId();
            String url = store.preferredUrlForContent(baseName, this.documentType.getExtension(), id);
            url = Manager.instance().encodeConversationId(url, viewId);
            store.saveData(id, (DocumentData)documentData);
            this.removeITextObject();
            context.getExternalContext().redirect(url);
        } else {
            UIComponent parent = this.getParent();
            if (parent instanceof ValueHolder) {
                ValueHolder holder = (ValueHolder)parent;
                holder.setValue((Object)documentData);
            }
        }
    }

    public DocWriter getWriter() {
        return this.writer;
    }

    public PdfContentByte getPdfContent() {
        PdfWriter writer = (PdfWriter)this.getWriter();
        return writer.getDirectContent();
    }

    public PdfTemplate createPdfTemplate(float width, float height) {
        return this.getPdfContent().createTemplate(width, height);
    }

    private DocumentData.DocumentType documentTypeForName(String typeName) {
        if (typeName != null) {
            if (typeName.equalsIgnoreCase("pdf")) {
                return PDF;
            }
            if (typeName.equalsIgnoreCase("rtf")) {
                return RTF;
            }
            if (typeName.equalsIgnoreCase("html")) {
                return HTML;
            }
        }
        return PDF;
    }

    protected DocWriter createWriterForStream(OutputStream stream) throws DocumentException {
        if (this.documentType == PDF) {
            return PdfWriter.getInstance((Document)this.document, (OutputStream)stream);
        }
        if (this.documentType == RTF) {
            return RtfWriter2.getInstance((Document)this.document, (OutputStream)stream);
        }
        if (this.documentType == HTML) {
            return HtmlWriter.getInstance((Document)this.document, (OutputStream)stream);
        }
        throw new IllegalArgumentException("unknown document type");
    }
}

