/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.xml.simpleparser.EntitiesToUnicode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.pdf.ui.UIDocument;
import org.jboss.seam.pdf.ui.UIFont;
import org.jboss.seam.ui.util.JSF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ITextComponent
extends UIComponentBase {
    public static final String COMPONENT_FAMILY = "org.jboss.seam.pdf";
    protected String inFacet;
    protected Object currentFacet;

    public abstract Object getITextObject();

    public abstract void createITextObject(FacesContext var1) throws IOException, DocumentException;

    public abstract void removeITextObject();

    public abstract void handleAdd(Object var1);

    public final void add(Object other) {
        if (this.inFacet != null) {
            this.handleFacet(this.inFacet, other);
        } else {
            this.handleAdd(other);
        }
    }

    public void handleFacet(String facetName, Object obj) {
        this.currentFacet = obj;
    }

    public Font getFont() {
        UIFont fontComponent = (UIFont)this.findITextParent((UIComponent)this, UIFont.class);
        return fontComponent == null ? null : fontComponent.getFont();
    }

    public Document findDocument() {
        ITextComponent parent = this.findITextParent((UIComponent)this, UIDocument.class);
        if (parent != null) {
            return (Document)parent.getITextObject();
        }
        return null;
    }

    public ITextComponent findITextParent(UIComponent parent) {
        return this.findITextParent(parent, null);
    }

    public ITextComponent findITextParent(UIComponent parent, Class<?> c) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof ITextComponent && (c == null || c.isAssignableFrom(parent.getClass()))) {
            return (ITextComponent)parent;
        }
        return this.findITextParent(parent.getParent(), c);
    }

    public void addToITextParent(Object obj) {
        ITextComponent parent = this.findITextParent(this.getParent());
        if (parent != null) {
            parent.add(obj);
        } else {
            this.noITextParentFound();
        }
    }

    public void noITextParentFound() {
        throw new RuntimeException("Couldn't find ITextComponent parent for component " + ((Object)((Object)this)).getClass().getName());
    }

    public Object processFacet(String facetName) {
        if (this.inFacet != null && this.inFacet.equals(facetName)) {
            return null;
        }
        UIComponent facet = this.getFacet(facetName);
        Object result = null;
        if (facet != null) {
            this.currentFacet = null;
            this.inFacet = facetName;
            try {
                try {
                    this.encode(FacesContext.getCurrentInstance(), facet);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.inFacet = null;
                result = this.currentFacet;
                this.currentFacet = null;
            }
        }
        return result;
    }

    public Object valueBinding(FacesContext context, String property, Object defaultValue) {
        Object value = defaultValue;
        ValueExpression expression = this.getValueExpression(property);
        if (expression != null) {
            value = expression.getValue(context.getELContext());
        }
        return value;
    }

    public Object valueBinding(String property, Object defaultValue) {
        return this.valueBinding(FacesContext.getCurrentInstance(), property, defaultValue);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        try {
            this.createITextObject(context);
        }
        catch (DocumentException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        Object obj = this.getITextObject();
        if (obj != null) {
            this.addToITextParent(this.getITextObject());
        }
        this.removeITextObject();
    }

    public void encodeChildren(FacesContext context) throws IOException {
        for (UIComponent child : this.getChildren()) {
            if (child.getFamily().equals("facelets.LiteralText")) {
                String text = EntitiesToUnicode.decodeString((String)this.extractText(context, child));
                Font font = this.getFont();
                Chunk chunk = null;
                chunk = font == null ? new Chunk(text) : new Chunk(text, this.getFont());
                this.add(chunk);
                continue;
            }
            this.encode(context, child);
        }
    }

    public String extractText(FacesContext context, UIComponent child) throws IOException {
        ResponseWriter response = context.getResponseWriter();
        StringWriter stringWriter = new StringWriter();
        ResponseWriter cachingResponseWriter = response.cloneWithWriter((Writer)stringWriter);
        context.setResponseWriter(cachingResponseWriter);
        JSF.renderChild((FacesContext)context, (UIComponent)child);
        context.setResponseWriter(response);
        return stringWriter.getBuffer().toString();
    }

    public void encode(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getChildCount() > 0) {
            if (component.getRendersChildren()) {
                component.encodeChildren(context);
            } else {
                for (UIComponent child : component.getChildren()) {
                    this.encode(context, child);
                }
            }
        }
        component.encodeEnd(context);
    }
}

