/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.Image;
import com.lowagie.text.ImgTemplate;
import com.lowagie.text.pdf.AsianFontMapper;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.pdf.ITextUtils;
import org.jboss.seam.pdf.ui.ITextComponent;
import org.jboss.seam.pdf.ui.UIColor;
import org.jboss.seam.pdf.ui.UIDocument;
import org.jboss.seam.pdf.ui.UIFont;
import org.jboss.seam.pdf.ui.UIStroke;
import org.jboss.seam.ui.graphicImage.GraphicImageStore;
import org.jboss.seam.ui.graphicImage.Image;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.general.Dataset;

public abstract class UIChart
extends ITextComponent {
    private Image image = null;
    private JFreeChart chart = null;
    private byte[] imageData;
    private int height = 300;
    private int width = 400;
    private boolean legend;
    private boolean is3D = false;
    private String title;
    private String borderBackgroundPaint;
    private String borderPaint;
    private String borderStroke;
    private boolean borderVisible = true;
    private String plotBackgroundPaint;
    private Float plotBackgroundAlpha;
    private Float plotForegroundAlpha;
    private String plotOutlineStroke;
    private String plotOutlinePaint;
    protected Dataset dataset;

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return (String)this.valueBinding("title", this.title);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return (Integer)this.valueBinding(FacesContext.getCurrentInstance(), "height", this.height);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return (Integer)this.valueBinding(FacesContext.getCurrentInstance(), "width", this.width);
    }

    public void setLegend(boolean legend) {
        this.legend = legend;
    }

    public boolean getLegend() {
        return (Boolean)this.valueBinding("legend", this.legend);
    }

    public void setIs3D(boolean is3D) {
        this.is3D = true;
    }

    public boolean getIs3D() {
        return (Boolean)this.valueBinding("is3D", this.is3D);
    }

    public void setBorderBackgroundPaint(String backgroundPaint) {
        this.borderBackgroundPaint = backgroundPaint;
    }

    public String getBorderBackgroundPaint() {
        return (String)this.valueBinding(FacesContext.getCurrentInstance(), "borderBackgroundPaint", this.borderBackgroundPaint);
    }

    public void setBorderPaint(String borderPaint) {
        this.borderPaint = borderPaint;
    }

    public String getBorderPaint() {
        return (String)this.valueBinding(FacesContext.getCurrentInstance(), "borderPaint", this.borderPaint);
    }

    public void setBorderStroke(String borderStroke) {
        this.borderStroke = borderStroke;
    }

    public String getBorderStroke() {
        return (String)this.valueBinding(FacesContext.getCurrentInstance(), "borderStroke", this.borderStroke);
    }

    public void setBorderVisible(boolean borderVisible) {
        this.borderVisible = borderVisible;
    }

    public boolean getBorderVisible() {
        return (Boolean)this.valueBinding(FacesContext.getCurrentInstance(), "borderVisible", this.borderVisible);
    }

    public void setPlotBackgroundAlpha(Float plotBackgroundAlpha) {
        this.plotBackgroundAlpha = plotBackgroundAlpha;
    }

    public Float getPlotBackgroundAlpha() {
        return (Float)this.valueBinding(FacesContext.getCurrentInstance(), "plotBackgroundAlpha", this.plotBackgroundAlpha);
    }

    public void setPlotBackgroundPaint(String plotBackgroundPaint) {
        this.plotBackgroundPaint = plotBackgroundPaint;
    }

    public String getPlotBackgroundPaint() {
        return (String)this.valueBinding(FacesContext.getCurrentInstance(), "plotBackgroundPaint", this.plotBackgroundPaint);
    }

    public void setPlotForegroundAlpha(Float plotForegroundAlpha) {
        this.plotForegroundAlpha = plotForegroundAlpha;
    }

    public Float getPlotForegroundAlpha() {
        return (Float)this.valueBinding(FacesContext.getCurrentInstance(), "plotForegroundAlpha", this.plotForegroundAlpha);
    }

    public void setPlotOutlinePaint(String plotOutlinePaint) {
        this.plotOutlinePaint = plotOutlinePaint;
    }

    public String getPlotOutlinePaint() {
        return (String)this.valueBinding(FacesContext.getCurrentInstance(), "plotOutlinePaint", this.plotOutlinePaint);
    }

    public void setPlotOutlineStroke(String plotOutlineStroke) {
        this.plotOutlineStroke = plotOutlineStroke;
    }

    public String getPlotOutlineStroke() {
        return (String)this.valueBinding(FacesContext.getCurrentInstance(), "plotOutlineStroke", this.plotOutlineStroke);
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public Dataset getDataset() {
        return (Dataset)this.valueBinding(FacesContext.getCurrentInstance(), "dataset", this.dataset);
    }

    public void setChart(JFreeChart chart) {
        this.chart = chart;
    }

    public JFreeChart getChart() {
        return (JFreeChart)this.valueBinding(FacesContext.getCurrentInstance(), "chart", this.chart);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.height = (Integer)values[1];
        this.width = (Integer)values[2];
        this.borderBackgroundPaint = (String)values[3];
        this.borderPaint = (String)values[4];
        this.borderStroke = (String)values[5];
        this.borderVisible = (Boolean)values[6];
        this.plotBackgroundPaint = (String)values[7];
        this.plotBackgroundAlpha = (Float)values[8];
        this.plotForegroundAlpha = (Float)values[9];
        this.plotOutlineStroke = (String)values[10];
        this.plotOutlinePaint = (String)values[11];
        this.title = (String)values[12];
        this.is3D = (Boolean)values[13];
        this.legend = (Boolean)values[14];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.height, this.width, this.borderBackgroundPaint, this.borderPaint, this.borderStroke, this.borderVisible, this.plotBackgroundPaint, this.plotBackgroundAlpha, this.plotForegroundAlpha, this.plotOutlineStroke, this.plotOutlinePaint, this.title, this.is3D, this.legend};
        return values;
    }

    public static Paint findColor(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        UIComponent component = FacesContext.getCurrentInstance().getViewRoot().findComponent(name);
        if (component != null) {
            if (component instanceof UIColor) {
                return ((UIColor)component).getPaint();
            }
            throw new RuntimeException();
        }
        return ITextUtils.colorValue(name);
    }

    public static Stroke findStroke(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        UIComponent component = FacesContext.getCurrentInstance().getViewRoot().findComponent(id);
        if (component instanceof UIStroke) {
            return ((UIStroke)component).getStroke();
        }
        throw new RuntimeException();
    }

    public abstract JFreeChart createChart(FacesContext var1);

    @Override
    public void createITextObject(FacesContext context) {
        if (this.getBorderBackgroundPaint() != null) {
            this.chart.setBackgroundPaint(UIChart.findColor(this.getBorderBackgroundPaint()));
        }
        if (this.getBorderPaint() != null) {
            this.chart.setBorderPaint(UIChart.findColor(this.getBorderPaint()));
        }
        if (this.getBorderStroke() != null) {
            this.chart.setBorderStroke(UIChart.findStroke(this.getBorderStroke()));
        }
        this.chart.setBorderVisible(this.getBorderVisible());
        this.configurePlot(this.chart.getPlot());
        try {
            UIDocument doc = (UIDocument)this.findITextParent(this.getParent(), UIDocument.class);
            if (doc != null) {
                PdfWriter writer = (PdfWriter)doc.getWriter();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate tp = cb.createTemplate((float)this.getWidth(), (float)this.getHeight());
                UIFont font = (UIFont)this.findITextParent((UIComponent)this, UIFont.class);
                Object fontMapper = font == null ? new DefaultFontMapper() : new AsianFontMapper(font.getName(), font.getEncoding());
                Graphics2D g2 = tp.createGraphics((float)this.getWidth(), (float)this.getHeight(), (FontMapper)fontMapper);
                this.chart.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
                g2.dispose();
                this.image = new ImgTemplate(tp);
            } else {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ChartUtilities.writeChartAsJPEG((OutputStream)stream, (JFreeChart)this.chart, (int)this.getWidth(), (int)this.getHeight());
                this.imageData = stream.toByteArray();
                stream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void configurePlot(Plot plot) {
        if (this.getPlotBackgroundAlpha() != null) {
            plot.setBackgroundAlpha(this.getPlotBackgroundAlpha().floatValue());
        }
        if (this.getPlotForegroundAlpha() != null) {
            plot.setForegroundAlpha(this.getPlotForegroundAlpha().floatValue());
        }
        if (this.getPlotBackgroundPaint() != null) {
            plot.setBackgroundPaint(UIChart.findColor(this.getPlotBackgroundPaint()));
        }
        if (this.getPlotOutlinePaint() != null) {
            plot.setOutlinePaint(UIChart.findColor(this.getPlotOutlinePaint()));
        }
        if (this.getPlotOutlineStroke() != null) {
            plot.setOutlineStroke(UIChart.findStroke(this.getPlotOutlineStroke()));
        }
    }

    public PlotOrientation plotOrientation(String orientation) {
        if (orientation != null && orientation.equalsIgnoreCase("horizontal")) {
            return PlotOrientation.HORIZONTAL;
        }
        return PlotOrientation.VERTICAL;
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        this.dataset = this.getDataset();
        if (this.dataset == null) {
            this.dataset = this.createDataset();
        }
        this.chart = this.getChart();
        if (this.chart == null) {
            this.chart = this.createChart(context);
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        this.createITextObject(context);
        if (this.imageData != null) {
            ResponseWriter response = context.getResponseWriter();
            response.startElement("img", null);
            GraphicImageStore store = GraphicImageStore.instance();
            String key = store.put(new GraphicImageStore.ImageWrapper(this.imageData, Image.Type.IMAGE_JPEG));
            String url = context.getExternalContext().getRequestContextPath() + "/seam/resource/graphicImage" + "/" + key + Image.Type.IMAGE_JPEG.getExtension();
            response.writeAttribute("src", (Object)url, null);
            response.writeAttribute("height", (Object)this.getHeight(), null);
            response.writeAttribute("width", (Object)this.getWidth(), null);
            response.endElement("img");
        }
        super.encodeEnd(context);
    }

    @Override
    public Object getITextObject() {
        return this.image;
    }

    @Override
    public void handleAdd(Object arg0) {
        throw new RuntimeException("No children allowed");
    }

    @Override
    public void removeITextObject() {
        this.image = null;
        this.chart = null;
    }

    public abstract Dataset createDataset();
}

