/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.remoting.BaseRequestHandler;
import org.jboss.seam.remoting.CallContext;
import org.jboss.seam.remoting.RequestHandler;
import org.jboss.seam.remoting.SubscriptionHandler;
import org.jboss.seam.remoting.messaging.PollError;
import org.jboss.seam.remoting.messaging.PollRequest;
import org.jboss.seam.remoting.wrapper.Wrapper;
import org.jboss.seam.servlet.ContextualHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollHandler
extends BaseRequestHandler
implements RequestHandler {
    private static final LogProvider log = Logging.getLogProvider(SubscriptionHandler.class);
    private static final byte[] ERRORS_TAG_OPEN_START = "<errors token=\"".getBytes();
    private static final byte[] ERRORS_TAG_OPEN_END = "\">".getBytes();
    private static final byte[] ERROR_TAG_OPEN_START = "<error code=\"".getBytes();
    private static final byte[] ERROR_TAG_OPEN_END = "\">".getBytes();
    private static final byte[] ERROR_TAG_CLOSE = "</error>".getBytes();
    private static final byte[] MESSAGES_TAG_OPEN_START = "<messages token=\"".getBytes();
    private static final byte[] MESSAGES_TAG_OPEN_END = "\">".getBytes();
    private static final byte[] MESSAGES_TAG_CLOSE = "</messages>".getBytes();
    private static final byte[] MESSAGE_TAG_OPEN_START = "<message type=\"".getBytes();
    private static final byte[] MESSAGE_TAG_OPEN_END = "\">".getBytes();
    private static final byte[] MESSAGE_TAG_CLOSE = "</message>".getBytes();
    private static final byte[] VALUE_TAG_OPEN = "<value>".getBytes();
    private static final byte[] VALUE_TAG_CLOSE = "</value>".getBytes();

    @Override
    public void handle(HttpServletRequest request, final HttpServletResponse response) throws Exception {
        response.setContentType("text/xml");
        SAXReader xmlReader = new SAXReader();
        Document doc = xmlReader.read((InputStream)request.getInputStream());
        Element env = doc.getRootElement();
        final List<PollRequest> polls = this.unmarshalRequests(env);
        new ContextualHttpServletRequest(request){

            public void process() throws Exception {
                for (PollRequest req : polls) {
                    req.poll();
                }
                PollHandler.this.marshalResponse(polls, (OutputStream)response.getOutputStream());
            }
        }.run();
    }

    private List<PollRequest> unmarshalRequests(Element env) throws Exception {
        try {
            ArrayList<PollRequest> requests = new ArrayList<PollRequest>();
            List requestElements = env.element("body").elements("poll");
            for (Element e : requestElements) {
                requests.add(new PollRequest(e.attributeValue("token"), Integer.parseInt(e.attributeValue("timeout"))));
            }
            return requests;
        }
        catch (Exception ex) {
            log.error((Object)"Error unmarshalling subscriptions from request", (Throwable)ex);
            throw ex;
        }
    }

    private void marshalResponse(List<PollRequest> reqs, OutputStream out) throws IOException {
        out.write(ENVELOPE_TAG_OPEN);
        out.write(BODY_TAG_OPEN);
        for (PollRequest req : reqs) {
            if (req.getErrors() != null && req.getErrors().size() > 0) {
                out.write(ERRORS_TAG_OPEN_START);
                out.write(req.getToken().getBytes());
                out.write(ERRORS_TAG_OPEN_END);
                for (PollError err : req.getErrors()) {
                    this.writeError(err, out);
                }
                continue;
            }
            if (req.getMessages() == null || req.getMessages().size() <= 0) continue;
            out.write(MESSAGES_TAG_OPEN_START);
            out.write(req.getToken().getBytes());
            out.write(MESSAGES_TAG_OPEN_END);
            for (Message m : req.getMessages()) {
                try {
                    this.writeMessage(m, out);
                }
                catch (JMSException jMSException) {
                }
                catch (IOException iOException) {}
            }
            out.write(MESSAGES_TAG_CLOSE);
        }
        out.write(BODY_TAG_CLOSE);
        out.write(ENVELOPE_TAG_CLOSE);
        out.flush();
    }

    private void writeMessage(Message m, OutputStream out) throws IOException, JMSException {
        out.write(MESSAGE_TAG_OPEN_START);
        CallContext ctx = new CallContext();
        Object value = null;
        if (m instanceof TextMessage) {
            out.write("text".getBytes());
            value = ((TextMessage)m).getText();
        } else if (m instanceof ObjectMessage) {
            out.write("object".getBytes());
            value = ((ObjectMessage)m).getObject();
        }
        out.write(MESSAGE_TAG_OPEN_END);
        out.write(VALUE_TAG_OPEN);
        ctx.createWrapperFromObject(value, "").marshal(out);
        out.write(VALUE_TAG_CLOSE);
        out.write(REFS_TAG_OPEN);
        int i = 0;
        while (i < ctx.getOutRefs().size()) {
            Wrapper wrapper = ctx.getOutRefs().get(i);
            out.write(REF_TAG_OPEN_START);
            out.write(Integer.toString(i).getBytes());
            out.write(REF_TAG_OPEN_END);
            wrapper.serialize(out);
            out.write(REF_TAG_CLOSE);
            ++i;
        }
        out.write(REFS_TAG_CLOSE);
        out.write(MESSAGE_TAG_CLOSE);
    }

    private void writeError(PollError error, OutputStream out) throws IOException {
        out.write(ERROR_TAG_OPEN_START);
        out.write(error.getCode().getBytes());
        out.write(ERROR_TAG_OPEN_END);
        out.write(error.getMessage().getBytes());
        out.write(ERROR_TAG_CLOSE);
    }
}

