/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.remoting.ExecutionHandler;
import org.jboss.seam.remoting.InterfaceGenerator;
import org.jboss.seam.remoting.PollHandler;
import org.jboss.seam.remoting.RequestHandler;
import org.jboss.seam.remoting.SubscriptionHandler;

public class RequestHandlerFactory {
    private static final String REQUEST_PATH_EXECUTE = "/execute";
    private static final String REQUEST_PATH_SUBSCRIPTION = "/subscription";
    private static final String REQUEST_PATH_POLL = "/poll";
    private static final String REQUEST_PATH_INTERFACE = "/interface.js";
    private static RequestHandlerFactory instance = new RequestHandlerFactory();
    private Map<String, RequestHandler> handlers = new HashMap<String, RequestHandler>();

    private RequestHandlerFactory() {
        this.registerHandler(REQUEST_PATH_EXECUTE, new ExecutionHandler());
        this.registerHandler(REQUEST_PATH_SUBSCRIPTION, new SubscriptionHandler());
        this.registerHandler(REQUEST_PATH_INTERFACE, new InterfaceGenerator());
        try {
            Class.forName("javax.jms.Message");
            this.registerHandler(REQUEST_PATH_POLL, new PollHandler());
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public void registerHandler(String path, RequestHandler handler) {
        this.handlers.put(path, handler);
    }

    public RequestHandler getRequestHandler(String path) {
        return this.handlers.get(path);
    }

    public static RequestHandlerFactory getInstance() {
        return instance;
    }
}

