/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.server.resourcefactory.POJOResourceFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.StringConverter;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.JndiName;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.core.Init;
import org.jboss.seam.log.Log;
import org.jboss.seam.resteasy.AbstractResource;
import org.jboss.seam.resteasy.Application;
import org.jboss.seam.resteasy.ResourceHome;
import org.jboss.seam.resteasy.ResourceQuery;
import org.jboss.seam.resteasy.ResteasyBootstrap;
import org.jboss.seam.resteasy.SeamResteasyResourceFactory;
import org.jboss.seam.util.EJB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.resteasy.dispatcher")
@Scope(value=ScopeType.APPLICATION)
@Startup(depends={"org.jboss.seam.resteasy.bootstrap"})
@AutoCreate
public class ResteasyDispatcher
extends HttpServletDispatcher {
    @In
    protected Application application;
    @In
    protected ResteasyBootstrap bootstrap;
    @Logger
    private Log log;

    @Create
    public void init() {
        try {
            this.init(null);
        }
        catch (ServletException servletException) {
            // empty catch block
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        Set<Component> components;
        this.log.debug((Object)"registering RESTEasy and JAX RS resources and providers", new Object[0]);
        this.setDispatcher((Dispatcher)new SynchronousDispatcher((ResteasyProviderFactory)this.bootstrap.getProviderFactory()));
        this.getDispatcher().setLanguageMappings(this.application.getLanguageMappings());
        this.getDispatcher().setMediaTypeMappings(this.application.getMediaTypeMappings());
        if (this.application.isUseBuiltinProviders()) {
            this.log.info((Object)"registering built-in RESTEasy providers", new Object[0]);
            RegisterBuiltin.register((ResteasyProviderFactory)this.getDispatcher().getProviderFactory());
        }
        for (Class<?> providerClass : this.application.getProviderClasses()) {
            components = this.application.getProviderClassComponent(providerClass);
            if (components != null) {
                this.registerSeamComponentProviders(components, providerClass);
                continue;
            }
            this.registerProvider(providerClass);
        }
        for (Class<?> resourceClass : this.application.getClasses()) {
            components = this.application.getResourceClassComponent(resourceClass);
            if (components != null) {
                this.registerSeamComponentResources(components, resourceClass);
                continue;
            }
            this.registerResource(resourceClass);
        }
    }

    protected void registerSeamComponentProviders(Set<Component> components, Class providerClass) {
        for (Component seamComponent : components) {
            if (ScopeType.STATELESS.equals((Object)seamComponent.getScope())) {
                throw new RuntimeException("Registration of STATELESS Seam components as RESTEasy providers not implemented!");
            }
            if (!ScopeType.APPLICATION.equals((Object)seamComponent.getScope())) continue;
            Object providerInstance = Component.getInstance((String)seamComponent.getName());
            boolean isStringConverter = false;
            for (Class componentIface : seamComponent.getBusinessInterfaces()) {
                if (!StringConverter.class.isAssignableFrom(componentIface)) continue;
                isStringConverter = true;
                break;
            }
            if (isStringConverter) {
                this.log.error((Object)"can't register Seam component as RESTEasy StringConverter, see: https://jira.jboss.org/jira/browse/JBSEAM-4020", new Object[0]);
                continue;
            }
            this.getDispatcher().getProviderFactory().registerProviderInstance(providerInstance);
        }
    }

    protected void registerSeamComponentResources(Set<Component> components, Class resourceClass) {
        for (Component seamComponent : components) {
            SeamResteasyResourceFactory factory = new SeamResteasyResourceFactory(resourceClass, seamComponent, this.getDispatcher().getProviderFactory());
            if (seamComponent.getBeanClass().equals(ResourceHome.class) || seamComponent.getBeanClass().equals(ResourceQuery.class)) {
                AbstractResource instance = (AbstractResource)seamComponent.newInstance();
                String path = instance.getPath();
                if (instance.getPath() != null) {
                    this.log.debug((Object)"registering resource {0} on path {1} with Seam component lifecycle", new Object[]{seamComponent.getName(), path});
                    this.getDispatcher().getRegistry().addResourceFactory((ResourceFactory)factory, path);
                    continue;
                }
                this.log.warn((Object)"Unable to register {0} resource on null path, check components.xml", new Object[]{seamComponent.getName()});
                continue;
            }
            this.log.debug((Object)"registering resource {0} with Seam component lifecycle", new Object[]{seamComponent.getName()});
            this.getDispatcher().getRegistry().addResourceFactory((ResourceFactory)factory);
        }
    }

    protected void registerProvider(Class providerClass) {
        if (StringConverter.class.isAssignableFrom(providerClass)) {
            this.log.debug((Object)("registering as custom RESTEasy string converter provider class: " + providerClass), new Object[0]);
            this.getDispatcher().getProviderFactory().addStringConverter(providerClass);
        } else {
            this.getDispatcher().getProviderFactory().registerProvider(providerClass);
        }
    }

    protected void registerResource(Class resourceClass) {
        if (ResourceHome.class.equals((Object)resourceClass) || ResourceQuery.class.equals((Object)resourceClass)) {
            return;
        }
        if (resourceClass.isAnnotationPresent(EJB.STATELESS) || resourceClass.isAnnotationPresent(EJB.STATEFUL)) {
            String jndiName = this.getJndiName(resourceClass);
            this.log.debug((Object)("registering plain EJB resource as RESTEasy JNDI resource name: " + jndiName), new Object[0]);
            this.getDispatcher().getRegistry().addJndiResource(jndiName);
        } else {
            this.log.debug((Object)"registering resource {0} with default JAX-RS lifecycle", new Object[]{resourceClass.getName()});
            this.getDispatcher().getRegistry().addResourceFactory((ResourceFactory)new POJOResourceFactory(resourceClass));
        }
    }

    protected String getJndiName(Class<?> beanClass) {
        if (beanClass.isAnnotationPresent(JndiName.class)) {
            return beanClass.getAnnotation(JndiName.class).value();
        }
        String jndiPattern = Init.instance().getJndiPattern();
        if (jndiPattern == null) {
            throw new IllegalArgumentException("You must specify org.jboss.seam.core.init.jndiPattern or use @JndiName: " + beanClass.getName());
        }
        return jndiPattern.replace("#{ejbName}", Seam.getEjbName(beanClass));
    }
}

