/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.StringParameterInjector;
import org.jboss.seam.Entity;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.framework.Home;
import org.jboss.seam.resteasy.AbstractResource;
import org.jboss.seam.resteasy.EntityHomeWrapper;
import org.jboss.seam.resteasy.SeamResteasyProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="")
public class ResourceHome<T, T2>
extends AbstractResource<T> {
    private EntityHomeWrapper<T> entityHome = null;
    @Context
    private UriInfo uriInfo;
    @Context
    private Headers headers;
    @HeaderParam(value="Content-Type")
    private MediaType requestContentType;
    private Class entityIdClass = null;
    private boolean readonly;

    @Create
    public void create() {
        this.setEntityHome(this.getEntityHome());
        if (this.entityHome == null) {
            throw new IllegalStateException("entityHome is not set");
        }
    }

    @Path(value="/{id}")
    @GET
    public Response getResource(@PathParam(value="id") String rawId) {
        MediaType selectedMediaType = this.selectResponseMediaType();
        if (selectedMediaType == null) {
            return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build();
        }
        T2 id = this.unmarshallId(rawId);
        T entity = this.getEntity(id);
        return Response.ok((Object)new GenericEntity(entity, this.getEntityClass()){}, (MediaType)selectedMediaType).build();
    }

    public T getEntity(T2 id) {
        this.entityHome.setId(id);
        return this.entityHome.find();
    }

    @POST
    public Response createResource(InputStream messageBody) {
        if (this.readonly) {
            return Response.status((int)405).build();
        }
        if (!this.isMediaTypeCompatible(this.requestContentType)) {
            return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build();
        }
        T entity = this.unmarshallEntity(messageBody);
        T2 id = this.createEntity(entity);
        URI uri = this.uriInfo.getAbsolutePathBuilder().path(id.toString()).build(new Object[0]);
        return Response.created((URI)uri).build();
    }

    public T2 createEntity(T entity) {
        this.entityHome.setInstance(entity);
        this.entityHome.persist();
        return (T2)this.entityHome.getId();
    }

    @Path(value="/{id}")
    @PUT
    public Response updateResource(@PathParam(value="id") String rawId, InputStream messageBody) {
        Object storedId;
        if (this.readonly) {
            return Response.status((int)405).build();
        }
        if (!this.isMediaTypeCompatible(this.requestContentType)) {
            return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build();
        }
        T entity = this.unmarshallEntity(messageBody);
        T2 id = this.unmarshallId(rawId);
        if (!id.equals(storedId = Entity.forBean(entity).getIdentifier(entity))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.updateEntity(entity, id);
        return Response.noContent().build();
    }

    public void updateEntity(T entity, T2 id) {
        this.entityHome.merge(entity);
    }

    @Path(value="/{id}")
    @DELETE
    public Response deleteResource(@PathParam(value="id") String rawId) {
        if (this.readonly) {
            return Response.status((int)405).build();
        }
        T2 id = this.unmarshallId(rawId);
        this.deleteEntity(id);
        return Response.noContent().build();
    }

    public void deleteEntity(T2 id) {
        this.getEntity(id);
        this.entityHome.remove();
    }

    private T unmarshallEntity(InputStream is) {
        Object entity;
        Class<T> entityClass = this.getEntityClass();
        MessageBodyReader reader = SeamResteasyProviderFactory.getInstance().getMessageBodyReader(entityClass, entityClass, entityClass.getAnnotations(), this.requestContentType);
        if (reader == null) {
            throw new RuntimeException("Unable to find MessageBodyReader for content type " + this.requestContentType);
        }
        try {
            entity = reader.readFrom(entityClass, entityClass, entityClass.getAnnotations(), this.requestContentType, (MultivaluedMap)this.headers, is);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unmarshall request body");
        }
        return (T)entity;
    }

    private T2 unmarshallId(String id) {
        StringParameterInjector injector = new StringParameterInjector(this.getEntityIdClass(), (Type)this.getEntityIdClass(), "id", PathParam.class, null, null, SeamResteasyProviderFactory.getInstance());
        return (T2)injector.extractValue(id);
    }

    public Home<?, T> getEntityHome() {
        return this.entityHome == null ? null : this.entityHome.unwrap();
    }

    public void setEntityHome(Home<?, T> entityHome) {
        this.entityHome = new EntityHomeWrapper<T>(entityHome);
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityHome.getEntityClass();
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public Class getEntityIdClass() {
        if (this.entityIdClass == null) {
            ParameterizedType parameterizedSuperclass;
            Type superclass = this.getClass().getGenericSuperclass();
            if (superclass instanceof ParameterizedType && (parameterizedSuperclass = (ParameterizedType)superclass).getActualTypeArguments().length == 2) {
                return (Class)parameterizedSuperclass.getActualTypeArguments()[1];
            }
            throw new RuntimeException("Unable to determine entity id class.");
        }
        return this.entityIdClass;
    }

    public void setEntityIdClass(Class entityIdClass) {
        this.entityIdClass = entityIdClass;
    }
}

