/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResource<T> {
    @Context
    private HttpHeaders httpHeaders;
    private String path = null;
    private MediaType[] mediaTypes = new MediaType[]{MediaType.APPLICATION_XML_TYPE};
    private Class entityClass = null;

    public String[] getMediaTypes() {
        String[] mediaTypes = new String[this.mediaTypes.length];
        int i = 0;
        while (i < mediaTypes.length) {
            mediaTypes[i] = this.mediaTypes[i].toString();
            ++i;
        }
        return mediaTypes;
    }

    public void setMediaTypes(String[] mediaTypes) {
        this.mediaTypes = new MediaType[mediaTypes.length];
        int i = 0;
        while (i < mediaTypes.length) {
            this.mediaTypes[i] = MediaType.valueOf((String)mediaTypes[i]);
            ++i;
        }
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    public Class<T> getEntityClass() {
        if (this.entityClass == null) {
            ParameterizedType parameterizedSuperclass;
            Type superclass = this.getClass().getGenericSuperclass();
            if (superclass instanceof ParameterizedType && (parameterizedSuperclass = (ParameterizedType)superclass).getActualTypeArguments().length > 0) {
                return (Class)parameterizedSuperclass.getActualTypeArguments()[0];
            }
            throw new RuntimeException("Unable to determine entity class.");
        }
        return this.entityClass;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected MediaType selectResponseMediaType() {
        for (MediaType acceptedMediaType : this.httpHeaders.getAcceptableMediaTypes()) {
            MediaType[] mediaTypeArray = this.mediaTypes;
            int n = this.mediaTypes.length;
            int n2 = 0;
            while (n2 < n) {
                MediaType availableMediaType = mediaTypeArray[n2];
                if (acceptedMediaType.isCompatible(availableMediaType)) {
                    return availableMediaType;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isMediaTypeCompatible(MediaType mediaType) {
        MediaType[] mediaTypeArray = this.mediaTypes;
        int n = this.mediaTypes.length;
        int n2 = 0;
        while (n2 < n) {
            MediaType availableMediaType = mediaTypeArray[n2];
            if (availableMediaType.isCompatible(mediaType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

