/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.graphicImage;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.ui.graphicImage.GraphicImageStore;
import org.jboss.seam.ui.graphicImage.Image;
import org.jboss.seam.ui.graphicImage.ImageTransform;
import org.jboss.seam.ui.graphicImage.UIGraphicImage;
import org.jboss.seam.ui.util.HTML;
import org.jboss.seam.ui.util.cdk.RendererBase;

public class GraphicImageRendererBase
extends RendererBase {
    @Override
    protected Class getComponentClass() {
        return UIGraphicImage.class;
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIGraphicImage graphicImage = (UIGraphicImage)component;
        String key = graphicImage.getFileName();
        String extension = null;
        Image image = Image.instance();
        image.setInput(graphicImage.getValue());
        for (UIComponent cmp : graphicImage.getChildren()) {
            if (!(cmp instanceof ImageTransform)) continue;
            ImageTransform imageTransform = (ImageTransform)cmp;
            imageTransform.applyTransform(image);
        }
        key = GraphicImageStore.instance().put(new GraphicImageStore.ImageWrapper(image.getImage(), image.getContentType()), key);
        extension = image.getContentType().getExtension();
        writer.startElement("img", (UIComponent)graphicImage);
        if (graphicImage.getId() != null) {
            writer.writeAttribute("id", (Object)graphicImage.getClientId(context), "id");
        }
        String url = context.getExternalContext().getRequestContextPath() + "/seam/resource/graphicImage" + "/" + key + extension;
        writer.writeAttribute("src", (Object)url, "src");
        HTML.renderHTMLAttributes(writer, component, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        writer.endElement("img");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

