/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.seam.ui.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.jboss.seam.ui.component.UIEqualityValidator;

/**
 * Validate all child JSF input fields against the bound propertys using Hibernate Validator.
 **/
@Generated({"RichFaces CDK", "4.2.2.Final"})
public class HtmlEqualityValidator extends UIEqualityValidator
        {

    public static final String COMPONENT_TYPE="org.jboss.seam.ui.EqualityValidator";

    public static final String COMPONENT_FAMILY="org.jboss.seam.ui.EqualityValidator";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public HtmlEqualityValidator() {
        super();
        setRendererType("org.jboss.seam.ui.EqualityValidatorRenderer");
    }




    protected enum Properties {
        forValue("for"),
        message,
        messageId,
        operator,
        required
        ;
    String toString;

    Properties(String toString) {
        this.toString = toString;
    }

    Properties() {
    }

    public String toString() {
        return ((this.toString != null) ? this.toString : super.toString());
    }
    }

 
    public String getFor() {
        String value = (String) getStateHelper().eval(Properties.forValue);
        return value;
    }
    
    public void setFor(String forValue) {
        getStateHelper().put(Properties.forValue, forValue);
    }

 
    public String getMessage() {
        String value = (String) getStateHelper().eval(Properties.message);
        return value;
    }
    
    public void setMessage(String message) {
        getStateHelper().put(Properties.message, message);
    }

 
    public String getMessageId() {
        String value = (String) getStateHelper().eval(Properties.messageId);
        return value;
    }
    
    public void setMessageId(String messageId) {
        getStateHelper().put(Properties.messageId, messageId);
    }

 
    public String getOperator() {
        String value = (String) getStateHelper().eval(Properties.operator);
        return value;
    }
    
    public void setOperator(String operator) {
        getStateHelper().put(Properties.operator, operator);
    }

 
    public boolean isRequired() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.required, true);
        return value;
    }
    
    public void setRequired(boolean required) {
        getStateHelper().put(Properties.required, required);
    }

    

}