/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.async.AbstractDispatcher;
import org.jboss.seam.async.Dispatcher;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;

@Interceptor(stateless=true, type=InterceptorType.CLIENT)
public class AsynchronousInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 9194177339867853303L;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        boolean scheduleAsync;
        boolean bl = scheduleAsync = invocation.getMethod().isAnnotationPresent(Asynchronous.class) && !Contexts.getEventContext().isSet("org.jboss.seam.core.executingAsynchronousCall");
        if (scheduleAsync) {
            Dispatcher dispatcher = AbstractDispatcher.instance();
            if (dispatcher == null) {
                throw new IllegalStateException("org.jboss.seam.async.dispatcher is not installed in components.xml");
            }
            Object timer = dispatcher.scheduleInvocation(invocation, this.getComponent());
            return timer != null && invocation.getMethod().getReturnType().isAssignableFrom(timer.getClass()) ? timer : null;
        }
        return invocation.proceed();
    }
}

