/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.core.AbstractMutable;

public abstract class Selector
extends AbstractMutable
implements Serializable {
    private boolean cookieEnabled;
    private int cookieMaxAge = 31536000;
    private String cookiePath = "/";

    public boolean isCookieEnabled() {
        return this.cookieEnabled;
    }

    public void setCookieEnabled(boolean cookieEnabled) {
        this.setDirty(this.cookieEnabled, cookieEnabled);
        this.cookieEnabled = cookieEnabled;
    }

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    protected abstract String getCookieName();

    protected String getCookieValueIfEnabled() {
        return this.isCookieEnabled() ? this.getCookieValue() : null;
    }

    protected Cookie getCookie() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null) {
            return (Cookie)ctx.getExternalContext().getRequestCookieMap().get(this.getCookieName());
        }
        return null;
    }

    protected String getCookieValue() {
        Cookie cookie = this.getCookie();
        return cookie == null ? null : cookie.getValue();
    }

    protected void clearCookieValue() {
        Cookie cookie = this.getCookie();
        if (cookie != null) {
            HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
            cookie.setValue(null);
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    protected void setCookieValueIfEnabled(String value) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (this.isCookieEnabled() && ctx != null) {
            HttpServletResponse response = (HttpServletResponse)ctx.getExternalContext().getResponse();
            Cookie cookie = new Cookie(this.getCookieName(), value);
            cookie.setMaxAge(this.getCookieMaxAge());
            cookie.setPath(this.cookiePath);
            response.addCookie(cookie);
        }
    }
}

