/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pageflow;

import org.dom4j.Element;
import org.jboss.seam.bpm.BusinessProcess;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.Interpolator;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class Page
extends Node
implements Parsable {
    private static final long serialVersionUID = 1L;
    private String viewId;
    private boolean isConversationEnd = false;
    private boolean isConversationEndBeforeRedirect = false;
    private boolean isTaskEnd = false;
    private String transition;
    private String processToCreate;
    private boolean redirect;
    private String description;
    private Integer timeout;
    private boolean backEnabled;
    private boolean switchEnabled;
    private String noConversationViewId;

    public void read(Element pageElement, JpdlXmlReader jpdlXmlReader) {
        String timeoutString;
        Element descriptionElement;
        Element endTaskElement;
        super.read(pageElement, jpdlXmlReader);
        this.viewId = pageElement.attributeValue("view-id");
        if (this.viewId == null) {
            throw new IllegalStateException("must specify view-id for <page/> node: " + pageElement.attributeValue("name"));
        }
        this.noConversationViewId = pageElement.attributeValue("no-conversation-view-id");
        this.backEnabled = "enabled".equals(pageElement.attributeValue("back"));
        this.switchEnabled = !"disabled".equals(pageElement.attributeValue("switch"));
        Element endConversationElement = pageElement.element("end-conversation");
        if (endConversationElement != null) {
            this.isConversationEnd = true;
            this.isConversationEndBeforeRedirect = "true".equals(endConversationElement.attributeValue("before-redirect"));
            this.processToCreate = endConversationElement.attributeValue("create-process");
        }
        if ((endTaskElement = pageElement.element("end-task")) != null) {
            this.isTaskEnd = true;
            this.transition = endTaskElement.attributeValue("transition");
        }
        this.redirect = "true".equals(pageElement.attributeValue("redirect"));
        if (pageElement.element("redirect") != null) {
            this.redirect = true;
        }
        if ((descriptionElement = pageElement.element("description")) != null) {
            this.description = descriptionElement.getTextTrim();
        }
        if ((timeoutString = pageElement.attributeValue("timeout")) != null) {
            this.timeout = Integer.valueOf(timeoutString);
        }
    }

    public void execute(ExecutionContext executionContext) {
        if (this.isConversationEnd && this.processToCreate != null) {
            BusinessProcess.instance().createProcess(this.processToCreate);
        }
        if (this.isTaskEnd) {
            BusinessProcess.instance().endTask(this.transition);
        }
        if (this.isConversationEnd || this.isTaskEnd) {
            if (this.isConversationEndBeforeRedirect) {
                Conversation.instance().endBeforeRedirect();
            } else {
                Conversation.instance().end();
            }
        }
        if (this.getAction() != null) {
            try {
                this.getAction().execute(executionContext);
            }
            catch (Exception e) {
                this.raiseException(e, executionContext);
            }
        }
    }

    public boolean isConversationEnd() {
        return this.isConversationEnd;
    }

    public String getTransition() {
        return this.transition;
    }

    public String getViewId() {
        return this.viewId;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return Interpolator.instance().interpolate(this.description, new Object[0]);
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public boolean isBackEnabled() {
        return this.backEnabled;
    }

    public boolean isSwitchEnabled() {
        return this.switchEnabled;
    }

    public String getNoConversationViewId() {
        return this.noConversationViewId;
    }

    protected boolean isTaskEnd() {
        return this.isTaskEnd;
    }

    protected String getProcessToCreate() {
        return this.processToCreate;
    }

    public boolean isConversationEndBeforeRedirect() {
        return this.isConversationEndBeforeRedirect;
    }
}

