/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.io.IOException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.web.AbstractFilter;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.web.redirectFilter")
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@BypassInterceptors
@Filter(within={"org.jboss.seam.web.ajax4jsfFilter"})
public class RedirectFilter
extends AbstractFilter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, RedirectFilter.wrapResponse((HttpServletResponse)response));
    }

    private static ServletResponse wrapResponse(HttpServletResponse response) {
        return new HttpServletResponseWrapper(response){

            public void sendRedirect(String url) throws IOException {
                if (Contexts.isEventContextActive() && !url.startsWith("http:") && !url.startsWith("https:")) {
                    String viewId = RedirectFilter.getViewId(url);
                    if (viewId != null) {
                        url = Pages.instance().encodePageParameters(FacesContext.getCurrentInstance(), url, viewId);
                    }
                    if (Contexts.isConversationContextActive()) {
                        url = FacesManager.instance().appendConversationIdFromRedirectFilter(url, viewId);
                    }
                }
                super.sendRedirect(url);
            }
        };
    }

    public static String getViewId(String url) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String pathInfo = externalContext.getRequestPathInfo();
        String servletPath = externalContext.getRequestServletPath();
        String contextPath = externalContext.getRequestContextPath();
        return RedirectFilter.getViewId(url, pathInfo, servletPath, contextPath);
    }

    protected static String getViewId(String url, String pathInfo, String servletPath, String contextPath) {
        if (pathInfo != null) {
            return url.substring(contextPath.length() + servletPath.length(), RedirectFilter.getParamLoc(url));
        }
        if (url.startsWith(contextPath)) {
            String extension = servletPath.substring(servletPath.lastIndexOf(46));
            if (url.endsWith(extension) || url.contains(extension + '?')) {
                String suffix = Pages.getSuffix();
                return url.substring(contextPath.length(), RedirectFilter.getParamLoc(url) - extension.length()) + suffix;
            }
            return null;
        }
        return null;
    }

    private static int getParamLoc(String url) {
        int loc = url.indexOf(63);
        if (loc < 0) {
            loc = url.length();
        }
        return loc;
    }
}

