/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.init;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Namespace;
import org.jboss.seam.annotations.Role;
import org.jboss.seam.annotations.Roles;
import org.jboss.seam.bpm.Jbpm;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.PojoCache;
import org.jboss.seam.deployment.ComponentScanner;
import org.jboss.seam.deployment.NamespaceScanner;
import org.jboss.seam.init.ComponentDescriptor;
import org.jboss.seam.init.DependencyManager;
import org.jboss.seam.init.FactoryDescriptor;
import org.jboss.seam.init.NamespaceDescriptor;
import org.jboss.seam.init.NoHotRedeployable;
import org.jboss.seam.init.RedeployableStrategy;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Conversions;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Strings;
import org.jboss.seam.util.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Initialization {
    public static final String COMPONENT_SUFFIX = ".component";
    private static final LogProvider log = Logging.getLogProvider(Initialization.class);
    private ServletContext servletContext;
    private Map<String, Conversions.PropertyValue> properties = new HashMap<String, Conversions.PropertyValue>();
    private Map<String, Set<ComponentDescriptor>> componentDescriptors = new HashMap<String, Set<ComponentDescriptor>>();
    private List<FactoryDescriptor> factoryDescriptors = new ArrayList<FactoryDescriptor>();
    private Set<Class> installedComponentClasses = new HashSet<Class>();
    private Map<String, NamespaceDescriptor> namespaceMap = new HashMap<String, NamespaceDescriptor>();
    private Map<String, EventListenerDescriptor> eventListenerDescriptors = new HashMap<String, EventListenerDescriptor>();
    private Collection<String> globalImports = new ArrayList<String>();
    private Set<String> nonPropertyAttributes = new HashSet<String>();

    public Initialization(ServletContext servletContext) {
        this.nonPropertyAttributes.add("name");
        this.nonPropertyAttributes.add("installed");
        this.nonPropertyAttributes.add("scope");
        this.nonPropertyAttributes.add("startup");
        this.nonPropertyAttributes.add("class");
        this.nonPropertyAttributes.add("jndi-name");
        this.nonPropertyAttributes.add("precedence");
        this.nonPropertyAttributes.add("auto-create");
        this.servletContext = servletContext;
    }

    public Initialization create() {
        this.addNamespaces();
        this.initComponentsFromXmlDocument("/WEB-INF/components.xml");
        this.initComponentsFromXmlDocument("/WEB-INF/events.xml");
        this.initComponentsFromXmlDocuments();
        this.initPropertiesFromServletContext();
        this.initPropertiesFromResource();
        this.initJndiProperties();
        return this;
    }

    private void initComponentsFromXmlDocuments() {
        Enumeration<URL> resources;
        try {
            resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/components.xml");
        }
        catch (IOException ioe) {
            throw new RuntimeException("error scanning META-INF/components.xml files", ioe);
        }
        Properties replacements = this.getReplacements();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                log.info("reading " + url);
                this.installComponentsFromXmlElements(XML.getRootElement(url.openStream()), replacements);
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading " + url, e);
            }
        }
    }

    private void initComponentsFromXmlDocument(String resource) {
        InputStream stream = Resources.getResourceAsStream(resource, this.servletContext);
        if (stream != null) {
            log.info("reading " + resource);
            try {
                this.installComponentsFromXmlElements(XML.getRootElement(stream), this.getReplacements());
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading /WEB-INF/components.xml", e);
            }
        }
    }

    private Properties getReplacements() {
        try {
            Properties replacements = new Properties();
            InputStream replaceStream = Resources.getResourceAsStream("components.properties", this.servletContext);
            if (replaceStream != null) {
                replacements.load(replaceStream);
            }
            return replacements;
        }
        catch (IOException ioe) {
            throw new RuntimeException("error reading components.properties", ioe);
        }
    }

    private void installComponentsFromXmlElements(Element rootElement, Properties replacements) throws DocumentException, ClassNotFoundException {
        List importElements = rootElement.elements("import");
        for (Element importElement : importElements) {
            this.globalImports.add(importElement.getTextTrim());
        }
        List componentElements = rootElement.elements("component");
        for (Element component : componentElements) {
            this.installComponentFromXmlElement(component, component.attributeValue("name"), component.attributeValue("class"), replacements);
        }
        List factoryElements = rootElement.elements("factory");
        for (Element factory : factoryElements) {
            this.installFactoryFromXmlElement(factory);
        }
        List elements = rootElement.elements("event");
        for (Element event : elements) {
            this.installEventListenerFromXmlElement(event);
        }
        for (Element elem : rootElement.elements()) {
            String ns = elem.getNamespace().getURI();
            NamespaceDescriptor nsInfo = this.namespaceMap.get(ns);
            if (nsInfo == null) {
                if (ns == null || ns.equals("http://jboss.com/products/seam/components")) continue;
                log.warn("namespace declared in components.xml does not resolve to a package annotated @Namespace: " + ns);
                continue;
            }
            String name = elem.attributeValue("name");
            String elemName = Initialization.toCamelCase(elem.getName(), true);
            String className = elem.attributeValue("class");
            if (className == null) {
                className = nsInfo.getPackage().getName() + '.' + elemName;
            }
            try {
                Install install;
                Class clazz = Reflections.classForName(className);
                Name nameAnnotation = clazz.getAnnotation(Name.class);
                if (name == null && nameAnnotation != null) {
                    name = nameAnnotation.value();
                }
                if (nameAnnotation != null && nameAnnotation.value().equals(name) && ((install = clazz.getAnnotation(Install.class)) == null || install.value())) {
                    className = null;
                }
            }
            catch (ClassNotFoundException cnfe) {
                className = null;
            }
            if (name == null) {
                String prefix = nsInfo.getNamespace().prefix();
                String componentName = Initialization.toCamelCase(elem.getName(), false);
                name = Strings.isEmpty(prefix) ? componentName : prefix + '.' + componentName;
            }
            this.installComponentFromXmlElement(elem, name, className, replacements);
        }
    }

    private void installEventListenerFromXmlElement(Element event) {
        String type = event.attributeValue("type");
        if (type == null) {
            throw new IllegalArgumentException("must specify type for <event/> declaration");
        }
        EventListenerDescriptor eventListener = this.eventListenerDescriptors.get(type);
        if (eventListener == null) {
            eventListener = new EventListenerDescriptor(type);
            this.eventListenerDescriptors.put(type, eventListener);
        }
        List actions = event.elements("action");
        for (Element action : actions) {
            String execute = action.attributeValue("execute");
            if (execute == null) {
                String actionExpression = action.attributeValue("expression");
                if (actionExpression != null) {
                    log.warn("<action expression=\"" + actionExpression + "\" /> has been deprecated, use <action execute=\"" + actionExpression + "\" /> instead");
                    execute = actionExpression;
                } else {
                    throw new IllegalArgumentException("must specify execute for <action/> declaration");
                }
            }
            eventListener.getListenerMethodBindings().add(execute);
        }
    }

    private void installFactoryFromXmlElement(Element factory) {
        String scopeName = factory.attributeValue("scope");
        String name = factory.attributeValue("name");
        if (name == null) {
            throw new IllegalArgumentException("must specify name in <factory/> declaration");
        }
        String method = factory.attributeValue("method");
        String value = factory.attributeValue("value");
        if (method == null && value == null) {
            throw new IllegalArgumentException("must specify either method or value in <factory/> declaration for variable: " + name);
        }
        ScopeType scope = scopeName == null ? ScopeType.UNSPECIFIED : ScopeType.valueOf(scopeName.toUpperCase());
        boolean autoCreate = "true".equals(factory.attributeValue("auto-create"));
        this.factoryDescriptors.add(new FactoryDescriptor(name, scope, method, value, autoCreate));
    }

    private String replace(String value, Properties replacements) {
        if (value.startsWith("@")) {
            value = replacements.getProperty(value.substring(1, value.length() - 1));
        }
        return value;
    }

    private void installComponentFromXmlElement(Element component, String name, String className, Properties replacements) throws ClassNotFoundException {
        String qualifiedPropName;
        Boolean startup;
        String installText = component.attributeValue("installed");
        boolean installed = false;
        if (installText == null || "true".equals(this.replace(installText, replacements))) {
            installed = true;
        }
        String scopeName = component.attributeValue("scope");
        String jndiName = component.attributeValue("jndi-name");
        String precedenceString = component.attributeValue("precedence");
        int precedence = precedenceString == null ? 20 : Integer.valueOf(precedenceString);
        ScopeType scope = scopeName == null ? null : ScopeType.valueOf(scopeName.toUpperCase());
        String autocreateAttribute = component.attributeValue("auto-create");
        Boolean autoCreate = autocreateAttribute == null ? null : Boolean.valueOf("true".equals(autocreateAttribute));
        String startupAttribute = component.attributeValue("startup");
        Boolean bl = startup = startupAttribute == null ? null : Boolean.valueOf("true".equals(startupAttribute));
        if (className != null) {
            Class<?> clazz = this.getClassUsingImports(className);
            if (name == null) {
                if (!clazz.isAnnotationPresent(Name.class)) {
                    throw new IllegalArgumentException("Component class must have @Name annotation or name must be specified in components.xml: " + clazz.getName());
                }
                name = clazz.getAnnotation(Name.class).value();
            }
            ComponentDescriptor descriptor = new ComponentDescriptor(name, clazz, scope, autoCreate, startup, jndiName, installed, precedence);
            this.addComponentDescriptor(descriptor);
            this.installedComponentClasses.add(clazz);
        } else if (name == null) {
            throw new IllegalArgumentException("must specify either class or name in <component/> declaration");
        }
        for (Element prop : component.elements()) {
            String propName = prop.attributeValue("name");
            if (propName == null) {
                propName = prop.getQName().getName();
            }
            qualifiedPropName = name + '.' + Initialization.toCamelCase(propName, false);
            this.properties.put(qualifiedPropName, this.getPropertyValue(prop, qualifiedPropName, replacements));
        }
        for (Element prop : component.attributes()) {
            String attributeName = prop.getName();
            if (!this.isProperty(prop.getNamespaceURI(), attributeName)) continue;
            qualifiedPropName = name + '.' + Initialization.toCamelCase(prop.getQName().getName(), false);
            Conversions.PropertyValue propValue = null;
            try {
                propValue = this.getPropertyValue((Attribute)prop, replacements);
                this.properties.put(qualifiedPropName, propValue);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(String.format("Exception setting property %s on component %s.  Expression %s evaluated to %s.", qualifiedPropName, name, prop.getValue(), propValue), ex);
            }
        }
    }

    private boolean isProperty(String namespaceURI, String attributeName) {
        return (namespaceURI == null || namespaceURI.length() == 0) && !this.nonPropertyAttributes.contains(attributeName);
    }

    private Class<?> getClassUsingImports(String className) throws ClassNotFoundException {
        Class clazz = null;
        clazz = Reflections.classForName(className);
        return clazz;
    }

    private void addComponentDescriptor(ComponentDescriptor descriptor) {
        String name = descriptor.getName();
        Set<ComponentDescriptor> set = this.componentDescriptors.get(name);
        if (set == null) {
            set = new TreeSet<ComponentDescriptor>(new ComponentDescriptor.PrecedenceComparator());
            this.componentDescriptors.put(name, set);
        }
        if (!set.isEmpty()) {
            log.info("two components with same name, higher precedence wins: " + name);
        }
        if (!set.add(descriptor)) {
            throw new IllegalStateException("Two components with the same name and precedence: " + name);
        }
    }

    private Conversions.PropertyValue getPropertyValue(Attribute prop, Properties replacements) {
        return new Conversions.FlatPropertyValue(this.trimmedText(prop, replacements));
    }

    private Conversions.PropertyValue getPropertyValue(Element prop, String propName, Properties replacements) {
        List keyElements = prop.elements("key");
        List valueElements = prop.elements("value");
        if (valueElements.isEmpty() && keyElements.isEmpty()) {
            return new Conversions.FlatPropertyValue(this.trimmedText(prop, propName, replacements));
        }
        if (keyElements.isEmpty()) {
            int len = valueElements.size();
            String[] values = new String[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.trimmedText((Element)valueElements.get(i), propName, replacements);
            }
            return new Conversions.MultiPropertyValue(values);
        }
        if (valueElements.size() != keyElements.size()) {
            throw new IllegalArgumentException("value elements must match key elements: " + propName);
        }
        HashMap<String, String> keyedValues = new HashMap<String, String>();
        for (int i = 0; i < keyElements.size(); ++i) {
            String key = this.trimmedText((Element)keyElements.get(i), propName, replacements);
            String value = this.trimmedText((Element)valueElements.get(i), propName, replacements);
            keyedValues.put(key, value);
        }
        return new Conversions.AssociativePropertyValue(keyedValues);
    }

    private String trimmedText(Element element, String propName, Properties replacements) {
        String text = element.getTextTrim();
        if (text == null) {
            throw new IllegalArgumentException("property value must be specified in element body: " + propName);
        }
        return this.replace(text, replacements);
    }

    private String trimmedText(Attribute attribute, Properties replacements) {
        return this.replace(attribute.getText(), replacements);
    }

    public Initialization setProperty(String name, Conversions.PropertyValue value) {
        this.properties.put(name, value);
        return this;
    }

    public Initialization init() {
        log.info("initializing Seam");
        ServletLifecycle.beginInitialization();
        Contexts.getApplicationContext().set("org.jboss.seam.properties", this.properties);
        RedeployableStrategy redeployStrategy = this.getRedeployableInitialization();
        this.scanForHotDeployableComponents(redeployStrategy);
        this.scanForComponents();
        this.addComponent(new ComponentDescriptor(Init.class), Contexts.getApplicationContext(), redeployStrategy);
        Init init = (Init)Component.getInstance(Init.class, ScopeType.APPLICATION);
        ComponentDescriptor desc = this.findDescriptor(Jbpm.class);
        if (desc != null && desc.isInstalled()) {
            init.setJbpmInstalled(true);
        }
        init.setTimestamp(System.currentTimeMillis());
        init.setHotDeployPaths(redeployStrategy.getPaths());
        this.addSpecialComponents(init);
        this.installComponents(init, redeployStrategy);
        for (String globalImport : this.globalImports) {
            init.importNamespace(globalImport);
        }
        ServletLifecycle.endInitialization();
        log.info("done initializing Seam");
        return this;
    }

    public Initialization redeploy(HttpServletRequest request) {
        log.info("redeploying");
        ServletLifecycle.beginReinitialization(request);
        Init init = Init.instance();
        for (String name : init.getHotDeployableComponents()) {
            ScopeType scope;
            Component component = Component.forName(name);
            if (component != null && (scope = component.getScope()) != ScopeType.STATELESS && scope.isContextActive()) {
                scope.getContext().remove(name);
            }
            Contexts.getApplicationContext().remove(name + COMPONENT_SUFFIX);
        }
        RedeployableStrategy redeployStrategy = this.getRedeployableInitialization();
        this.scanForHotDeployableComponents(redeployStrategy);
        init.setTimestamp(System.currentTimeMillis());
        init.setHotDeployPaths(redeployStrategy.getPaths());
        this.installComponents(init, redeployStrategy);
        ServletLifecycle.endInitialization();
        log.info("done redeploying");
        return this;
    }

    private RedeployableStrategy getRedeployableInitialization() {
        String path = this.servletContext.getRealPath("/WEB-INF/dev");
        if (path == null) {
            log.debug("Could not find path for /WEB-INF/dev");
            return new NoHotRedeployable();
        }
        File hotDeployDir = new File(path);
        String strategy = this.getRedeployableStrategyName(hotDeployDir);
        try {
            Class initializer = Reflections.classForName(strategy);
            Constructor ctr = initializer.getConstructor(File.class);
            return (RedeployableStrategy)ctr.newInstance(hotDeployDir);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate redeployable strategy: " + strategy);
        }
    }

    private String getRedeployableStrategyName(File hotDeployDir) {
        boolean isGroovy;
        boolean debugEnabled = Thread.currentThread().getContextClassLoader().getResource("META-INF/debug.xhtml") != null;
        try {
            Reflections.classForName("groovy.lang.GroovyObject");
            isGroovy = true;
        }
        catch (ClassNotFoundException e) {
            isGroovy = false;
        }
        if (debugEnabled && hotDeployDir.exists()) {
            if (isGroovy) {
                log.debug("Using Java+Groovy hot deploy");
                return "org.jboss.seam.init.GroovyHotRedeployable";
            }
            log.debug("Using Java hot deploy");
            return "org.jboss.seam.init.JavaHotRedeployable";
        }
        log.debug("No hot deploy used");
        return "org.jboss.seam.init.NoHotRedeployable";
    }

    private void scanForHotDeployableComponents(RedeployableStrategy redeployStrategy) {
        ComponentScanner scanner = redeployStrategy.getScanner();
        if (scanner != null) {
            HashSet<Class<Object>> scannedClasses = new HashSet<Class<Object>>();
            scannedClasses.addAll(scanner.getClasses());
            for (Class clazz : scannedClasses) {
                this.installScannedComponentAndRoles(clazz);
            }
        }
    }

    private void scanForComponents() {
        ComponentScanner[] scanners = new ComponentScanner[]{new ComponentScanner("seam.properties"), new ComponentScanner("META-INF/seam.properties"), new ComponentScanner("META-INF/components.xml")};
        HashSet<Class<Object>> scannedClasses = new HashSet<Class<Object>>();
        for (ComponentScanner scanner : scanners) {
            scannedClasses.addAll(scanner.getClasses());
        }
        for (Class clazz : scannedClasses) {
            this.installScannedComponentAndRoles(clazz);
        }
        for (ComponentScanner scanner : scanners) {
            for (String name : scanner.getResources()) {
                this.installComponentsFromDescriptor(name, scanner.getClassLoader());
            }
        }
    }

    private static String classFilenameFromDescriptor(String descriptor) {
        int pos = descriptor.lastIndexOf(".component.xml");
        if (pos == -1) {
            return null;
        }
        return descriptor.substring(0, pos).replace('/', '.').replace('\\', '.');
    }

    private void installComponentsFromDescriptor(String fileName, ClassLoader loader) {
        InputStream stream = loader.getResourceAsStream(fileName);
        if (stream != null) {
            try {
                Properties replacements = this.getReplacements();
                Element root = XML.getRootElement(stream);
                if (root.getName().equals("components")) {
                    this.installComponentsFromXmlElements(root, replacements);
                } else {
                    this.installComponentFromXmlElement(root, root.attributeValue("name"), Initialization.classFilenameFromDescriptor(fileName), replacements);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading " + fileName, e);
            }
        }
    }

    private void installScannedComponentAndRoles(Class<Object> scannedClass) {
        try {
            if (scannedClass.isAnnotationPresent(Name.class)) {
                this.addComponentDescriptor(new ComponentDescriptor(scannedClass));
            }
            if (scannedClass.isAnnotationPresent(Role.class)) {
                this.installRole(scannedClass, scannedClass.getAnnotation(Role.class));
            }
            if (scannedClass.isAnnotationPresent(Roles.class)) {
                Role[] roles;
                for (Role role : roles = scannedClass.getAnnotation(Roles.class).value()) {
                    this.installRole(scannedClass, role);
                }
            }
        }
        catch (TypeNotPresentException e) {
            log.info("Failed to install " + scannedClass.getName() + ": " + e.getMessage());
        }
    }

    private void installRole(Class<Object> scannedClass, Role role) {
        ScopeType scope = Seam.getComponentRoleScope(scannedClass, role);
        this.addComponentDescriptor(new ComponentDescriptor(role.name(), scannedClass, scope));
    }

    private void addNamespace(Package pkg) {
        Namespace ns;
        if (pkg != null && (ns = pkg.getAnnotation(Namespace.class)) != null) {
            log.info("Namespace: " + ns.value() + ", package: " + pkg.getName() + ", prefix: " + ns.prefix());
            NamespaceDescriptor old = this.namespaceMap.put(ns.value(), new NamespaceDescriptor(ns, pkg));
            if (old != null && !old.getPackage().equals(pkg)) {
                throw new IllegalStateException("two packages with the same @Namespace: " + ns.value());
            }
        }
    }

    private void addNamespaces() {
        for (Package pkg : new NamespaceScanner("META-INF/components.xml").getPackages()) {
            this.addNamespace(pkg);
        }
        for (Package pkg : new NamespaceScanner("seam.properties").getPackages()) {
            this.addNamespace(pkg);
        }
        for (Package pkg : new NamespaceScanner("META-INF/seam.properties").getPackages()) {
            this.addNamespace(pkg);
        }
    }

    private void initPropertiesFromServletContext() {
        Enumeration params = this.servletContext.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            this.properties.put(name, new Conversions.FlatPropertyValue(this.servletContext.getInitParameter(name)));
        }
    }

    private void initPropertiesFromResource() {
        Properties props = this.loadFromResource("/seam.properties");
        for (Map.Entry<Object, Object> me : props.entrySet()) {
            this.properties.put((String)me.getKey(), new Conversions.FlatPropertyValue((String)me.getValue()));
        }
    }

    private void initJndiProperties() {
        Properties jndiProperties = new Properties();
        jndiProperties.putAll((Map<?, ?>)this.loadFromResource("/jndi.properties"));
        jndiProperties.putAll((Map<?, ?>)this.loadFromResource("/seam-jndi.properties"));
        Naming.setInitialContextProperties(jndiProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadFromResource(String resource) {
        Properties props = new Properties();
        InputStream stream = Resources.getResourceAsStream(resource, this.servletContext);
        if (stream != null) {
            try {
                log.info("reading properties from: " + resource);
                try {
                    props.load(stream);
                }
                catch (IOException ioe) {
                    log.error("could not read " + resource, ioe);
                }
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException ex) {}
            }
        } else {
            log.debug("not found: " + resource);
        }
        return props;
    }

    protected ComponentDescriptor findDescriptor(Class<?> componentClass) {
        for (Set<ComponentDescriptor> components : this.componentDescriptors.values()) {
            for (ComponentDescriptor component : components) {
                if (!component.getComponentClass().equals(componentClass)) continue;
                return component;
            }
        }
        return null;
    }

    private void addSpecialComponents(Init init) {
        try {
            Reflections.classForName("org.jboss.cache.aop.PojoCache");
            this.addComponentDescriptor(new ComponentDescriptor(PojoCache.class, true));
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
            log.warn("Did not install PojoCache due to NoClassDefFoundError: " + e.getMessage());
        }
    }

    private void installComponents(Init init, RedeployableStrategy redeployStrategy) {
        log.info("Installing components...");
        Context context = Contexts.getApplicationContext();
        DependencyManager manager = new DependencyManager(this.componentDescriptors);
        Set<ComponentDescriptor> installable = manager.installedSet();
        for (ComponentDescriptor componentDescriptor : installable) {
            String compName = componentDescriptor.getName() + COMPONENT_SUFFIX;
            if (context.isSet(compName)) continue;
            this.addComponent(componentDescriptor, context, redeployStrategy);
            if (componentDescriptor.isAutoCreate()) {
                init.addAutocreateVariable(componentDescriptor.getName());
            }
            if (componentDescriptor.isFilter()) {
                init.addInstalledFilter(componentDescriptor.getName());
            }
            if (!componentDescriptor.isResourceProvider()) continue;
            if (!componentDescriptor.getScope().equals((Object)ScopeType.APPLICATION)) {
                throw new RuntimeException("Resource providers must be application-scoped components");
            }
            init.addResourceProvider(componentDescriptor.getName());
        }
        for (FactoryDescriptor factoryDescriptor : this.factoryDescriptors) {
            if (factoryDescriptor.isValueBinding()) {
                init.addFactoryValueExpression(factoryDescriptor.getName(), factoryDescriptor.getValue(), factoryDescriptor.getScope());
            } else {
                init.addFactoryMethodExpression(factoryDescriptor.getName(), factoryDescriptor.getMethod(), factoryDescriptor.getScope());
            }
            if (!factoryDescriptor.isAutoCreate()) continue;
            init.addAutocreateVariable(factoryDescriptor.getName());
        }
        for (EventListenerDescriptor listenerDescriptor : this.eventListenerDescriptors.values()) {
            for (String expression : listenerDescriptor.getListenerMethodBindings()) {
                init.addObserverMethodExpression(listenerDescriptor.getType(), Expressions.instance().createMethodExpression(expression));
            }
        }
    }

    protected void addComponent(ComponentDescriptor descriptor, Context context, RedeployableStrategy redeployStrategy) {
        String name = descriptor.getName();
        String componentName = name + COMPONENT_SUFFIX;
        try {
            Component component = new Component(descriptor.getComponentClass(), name, descriptor.getScope(), descriptor.isStartup(), descriptor.getJndiName());
            context.set(componentName, component);
            if (redeployStrategy.isFromHotDeployClassLoader(descriptor.getComponentClass())) {
                Init.instance().addHotDeployableComponent(component.getName());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not create Component: " + name, e);
        }
    }

    private static String toCamelCase(String hyphenated, boolean initialUpper) {
        StringTokenizer tokens = new StringTokenizer(hyphenated, "-");
        StringBuilder result = new StringBuilder(hyphenated.length());
        String firstToken = tokens.nextToken();
        if (initialUpper) {
            result.append(Character.toUpperCase(firstToken.charAt(0))).append(firstToken.substring(1));
        } else {
            result.append(firstToken);
        }
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            result.append(Character.toUpperCase(token.charAt(0))).append(token.substring(1));
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventListenerDescriptor {
        private String type;
        private List<String> listenerMethodBindings = new ArrayList<String>();

        EventListenerDescriptor(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public List<String> getListenerMethodBindings() {
            return this.listenerMethodBindings;
        }

        public String toString() {
            return "EventListenerDescriptor(" + this.type + ')';
        }
    }
}

