/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.text;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.seam.text.SeamTextParserTokenTypes;

public class SeamTextParser
extends LLkParser
implements SeamTextParserTokenTypes {
    private Set htmlElements = new HashSet<String>(Arrays.asList("a", "p", "q", "blockquote", "code", "pre", "table", "tr", "td", "th", "ul", "ol", "li", "b", "i", "u", "tt", "del", "em", "hr", "br", "div", "span", "h1", "h2", "h3", "h4", "img"));
    private Set htmlAttributes = new HashSet<String>(Arrays.asList("src", "href", "lang", "class", "id", "style", "width", "height", "name", "value", "type", "wmode"));
    private StringBuilder mainBuilder;
    private StringBuilder builder = this.mainBuilder = new StringBuilder();
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "DOUBLEQUOTE", "BACKTICK", "ALPHANUMERICWORD", "UNICODEWORD", "PUNCTUATION", "SINGLEQUOTE", "ESCAPE", "STAR", "SLASH", "BAR", "HAT", "PLUS", "EQ", "HASH", "TWIDDLE", "UNDERSCORE", "OPEN", "CLOSE", "QUOTE", "GT", "LT", "AMPERSAND", "SPACE", "NEWLINE"};
    public static final BitSet _tokenSet_0 = new BitSet(SeamTextParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(SeamTextParser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(SeamTextParser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(SeamTextParser.mk_tokenSet_3());

    public String toString() {
        return this.builder.toString();
    }

    private void append(String ... strings) {
        for (String string : strings) {
            this.builder.append(string);
        }
    }

    private static boolean hasMultiple(String string, char c) {
        return string.indexOf(c) != string.lastIndexOf(c);
    }

    private void validateElement(Token t) throws NoViableAltException {
        if (!this.htmlElements.contains(t.getText().toLowerCase())) {
            throw new NoViableAltException(t, null);
        }
    }

    private void validateAttribute(Token t) throws NoViableAltException {
        if (!this.htmlAttributes.contains(t.getText().toLowerCase())) {
            throw new NoViableAltException(t, null);
        }
    }

    private void beginCapture() {
        this.builder = new StringBuilder();
    }

    private String endCapture() {
        String result = this.builder.toString();
        this.builder = this.mainBuilder;
        return result;
    }

    protected String linkTag(String description, String url) {
        return "<a href=\"" + url + "\" class=\"seamTextLink\">" + description + "</a>";
    }

    protected String macroInclude(String macroName) {
        return "";
    }

    protected String paragraphOpenTag() {
        return "<p class=\"seamTextPara\">\n";
    }

    protected String preformattedOpenTag() {
        return "<pre class=\"seamTextPreformatted\">\n";
    }

    protected String blockquoteOpenTag() {
        return "<blockquote class=\"seamTextBlockquote\">\n";
    }

    protected String headline1OpenTag() {
        return "<h1 class=\"seamTextHeadline1\">";
    }

    protected String headline2OpenTag() {
        return "<h2 class=\"seamTextHeadline2\">";
    }

    protected String headline3OpenTag() {
        return "<h3 class=\"seamTextHeadline3\">";
    }

    protected String headline4OpenTag() {
        return "<h4 class=\"seamTextHeadline4\">";
    }

    protected String orderedListOpenTag() {
        return "<ol class=\"seamTextOrderedList\">\n";
    }

    protected String orderedListItemOpenTag() {
        return "<li class=\"seamTextOrderedListItem\">";
    }

    protected String unorderedListOpenTag() {
        return "<ul class=\"seamTextUnorderedList\">\n";
    }

    protected String unorderedListItemOpenTag() {
        return "<li class=\"seamTextUnorderedListItem\">";
    }

    protected SeamTextParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public SeamTextParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 4);
    }

    protected SeamTextParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public SeamTextParser(TokenStream lexer) {
        this(lexer, 4);
    }

    public SeamTextParser(ParserSharedInputState state) {
        super(state, 4);
        this.tokenNames = _tokenNames;
    }

    public final void startRule() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 27) {
            this.newline();
        }
        switch (this.LA(1)) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: {
                switch (this.LA(1)) {
                    case 15: {
                        this.heading();
                        while (this.LA(1) == 27) {
                            this.newline();
                        }
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 24: 
                    case 26: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.text();
                while (this.LA(1) == 15) {
                    this.heading();
                    while (this.LA(1) == 27) {
                        this.newline();
                    }
                    this.text();
                }
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void newline() throws RecognitionException, TokenStreamException {
        Token n = null;
        n = this.LT(1);
        this.match(27);
        this.append(n.getText());
    }

    public final void heading() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 15 && _tokenSet_0.member(this.LA(2))) {
            this.h1();
        } else if (this.LA(1) == 15 && this.LA(2) == 15 && _tokenSet_0.member(this.LA(3))) {
            this.h2();
        } else if (this.LA(1) == 15 && this.LA(2) == 15 && this.LA(3) == 15 && _tokenSet_0.member(this.LA(4))) {
            this.h3();
        } else if (this.LA(1) == 15 && this.LA(2) == 15 && this.LA(3) == 15 && this.LA(4) == 15) {
            this.h4();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.newlineOrEof();
    }

    public final void text() throws RecognitionException, TokenStreamException {
        int _cnt17 = 0;
        while (true) {
            if (_tokenSet_1.member(this.LA(1))) {
                switch (this.LA(1)) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 26: {
                        this.paragraph();
                        break;
                    }
                    case 5: {
                        this.preformatted();
                        break;
                    }
                    case 4: {
                        this.blockquote();
                        break;
                    }
                    case 16: 
                    case 17: {
                        this.list();
                        break;
                    }
                    case 24: {
                        this.html();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                while (this.LA(1) == 27) {
                    this.newline();
                }
            } else {
                if (_cnt17 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ++_cnt17;
        }
    }

    public final void paragraph() throws RecognitionException, TokenStreamException {
        this.append(this.paragraphOpenTag());
        int _cnt20 = 0;
        while (true) {
            if (!_tokenSet_0.member(this.LA(1))) {
                if (_cnt20 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.line();
            this.newlineOrEof();
            ++_cnt20;
        }
        this.append("</p>\n");
        this.newlineOrEof();
    }

    public final void preformatted() throws RecognitionException, TokenStreamException {
        this.match(5);
        this.append(this.preformattedOpenTag());
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: {
                    this.word();
                    continue block9;
                }
                case 8: 
                case 9: {
                    this.punctuation();
                    continue block9;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.specialChars();
                    continue block9;
                }
                case 20: 
                case 21: {
                    this.moreSpecialChars();
                    continue block9;
                }
                case 4: 
                case 23: 
                case 24: 
                case 25: {
                    this.htmlSpecialChars();
                    continue block9;
                }
                case 26: {
                    this.space();
                    continue block9;
                }
                case 27: {
                    this.newline();
                    continue block9;
                }
            }
            break;
        }
        this.match(5);
        this.append("</pre>");
    }

    public final void blockquote() throws RecognitionException, TokenStreamException {
        this.match(4);
        this.append(this.blockquoteOpenTag());
        block8: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 20: 
                case 26: {
                    this.plain();
                    continue block8;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 19: {
                    this.formatted();
                    continue block8;
                }
                case 5: {
                    this.preformatted();
                    continue block8;
                }
                case 27: {
                    this.newline();
                    continue block8;
                }
                case 24: {
                    this.html();
                    continue block8;
                }
                case 16: 
                case 17: {
                    this.list();
                    continue block8;
                }
            }
            break;
        }
        this.match(4);
        this.newlineOrEof();
        this.append("</blockquote>\n");
    }

    public final void list() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 17: {
                this.olist();
                break;
            }
            case 16: {
                this.ulist();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.newlineOrEof();
    }

    public final void html() throws RecognitionException, TokenStreamException {
        this.openTag();
        while (true) {
            if (this.LA(1) == 26 && (this.LA(2) == 12 || this.LA(2) == 23 || this.LA(2) == 26)) {
                this.space();
                continue;
            }
            if (this.LA(1) != 26 || this.LA(2) != 6) break;
            this.space();
            this.attribute();
        }
        switch (this.LA(1)) {
            case 23: {
                this.beforeBody();
                this.body();
                this.closeTagWithBody();
                break;
            }
            case 12: {
                this.closeTagWithNoBody();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void line() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 20: 
            case 26: {
                this.plain();
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                this.formatted();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block11: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 20: 
                case 26: {
                    this.plain();
                    continue block11;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 19: {
                    this.formatted();
                    continue block11;
                }
                case 5: {
                    this.preformatted();
                    continue block11;
                }
                case 4: {
                    this.quoted();
                    continue block11;
                }
                case 24: {
                    this.html();
                    continue block11;
                }
            }
            break;
        }
    }

    public final void newlineOrEof() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 27: {
                this.newline();
                break;
            }
            case 1: {
                this.match(1);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void plain() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 6: 
            case 7: {
                this.word();
                break;
            }
            case 8: 
            case 9: {
                this.punctuation();
                break;
            }
            case 10: {
                this.escape();
                break;
            }
            case 26: {
                this.space();
                break;
            }
            default: {
                if (this.LA(1) == 20 && _tokenSet_2.member(this.LA(2))) {
                    this.link();
                    break;
                }
                if (this.LA(1) == 20 && this.LA(2) == 24) {
                    this.macro();
                    break;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void formatted() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 11: {
                this.bold();
                break;
            }
            case 19: {
                this.underline();
                break;
            }
            case 12: {
                this.italic();
                break;
            }
            case 13: {
                this.monospace();
                break;
            }
            case 14: {
                this.superscript();
                break;
            }
            case 18: {
                this.deleted();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void quoted() throws RecognitionException, TokenStreamException {
        this.match(4);
        this.append("<q>");
        int _cnt65 = 0;
        block10: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 20: 
                case 26: {
                    this.plain();
                    break;
                }
                case 11: {
                    this.bold();
                    break;
                }
                case 19: {
                    this.underline();
                    break;
                }
                case 12: {
                    this.italic();
                    break;
                }
                case 13: {
                    this.monospace();
                    break;
                }
                case 14: {
                    this.superscript();
                    break;
                }
                case 18: {
                    this.deleted();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt65 >= 1) break block10;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt65;
        }
        this.match(4);
        this.append("</q>");
    }

    public final void word() throws RecognitionException, TokenStreamException {
        Token an = null;
        Token uc = null;
        switch (this.LA(1)) {
            case 6: {
                an = this.LT(1);
                this.match(6);
                this.append(an.getText());
                break;
            }
            case 7: {
                uc = this.LT(1);
                this.match(7);
                this.append(uc.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void punctuation() throws RecognitionException, TokenStreamException {
        Token p = null;
        Token sq = null;
        switch (this.LA(1)) {
            case 8: {
                p = this.LT(1);
                this.match(8);
                this.append(p.getText());
                break;
            }
            case 9: {
                sq = this.LT(1);
                this.match(9);
                this.append(sq.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void specialChars() throws RecognitionException, TokenStreamException {
        Token st = null;
        Token sl = null;
        Token b = null;
        Token h = null;
        Token p = null;
        Token eq = null;
        Token hh = null;
        Token e = null;
        Token t = null;
        Token u = null;
        switch (this.LA(1)) {
            case 11: {
                st = this.LT(1);
                this.match(11);
                this.append(st.getText());
                break;
            }
            case 12: {
                sl = this.LT(1);
                this.match(12);
                this.append(sl.getText());
                break;
            }
            case 13: {
                b = this.LT(1);
                this.match(13);
                this.append(b.getText());
                break;
            }
            case 14: {
                h = this.LT(1);
                this.match(14);
                this.append(h.getText());
                break;
            }
            case 15: {
                p = this.LT(1);
                this.match(15);
                this.append(p.getText());
                break;
            }
            case 16: {
                eq = this.LT(1);
                this.match(16);
                this.append(eq.getText());
                break;
            }
            case 17: {
                hh = this.LT(1);
                this.match(17);
                this.append(hh.getText());
                break;
            }
            case 10: {
                e = this.LT(1);
                this.match(10);
                this.append(e.getText());
                break;
            }
            case 18: {
                t = this.LT(1);
                this.match(18);
                this.append(t.getText());
                break;
            }
            case 19: {
                u = this.LT(1);
                this.match(19);
                this.append(u.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void moreSpecialChars() throws RecognitionException, TokenStreamException {
        Token o = null;
        Token c = null;
        switch (this.LA(1)) {
            case 20: {
                o = this.LT(1);
                this.match(20);
                this.append(o.getText());
                break;
            }
            case 21: {
                c = this.LT(1);
                this.match(21);
                this.append(c.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void htmlSpecialChars() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 23: {
                this.match(23);
                this.append("&gt;");
                break;
            }
            case 24: {
                this.match(24);
                this.append("&lt;");
                break;
            }
            case 4: {
                this.match(4);
                this.append("&quot;");
                break;
            }
            case 25: {
                this.match(25);
                this.append("&amp;");
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void space() throws RecognitionException, TokenStreamException {
        Token s = null;
        s = this.LT(1);
        this.match(26);
        this.append(s.getText());
    }

    public final void escape() throws RecognitionException, TokenStreamException {
        this.match(10);
        switch (this.LA(1)) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.specialChars();
                break;
            }
            case 20: 
            case 21: {
                this.moreSpecialChars();
                break;
            }
            case 22: {
                this.evenMoreSpecialChars();
                break;
            }
            case 4: 
            case 23: 
            case 24: 
            case 25: {
                this.htmlSpecialChars();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void link() throws RecognitionException, TokenStreamException {
        this.match(20);
        this.beginCapture();
        while (_tokenSet_3.member(this.LA(1))) {
            this.plain();
        }
        String text = this.endCapture();
        this.match(16);
        this.match(23);
        this.beginCapture();
        this.attributeValue();
        String link = this.endCapture();
        this.append(this.linkTag(text, link));
        this.match(21);
    }

    public final void macro() throws RecognitionException, TokenStreamException {
        this.match(20);
        this.match(24);
        this.match(16);
        this.beginCapture();
        this.attributeValue();
        String macroName = this.endCapture();
        this.append(this.macroInclude(macroName));
        this.match(21);
    }

    public final void bold() throws RecognitionException, TokenStreamException {
        this.match(11);
        this.append("<b>");
        int _cnt47 = 0;
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 20: 
                case 26: {
                    this.plain();
                    break;
                }
                case 19: {
                    this.underline();
                    break;
                }
                case 12: {
                    this.italic();
                    break;
                }
                case 13: {
                    this.monospace();
                    break;
                }
                case 14: {
                    this.superscript();
                    break;
                }
                case 18: {
                    this.deleted();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt47 >= 1) break block9;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt47;
        }
        this.match(11);
        this.append("</b>");
    }

    public final void underline() throws RecognitionException, TokenStreamException {
        this.match(19);
        this.append("<u>");
        int _cnt50 = 0;
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 20: 
                case 26: {
                    this.plain();
                    break;
                }
                case 11: {
                    this.bold();
                    break;
                }
                case 12: {
                    this.italic();
                    break;
                }
                case 13: {
                    this.monospace();
                    break;
                }
                case 14: {
                    this.superscript();
                    break;
                }
                case 18: {
                    this.deleted();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt50 >= 1) break block9;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt50;
        }
        this.match(19);
        this.append("</u>");
    }

    public final void italic() throws RecognitionException, TokenStreamException {
        this.match(12);
        this.append("<i>");
        int _cnt53 = 0;
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 20: 
                case 26: {
                    this.plain();
                    break;
                }
                case 11: {
                    this.bold();
                    break;
                }
                case 19: {
                    this.underline();
                    break;
                }
                case 13: {
                    this.monospace();
                    break;
                }
                case 14: {
                    this.superscript();
                    break;
                }
                case 18: {
                    this.deleted();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt53 >= 1) break block9;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt53;
        }
        this.match(12);
        this.append("</i>");
    }

    public final void monospace() throws RecognitionException, TokenStreamException {
        Token st = null;
        Token sl = null;
        Token h = null;
        Token p = null;
        Token eq = null;
        Token hh = null;
        Token e = null;
        Token t = null;
        Token u = null;
        this.match(13);
        this.append("<tt>");
        int _cnt56 = 0;
        block17: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: {
                    this.word();
                    break;
                }
                case 8: 
                case 9: {
                    this.punctuation();
                    break;
                }
                case 26: {
                    this.space();
                    break;
                }
                case 11: {
                    st = this.LT(1);
                    this.match(11);
                    this.append(st.getText());
                    break;
                }
                case 12: {
                    sl = this.LT(1);
                    this.match(12);
                    this.append(sl.getText());
                    break;
                }
                case 14: {
                    h = this.LT(1);
                    this.match(14);
                    this.append(h.getText());
                    break;
                }
                case 15: {
                    p = this.LT(1);
                    this.match(15);
                    this.append(p.getText());
                    break;
                }
                case 16: {
                    eq = this.LT(1);
                    this.match(16);
                    this.append(eq.getText());
                    break;
                }
                case 17: {
                    hh = this.LT(1);
                    this.match(17);
                    this.append(hh.getText());
                    break;
                }
                case 10: {
                    e = this.LT(1);
                    this.match(10);
                    this.append(e.getText());
                    break;
                }
                case 18: {
                    t = this.LT(1);
                    this.match(18);
                    this.append(t.getText());
                    break;
                }
                case 19: {
                    u = this.LT(1);
                    this.match(19);
                    this.append(u.getText());
                    break;
                }
                case 20: 
                case 21: {
                    this.moreSpecialChars();
                    break;
                }
                case 4: 
                case 23: 
                case 24: 
                case 25: {
                    this.htmlSpecialChars();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt56 >= 1) break block17;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt56;
        }
        this.match(13);
        this.append("</tt>");
    }

    public final void superscript() throws RecognitionException, TokenStreamException {
        this.match(14);
        this.append("<sup>");
        int _cnt59 = 0;
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 20: 
                case 26: {
                    this.plain();
                    break;
                }
                case 11: {
                    this.bold();
                    break;
                }
                case 19: {
                    this.underline();
                    break;
                }
                case 12: {
                    this.italic();
                    break;
                }
                case 13: {
                    this.monospace();
                    break;
                }
                case 18: {
                    this.deleted();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt59 >= 1) break block9;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt59;
        }
        this.match(14);
        this.append("</sup>");
    }

    public final void deleted() throws RecognitionException, TokenStreamException {
        this.match(18);
        this.append("<del>");
        int _cnt62 = 0;
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 20: 
                case 26: {
                    this.plain();
                    break;
                }
                case 11: {
                    this.bold();
                    break;
                }
                case 19: {
                    this.underline();
                    break;
                }
                case 12: {
                    this.italic();
                    break;
                }
                case 13: {
                    this.monospace();
                    break;
                }
                case 14: {
                    this.superscript();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt62 >= 1) break block9;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt62;
        }
        this.match(18);
        this.append("</del>");
    }

    public final void evenMoreSpecialChars() throws RecognitionException, TokenStreamException {
        Token q = null;
        q = this.LT(1);
        this.match(22);
        this.append(q.getText());
    }

    public final void attributeValue() throws RecognitionException, TokenStreamException {
        Token an = null;
        Token p = null;
        block7: while (true) {
            switch (this.LA(1)) {
                case 25: {
                    this.match(25);
                    this.append("&amp;");
                    continue block7;
                }
                case 6: {
                    an = this.LT(1);
                    this.match(6);
                    this.append(an.getText());
                    continue block7;
                }
                case 8: {
                    p = this.LT(1);
                    this.match(8);
                    this.append(p.getText());
                    continue block7;
                }
                case 26: {
                    this.space();
                    continue block7;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.specialChars();
                    continue block7;
                }
            }
            break;
        }
    }

    public final void h1() throws RecognitionException, TokenStreamException {
        this.match(15);
        this.append(this.headline1OpenTag());
        this.line();
        this.append("</h1>");
    }

    public final void h2() throws RecognitionException, TokenStreamException {
        this.match(15);
        this.match(15);
        this.append(this.headline2OpenTag());
        this.line();
        this.append("</h2>");
    }

    public final void h3() throws RecognitionException, TokenStreamException {
        this.match(15);
        this.match(15);
        this.match(15);
        this.append(this.headline3OpenTag());
        this.line();
        this.append("</h3>");
    }

    public final void h4() throws RecognitionException, TokenStreamException {
        this.match(15);
        this.match(15);
        this.match(15);
        this.match(15);
        this.append(this.headline4OpenTag());
        this.line();
        this.append("</h4>");
    }

    public final void olist() throws RecognitionException, TokenStreamException {
        this.append(this.orderedListOpenTag());
        int _cnt76 = 0;
        while (true) {
            if (this.LA(1) != 17) {
                if (_cnt76 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.olistLine();
            this.newlineOrEof();
            ++_cnt76;
        }
        this.append("</ol>\n");
    }

    public final void ulist() throws RecognitionException, TokenStreamException {
        this.append(this.unorderedListOpenTag());
        int _cnt80 = 0;
        while (true) {
            if (this.LA(1) != 16) {
                if (_cnt80 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.ulistLine();
            this.newlineOrEof();
            ++_cnt80;
        }
        this.append("</ul>\n");
    }

    public final void olistLine() throws RecognitionException, TokenStreamException {
        this.match(17);
        this.append(this.orderedListItemOpenTag());
        this.line();
        this.append("</li>");
    }

    public final void ulistLine() throws RecognitionException, TokenStreamException {
        this.match(16);
        this.append(this.unorderedListItemOpenTag());
        this.line();
        this.append("</li>");
    }

    public final void openTag() throws RecognitionException, TokenStreamException {
        Token name = null;
        this.match(24);
        name = this.LT(1);
        this.match(6);
        this.validateElement(name);
        this.append("<");
        this.append(name.getText());
    }

    public final void attribute() throws RecognitionException, TokenStreamException {
        Token att = null;
        att = this.LT(1);
        this.match(6);
        while (this.LA(1) == 26) {
            this.space();
        }
        this.match(16);
        while (this.LA(1) == 26) {
            this.space();
        }
        this.match(4);
        this.validateAttribute(att);
        this.append(att.getText());
        this.append("=\"");
        this.attributeValue();
        this.match(4);
        this.append("\"");
    }

    public final void beforeBody() throws RecognitionException, TokenStreamException {
        this.match(23);
        this.append(">");
    }

    public final void body() throws RecognitionException, TokenStreamException {
        block8: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 20: 
                case 26: {
                    this.plain();
                    continue block8;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 19: {
                    this.formatted();
                    continue block8;
                }
                case 5: {
                    this.preformatted();
                    continue block8;
                }
                case 4: {
                    this.quoted();
                    continue block8;
                }
                case 16: 
                case 17: {
                    this.list();
                    continue block8;
                }
                case 27: {
                    this.newline();
                    continue block8;
                }
            }
            if (this.LA(1) != 24 || this.LA(2) != 6) break;
            this.html();
        }
    }

    public final void closeTagWithBody() throws RecognitionException, TokenStreamException {
        Token name = null;
        this.match(24);
        this.match(12);
        name = this.LT(1);
        this.match(6);
        this.match(23);
        this.append("</");
        this.append(name.getText());
        this.append(">");
    }

    public final void closeTagWithNoBody() throws RecognitionException, TokenStreamException {
        this.match(12);
        this.match(23);
        this.append("/>");
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{68976576L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{85950448L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{68224960L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[]{68159424L, 0L};
        return data;
    }
}

