/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.persistence.PersistenceProvider;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Configuration;
import org.jboss.seam.security.EntityAction;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.seam.security.RunAsOperation;
import org.jboss.seam.security.SimpleGroup;
import org.jboss.seam.security.SimplePrincipal;
import org.jboss.seam.util.Strings;
import org.jboss.seam.web.Session;

@Name(value="org.jboss.seam.security.identity")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0)
@BypassInterceptors
@Startup
public class Identity
implements Serializable {
    public static final String EVENT_LOGIN_SUCCESSFUL = "org.jboss.seam.security.loginSuccessful";
    public static final String EVENT_LOGIN_FAILED = "org.jboss.seam.security.loginFailed";
    public static final String EVENT_NOT_LOGGED_IN = "org.jboss.seam.security.notLoggedIn";
    public static final String EVENT_NOT_AUTHORIZED = "org.jboss.seam.security.notAuthorized";
    public static final String EVENT_PRE_AUTHENTICATE = "org.jboss.seam.security.preAuthenticate";
    public static final String EVENT_POST_AUTHENTICATE = "org.jboss.seam.security.postAuthenticate";
    public static final String EVENT_LOGGED_OUT = "org.jboss.seam.security.loggedOut";
    public static final String EVENT_CREDENTIALS_UPDATED = "org.jboss.seam.security.credentialsUpdated";
    public static final String EVENT_REMEMBER_ME = "org.jboss.seam.security.rememberMe";
    protected static boolean securityEnabled = true;
    public static final String ROLES_GROUP = "Roles";
    private static final String LOGIN_TRIED = "org.jboss.seam.security.loginTried";
    private static final long serialVersionUID = 3751659008033189259L;
    private static final LogProvider log = Logging.getLogProvider(Identity.class);
    private String username;
    private String password;
    private Expressions.MethodExpression authenticateMethod;
    private Principal principal;
    private Subject subject;
    private boolean rememberMe;
    private String jaasConfigName = null;
    private List<String> preAuthenticationRoles = new ArrayList<String>();
    private boolean authenticating = false;

    @Create
    public void create() {
        this.subject = new Subject();
    }

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static void setSecurityEnabled(boolean enabled) {
        securityEnabled = enabled;
    }

    public static Identity instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        Identity instance = (Identity)Component.getInstance(Identity.class, ScopeType.SESSION);
        if (instance == null) {
            throw new IllegalStateException("No Identity could be created");
        }
        return instance;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn(true);
    }

    public boolean isLoggedIn(boolean attemptLogin) {
        if (!this.authenticating && attemptLogin && this.getPrincipal() == null && this.isCredentialsSet() && Contexts.isEventContextActive() && !Contexts.getEventContext().isSet(LOGIN_TRIED)) {
            Contexts.getEventContext().set(LOGIN_TRIED, true);
            this.quietLogin();
        }
        return this.getPrincipal() != null;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean isCredentialsSet() {
        return this.username != null && this.password != null;
    }

    public void checkRestriction(String expr) {
        if (!securityEnabled) {
            return;
        }
        if (!this.evaluateExpression(expr)) {
            if (!this.isLoggedIn()) {
                if (Events.exists()) {
                    Events.instance().raiseEvent("org.jboss.seam.notLoggedIn", new Object[0]);
                }
                if (Events.exists()) {
                    Events.instance().raiseEvent(EVENT_NOT_LOGGED_IN, new Object[0]);
                }
                log.debug(String.format("Error evaluating expression [%s] - User not logged in", expr));
                throw new NotLoggedInException();
            }
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_NOT_AUTHORIZED, new Object[0]);
            }
            throw new AuthorizationException(String.format("Authorization check failed for expression [%s]", expr));
        }
    }

    public String login() {
        try {
            this.authenticate();
            if (log.isDebugEnabled()) {
                log.debug("Login successful for: " + this.getUsername());
            }
            if (Events.exists()) {
                Events.instance().raiseEvent("org.jboss.seam.loginSuccessful", new Object[0]);
            }
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_LOGIN_SUCCESSFUL, new Object[0]);
            }
            return "loggedIn";
        }
        catch (LoginException ex) {
            if (log.isDebugEnabled()) {
                log.debug("Login failed for: " + this.getUsername(), ex);
            }
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_LOGIN_FAILED, ex);
            }
            return null;
        }
    }

    public void quietLogin() {
        try {
            if (this.isCredentialsSet()) {
                this.authenticate();
            }
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    public void authenticate() throws LoginException {
        if (!this.isLoggedIn(false)) {
            this.authenticate(this.getLoginContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(LoginContext loginContext) throws LoginException {
        try {
            this.authenticating = true;
            this.preAuthenticate();
            loginContext.login();
            this.postAuthenticate();
        }
        finally {
            this.authenticating = false;
        }
    }

    protected void preAuthenticate() {
        this.unAuthenticate();
        this.preAuthenticationRoles.clear();
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preAuthenticate", new Object[0]);
        }
        if (Events.exists()) {
            Events.instance().raiseEvent(EVENT_PRE_AUTHENTICATE, new Object[0]);
        }
    }

    protected void postAuthenticate() {
        for (Principal p : this.getSubject().getPrincipals()) {
            if (p instanceof Group || this.principal != null) continue;
            this.principal = p;
            break;
        }
        if (!this.preAuthenticationRoles.isEmpty() && this.isLoggedIn()) {
            for (String role : this.preAuthenticationRoles) {
                this.addRole(role);
            }
            this.preAuthenticationRoles.clear();
        }
        this.password = null;
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postAuthenticate", new Object[0]);
        }
        if (Events.exists()) {
            Events.instance().raiseEvent(EVENT_POST_AUTHENTICATE, this);
        }
    }

    protected void unAuthenticate() {
        this.principal = null;
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            this.getSubject().getPrincipals().remove(sg);
            break;
        }
    }

    protected LoginContext getLoginContext() throws LoginException {
        if (this.getJaasConfigName() != null) {
            return new LoginContext(this.getJaasConfigName(), this.getSubject(), this.getDefaultCallbackHandler());
        }
        return new LoginContext("default", this.getSubject(), this.getDefaultCallbackHandler(), Configuration.instance());
    }

    public void logout() {
        this.principal = null;
        this.unAuthenticate();
        Session.instance().invalidate();
        if (Events.exists()) {
            Events.instance().raiseEvent(EVENT_LOGGED_OUT, new Object[0]);
        }
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.loggedOut", new Object[0]);
        }
    }

    public boolean hasRole(String role) {
        if (!securityEnabled) {
            return true;
        }
        this.isLoggedIn(true);
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            return sg.isMember((Principal)new SimplePrincipal(role));
        }
        return false;
    }

    public boolean addRole(String role) {
        if (role == null || "".equals(role)) {
            return false;
        }
        if (!this.isLoggedIn()) {
            this.preAuthenticationRoles.add(role);
            return false;
        }
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            return sg.addMember((Principal)new SimplePrincipal(role));
        }
        SimpleGroup roleGroup = new SimpleGroup(ROLES_GROUP);
        roleGroup.addMember(new SimplePrincipal(role));
        this.getSubject().getPrincipals().add((Principal)((Object)roleGroup));
        return true;
    }

    public void removeRole(String role) {
        block0: for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            Enumeration e = sg.members();
            while (e.hasMoreElements()) {
                Principal member = (Principal)e.nextElement();
                if (!member.getName().equals(role)) continue;
                sg.removeMember(member);
                continue block0;
            }
        }
    }

    public void checkRole(String role) {
        this.isLoggedIn(true);
        if (!this.hasRole(role)) {
            if (!this.isLoggedIn()) {
                if (Events.exists()) {
                    Events.instance().raiseEvent("org.jboss.seam.notLoggedIn", new Object[0]);
                }
                if (Events.exists()) {
                    Events.instance().raiseEvent(EVENT_NOT_LOGGED_IN, new Object[0]);
                }
                throw new NotLoggedInException();
            }
            throw new AuthorizationException(String.format("Authorization check failed for role [%s]", role));
        }
    }

    public void checkPermission(String name, String action, Object ... arg) {
        this.isLoggedIn(true);
        if (!this.hasPermission(name, action, arg)) {
            if (!this.isLoggedIn()) {
                if (Events.exists()) {
                    Events.instance().raiseEvent("org.jboss.seam.notLoggedIn", new Object[0]);
                }
                if (Events.exists()) {
                    Events.instance().raiseEvent(EVENT_NOT_LOGGED_IN, new Object[0]);
                }
                throw new NotLoggedInException();
            }
            throw new AuthorizationException(String.format("Authorization check failed for permission [%s,%s]", name, action));
        }
    }

    public boolean hasPermission(String name, String action, Object ... arg) {
        return !securityEnabled;
    }

    protected CallbackHandler getDefaultCallbackHandler() {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName(Identity.this.getUsername());
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(Identity.this.getPassword() != null ? Identity.this.getPassword().toCharArray() : null);
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i], "Unsupported callback");
                }
            }
        };
    }

    protected boolean evaluateExpression(String expr) {
        return Expressions.instance().createValueExpression(expr, Boolean.class).getValue();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (!(this.username == username || this.username != null && this.username.equals(username))) {
            this.username = username;
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_CREDENTIALS_UPDATED, new Object[0]);
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (!(this.password == password || this.password != null && this.password.equals(password))) {
            this.password = password;
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_CREDENTIALS_UPDATED, new Object[0]);
            }
        }
    }

    public Expressions.MethodExpression getAuthenticateMethod() {
        return this.authenticateMethod;
    }

    public void setAuthenticateMethod(Expressions.MethodExpression authMethod) {
        this.authenticateMethod = authMethod;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean remember) {
        if (this.rememberMe != remember) {
            this.rememberMe = remember;
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_REMEMBER_ME, this);
            }
        }
    }

    public String getJaasConfigName() {
        return this.jaasConfigName;
    }

    public void setJaasConfigName(String jaasConfigName) {
        this.jaasConfigName = jaasConfigName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void runAs(RunAsOperation operation) {
        Principal savedPrincipal = this.getPrincipal();
        Subject savedSubject = this.getSubject();
        try {
            this.principal = operation.getPrincipal();
            this.subject = operation.getSubject();
            operation.execute();
        }
        finally {
            this.principal = savedPrincipal;
            this.subject = savedSubject;
        }
    }

    public void checkEntityPermission(Object entity, EntityAction action) {
        this.isLoggedIn(true);
        PersistenceProvider provider = PersistenceProvider.instance();
        Class beanClass = provider.getBeanClass(entity);
        if (beanClass != null) {
            String name = Seam.getComponentName(entity.getClass());
            if (name == null) {
                name = beanClass.getName();
            }
            Method m = null;
            switch (action) {
                case READ: {
                    m = provider.getPostLoadMethod(beanClass);
                    break;
                }
                case INSERT: {
                    m = provider.getPrePersistMethod(beanClass);
                    break;
                }
                case UPDATE: {
                    m = provider.getPreUpdateMethod(beanClass);
                    break;
                }
                case DELETE: {
                    m = provider.getPreRemoveMethod(beanClass);
                }
            }
            Restrict restrict = null;
            if (m != null && m.isAnnotationPresent(Restrict.class)) {
                restrict = m.getAnnotation(Restrict.class);
            } else if (entity.getClass().isAnnotationPresent(Restrict.class)) {
                restrict = entity.getClass().getAnnotation(Restrict.class);
            }
            if (restrict != null) {
                if (Strings.isEmpty(restrict.value())) {
                    this.checkPermission(name, action.toString(), entity);
                } else {
                    this.checkRestriction(restrict.value());
                }
            }
        }
    }
}

