/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections {
    public static Object invoke(Method method, Object target, Object ... args) throws Exception {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalArgumentException iae) {
            String message = "Could not invoke method by reflection: " + Reflections.toString(method);
            if (args != null && args.length > 0) {
                message = message + " with parameters: (" + Strings.toClassNameString(", ", args) + ')';
            }
            message = message + " on: " + target.getClass().getName();
            throw new IllegalArgumentException(message, iae);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof Exception) {
                throw (Exception)ite.getCause();
            }
            throw ite;
        }
    }

    public static Object get(Field field, Object target) throws Exception {
        try {
            return field.get(target);
        }
        catch (IllegalArgumentException iae) {
            String message = "Could not get field value by reflection: " + Reflections.toString(field) + " on: " + target.getClass().getName();
            throw new IllegalArgumentException(message, iae);
        }
    }

    public static void set(Field field, Object target, Object value) throws Exception {
        try {
            field.set(target, value);
        }
        catch (IllegalArgumentException iae) {
            String message = "Could not set field value by reflection: " + Reflections.toString(field) + " on: " + field.getDeclaringClass().getName();
            message = value == null ? message + " with null value" : message + " with value: " + value.getClass();
            throw new IllegalArgumentException(message, iae);
        }
    }

    public static Object getAndWrap(Field field, Object target) {
        try {
            return Reflections.get(field, target);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException("exception setting: " + field.getName(), e);
        }
    }

    public static void setAndWrap(Field field, Object target, Object value) {
        try {
            Reflections.set(field, target, value);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException("exception setting: " + field.getName(), e);
        }
    }

    public static Object invokeAndWrap(Method method, Object target, Object ... args) {
        try {
            return Reflections.invoke(method, target, args);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("exception invoking: " + method.getName(), e);
        }
    }

    private static String toString(Method method) {
        return Strings.unqualify(method.getDeclaringClass().getName()) + '.' + method.getName() + '(' + Strings.toString(", ", method.getParameterTypes()) + ')';
    }

    private static String toString(Field field) {
        return Strings.unqualify(field.getDeclaringClass().getName()) + '.' + field.getName();
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static boolean isClassAvailable(String name) {
        try {
            Reflections.classForName(name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static Class getCollectionElementType(Type collectionType) {
        Type typeArgument;
        if (!(collectionType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("collection type not parameterized");
        }
        Type[] typeArguments = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (typeArguments.length == 0) {
            throw new IllegalArgumentException("no type arguments for collection type");
        }
        Type type = typeArgument = typeArguments.length == 1 ? typeArguments[0] : typeArguments[1];
        if (!(typeArgument instanceof Class)) {
            throw new IllegalArgumentException("type argument not a class");
        }
        return (Class)typeArgument;
    }

    public static Class getMapKeyType(Type collectionType) {
        if (!(collectionType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("collection type not parameterized");
        }
        Type[] typeArguments = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (typeArguments.length == 0) {
            throw new IllegalArgumentException("no type arguments for collection type");
        }
        Type typeArgument = typeArguments[0];
        if (!(typeArgument instanceof Class)) {
            throw new IllegalArgumentException("type argument not a class");
        }
        return (Class)typeArgument;
    }

    public static Method getSetterMethod(Class clazz, String name) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || !Introspector.decapitalize(methodName.substring(3)).equals(name)) continue;
            return method;
        }
        throw new IllegalArgumentException("no such setter method: " + clazz.getName() + '.' + name);
    }

    public static Method getGetterMethod(Class clazz, String name) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.matches("^(get|is).*") || method.getParameterTypes().length != 0 || !Introspector.decapitalize(methodName.substring(3)).equals(name)) continue;
            return method;
        }
        throw new IllegalArgumentException("no such getter method: " + clazz.getName() + '.' + name);
    }

    public static List<Method> getGetterMethods(Class clazz, Class annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static Field getField(Class clazz, String name) {
        for (Class superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new IllegalArgumentException("no such field: " + clazz.getName() + '.' + name);
    }

    public static Method getMethod(Class clazz, String name) {
        for (Class superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        throw new IllegalArgumentException("no such method: " + clazz.getName() + '.' + name);
    }

    public static List<Field> getFields(Class clazz, Class annotation) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            for (Field field : superClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(annotation)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static Method getMethod(Annotation annotation, String name) {
        try {
            return annotation.annotationType().getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    public static boolean isInstanceOf(Class clazz, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        for (Class c = clazz; c != Object.class; c = c.getSuperclass()) {
            if (!name.equals(c.getName())) continue;
            return true;
        }
        for (Class<?> c : clazz.getInterfaces()) {
            if (!name.equals(c.getName())) continue;
            return true;
        }
        return false;
    }
}

