/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Entity;
import org.jboss.seam.Component;
import org.jboss.seam.ComponentType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Role;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.faces.Converter;
import org.jboss.seam.annotations.faces.Validator;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.init.DeploymentDescriptor;
import org.jboss.seam.init.EjbDescriptor;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Strings;
import org.jboss.seam.web.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Seam {
    private static final Map<Class, String> COMPONENT_NAME_CACHE = new ConcurrentHashMap<Class, String>();
    private static final Map<Class, EjbDescriptor> EJB_DESCRIPTOR_CACHE = new ConcurrentHashMap<Class, EjbDescriptor>();

    private static EjbDescriptor getEjbDescriptor(Class clazz) {
        EjbDescriptor info = EJB_DESCRIPTOR_CACHE.get(clazz);
        if (info != null) {
            return info;
        }
        Map<Class, EjbDescriptor> ejbDescriptors = new DeploymentDescriptor(clazz).getEjbDescriptors();
        EJB_DESCRIPTOR_CACHE.putAll(ejbDescriptors);
        return ejbDescriptors.get(clazz);
    }

    public static ScopeType getComponentScope(Class<?> clazz) {
        return clazz.isAnnotationPresent(Scope.class) ? clazz.getAnnotation(Scope.class).value() : Seam.getDefaultComponentScope(clazz);
    }

    public static ScopeType getDefaultComponentScope(Class<?> clazz) {
        return clazz.isAnnotationPresent(Validator.class) || clazz.isAnnotationPresent(Converter.class) ? ScopeType.STATELESS : Seam.getComponentType(clazz).getDefaultScope();
    }

    public static ScopeType getComponentRoleScope(Class clazz, Role role) {
        return role.scope() == ScopeType.UNSPECIFIED ? Seam.getComponentType(clazz).getDefaultScope() : role.scope();
    }

    public static ComponentType getComponentType(Class<?> clazz) {
        if (clazz.isAnnotationPresent(EJB.STATEFUL)) {
            return ComponentType.STATEFUL_SESSION_BEAN;
        }
        if (clazz.isAnnotationPresent(EJB.STATELESS)) {
            return ComponentType.STATELESS_SESSION_BEAN;
        }
        if (clazz.isAnnotationPresent(EJB.MESSAGE_DRIVEN)) {
            return ComponentType.MESSAGE_DRIVEN_BEAN;
        }
        if (clazz.isAnnotationPresent(Entity.class)) {
            return ComponentType.ENTITY_BEAN;
        }
        EjbDescriptor ejbDescriptor = Seam.getEjbDescriptor(clazz);
        if (ejbDescriptor == null) {
            return ComponentType.JAVA_BEAN;
        }
        return ejbDescriptor.getBeanType();
    }

    public static String getComponentName(Class<?> clazz) {
        String result = COMPONENT_NAME_CACHE.get(clazz);
        if (result == null && (result = Seam.searchComponentName(clazz)) != null) {
            COMPONENT_NAME_CACHE.put(clazz, result);
        }
        return result;
    }

    public static String searchComponentName(Class<?> clazz) {
        while (clazz != null && !Object.class.equals(clazz)) {
            Name name = clazz.getAnnotation(Name.class);
            if (name != null) {
                return name.value();
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Class getEntityClass(Class<?> clazz) {
        while (clazz != null && !Object.class.equals(clazz)) {
            if (clazz.isAnnotationPresent(Entity.class)) {
                return clazz;
            }
            EjbDescriptor ejbDescriptor = EJB_DESCRIPTOR_CACHE.get(clazz);
            if (ejbDescriptor != null) {
                return ejbDescriptor.getBeanType() == ComponentType.ENTITY_BEAN ? clazz : null;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static boolean isEntityClass(Class<?> clazz) {
        return Seam.getEntityClass(clazz) != null;
    }

    public static String getEjbName(Class<?> clazz) {
        switch (Seam.getComponentType(clazz)) {
            case ENTITY_BEAN: 
            case JAVA_BEAN: {
                return null;
            }
            case STATEFUL_SESSION_BEAN: {
                return clazz.isAnnotationPresent(EJB.STATEFUL) ? Seam.getStatefulEjbName(clazz) : Seam.getEjbNameFromDescriptor(clazz);
            }
            case STATELESS_SESSION_BEAN: {
                return clazz.isAnnotationPresent(EJB.STATELESS) ? Seam.getStatelessEjbName(clazz) : Seam.getEjbNameFromDescriptor(clazz);
            }
            case MESSAGE_DRIVEN_BEAN: {
                return clazz.isAnnotationPresent(EJB.MESSAGE_DRIVEN) ? Seam.getMessageDrivenEjbName(clazz) : Seam.getEjbNameFromDescriptor(clazz);
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getMessageDrivenEjbName(Class<?> clazz) {
        String mdName = EJB.name(clazz.getAnnotation(EJB.MESSAGE_DRIVEN));
        return mdName.equals("") ? Seam.unqualifyClassName(clazz) : mdName;
    }

    private static String getStatelessEjbName(Class<?> clazz) {
        String statelessName = EJB.name(clazz.getAnnotation(EJB.STATELESS));
        return statelessName.equals("") ? Seam.unqualifyClassName(clazz) : statelessName;
    }

    private static String getStatefulEjbName(Class<?> clazz) {
        String statefulName = EJB.name(clazz.getAnnotation(EJB.STATEFUL));
        return statefulName.equals("") ? Seam.unqualifyClassName(clazz) : statefulName;
    }

    private static String getEjbNameFromDescriptor(Class<?> clazz) {
        EjbDescriptor ejbDescriptor = Seam.getEjbDescriptor(clazz);
        return ejbDescriptor == null ? null : ejbDescriptor.getEjbName();
    }

    private static String unqualifyClassName(Class<?> clazz) {
        return Strings.unqualify(Strings.unqualify(clazz.getName()), '$');
    }

    public static boolean isInterceptionEnabled(Class<?> clazz) {
        ComponentType componentType = Seam.getComponentType(clazz);
        if (componentType == ComponentType.ENTITY_BEAN) {
            return false;
        }
        if (Seam.getComponentType(clazz) == ComponentType.MESSAGE_DRIVEN_BEAN) {
            return true;
        }
        return !clazz.isAnnotationPresent(BypassInterceptors.class);
    }

    public static void invalidateSession() {
        Session.instance().invalidate();
    }

    public static boolean isSessionInvalid() {
        return Session.instance().isInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component componentForName(String name) {
        if (Contexts.isApplicationContextActive()) {
            return Component.forName(name);
        }
        Lifecycle.mockApplication();
        try {
            Component component = Component.forName(name);
            return component;
        }
        finally {
            Lifecycle.unmockApplication();
        }
    }

    public static String getVersion() {
        Package pkg = Seam.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    public static void clearComponentNameCache() {
        COMPONENT_NAME_CACHE.clear();
        EJB_DESCRIPTOR_CACHE.clear();
    }
}

