/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.management.IdentityStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.security.identityManager")
@Install(precedence=0)
public class IdentityManager {
    public static final String IDENTITY_STORE_COMPONENT_NAME = "identityStore";
    public static final String ACCOUNT_PERMISSION_NAME = "seam.account";
    public static final String PERMISSION_CREATE = "create";
    public static final String PERMISSION_READ = "read";
    public static final String PERMISSION_UPDATE = "update";
    public static final String PERMISSION_DELETE = "delete";
    private static final LogProvider log = Logging.getLogProvider(IdentityManager.class);
    private IdentityStore identityStore;

    @Create
    public void create() {
        this.initIdentityStore();
    }

    protected void initIdentityStore() {
        if (this.identityStore == null) {
            this.identityStore = (IdentityStore)Component.getInstance(IDENTITY_STORE_COMPONENT_NAME, true);
        }
        if (this.identityStore == null) {
            log.warn("no identity store available - please install an IdentityStore with the name 'identityStore' if identity management is required.");
        }
    }

    public static IdentityManager instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        IdentityManager instance = (IdentityManager)Component.getInstance(IdentityManager.class, ScopeType.APPLICATION);
        if (instance == null) {
            throw new IllegalStateException("No IdentityManager could be created");
        }
        return instance;
    }

    public boolean createUser(String name, String password) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_CREATE, new Object[0]);
        return this.identityStore.createUser(name, password);
    }

    public boolean deleteUser(String name) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_DELETE, new Object[0]);
        return this.identityStore.deleteUser(name);
    }

    public boolean enableUser(String name) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_UPDATE, new Object[0]);
        return this.identityStore.enableUser(name);
    }

    public boolean disableUser(String name) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_UPDATE, new Object[0]);
        return this.identityStore.disableUser(name);
    }

    public boolean changePassword(String name, String password) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_UPDATE, new Object[0]);
        return this.identityStore.changePassword(name, password);
    }

    public boolean isUserEnabled(String name) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_READ, new Object[0]);
        return this.identityStore.isUserEnabled(name);
    }

    public boolean grantRole(String name, String role) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_UPDATE, new Object[0]);
        return this.identityStore.grantRole(name, role);
    }

    public boolean revokeRole(String name, String role) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_UPDATE, new Object[0]);
        return this.identityStore.revokeRole(name, role);
    }

    public boolean createRole(String role) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_CREATE, new Object[0]);
        return this.identityStore.createRole(role);
    }

    public boolean deleteRole(String role) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_DELETE, new Object[0]);
        return this.identityStore.deleteRole(role);
    }

    public boolean userExists(String name) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_READ, new Object[0]);
        return this.identityStore.userExists(name);
    }

    public boolean roleExists(String name) {
        return this.identityStore.roleExists(name);
    }

    public List<String> listUsers() {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_READ, new Object[0]);
        List<String> users = this.identityStore.listUsers();
        Collections.sort(users, new Comparator<String>(){

            @Override
            public int compare(String value1, String value2) {
                return value1.compareTo(value2);
            }
        });
        return users;
    }

    public List<String> listUsers(String filter) {
        Identity.instance().checkPermission(ACCOUNT_PERMISSION_NAME, PERMISSION_READ, new Object[0]);
        List<String> users = this.identityStore.listUsers(filter);
        Collections.sort(users, new Comparator<String>(){

            @Override
            public int compare(String value1, String value2) {
                return value1.compareTo(value2);
            }
        });
        return users;
    }

    public List<String> listRoles() {
        List<String> roles = this.identityStore.listRoles();
        Collections.sort(roles, new Comparator<String>(){

            @Override
            public int compare(String value1, String value2) {
                return value1.compareTo(value2);
            }
        });
        return roles;
    }

    public List<String> getGrantedRoles(String name) {
        return this.identityStore.getGrantedRoles(name);
    }

    public List<String> getImpliedRoles(String name) {
        return this.identityStore.getImpliedRoles(name);
    }

    public boolean authenticate(String username, String password) {
        return this.identityStore.authenticate(username, password);
    }

    public IdentityStore getIdentityStore() {
        return this.identityStore;
    }

    public void setIdentityStore(IdentityStore identityStore) {
        this.identityStore = identityStore;
    }
}

