/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cache;

import java.io.InputStream;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheProvider<T> {
    public static final String DEFAULT_REGION = "org.jboss.seam.cache.DefaultRegion";
    private String configuration;
    private String defaultRegion = "org.jboss.seam.cache.DefaultRegion";

    public abstract T getDelegate();

    public String getConfiguration() {
        return this.configuration;
    }

    protected InputStream getConfigurationAsStream() {
        return ResourceLoader.instance().getResourceAsStream(this.getConfiguration());
    }

    public void setConfiguration(String cfgResourceName) {
        this.configuration = cfgResourceName;
    }

    public Object get(String key) {
        return this.get(null, key);
    }

    public abstract Object get(String var1, String var2);

    public void put(String key, Object object) {
        this.put(null, key, object);
    }

    public abstract void put(String var1, String var2, Object var3);

    public void remove(String key) {
        this.remove(null, key);
    }

    public abstract void remove(String var1, String var2);

    public abstract void clear();

    public String getDefaultRegion() {
        return this.defaultRegion;
    }

    public void setDefaultRegion(String defaultRegion) {
        this.defaultRegion = defaultRegion;
    }

    public static CacheProvider instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application scope");
        }
        return (CacheProvider)Component.getInstance("org.jboss.seam.cache.cacheProvider", ScopeType.APPLICATION);
    }

    public static <T> CacheProvider<T> instance(Class<? extends T> type) {
        return CacheProvider.instance();
    }
}

