/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.seam.deployment.AbstractScanner;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLScanner
extends AbstractScanner {
    private static final LogProvider log = Logging.getLogProvider(URLScanner.class);

    public URLScanner(DeploymentStrategy deploymentStrategy) {
        super(deploymentStrategy);
    }

    @Override
    public void scanDirectories(File[] directories) {
        for (File directory : directories) {
            this.handleDirectory(directory, null);
        }
    }

    @Override
    public void scanResources(String[] resources) {
        HashSet<String> paths = new HashSet<String>();
        for (String resourceName : resources) {
            try {
                Enumeration<URL> urlEnum = this.getDeploymentStrategy().getClassLoader().getResources(resourceName);
                while (urlEnum.hasMoreElements()) {
                    String urlPath = urlEnum.nextElement().getFile();
                    if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                    if (urlPath.indexOf(33) > 0) {
                        urlPath = urlPath.substring(0, urlPath.indexOf(33));
                    } else {
                        File dirOrArchive = new File(urlPath);
                        if (resourceName != null && resourceName.lastIndexOf(47) > 0) {
                            dirOrArchive = dirOrArchive.getParentFile();
                        }
                        urlPath = dirOrArchive.getParent();
                    }
                    paths.add(urlPath);
                }
            }
            catch (IOException ioe) {
                log.warn("could not read: " + resourceName, ioe);
            }
        }
        this.handle(paths);
    }

    protected void handle(Set<String> paths) {
        for (String urlPath : paths) {
            try {
                log.debug("scanning: " + urlPath);
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.handleDirectory(file, null);
                    continue;
                }
                this.handleArchiveByFile(file);
            }
            catch (IOException ioe) {
                log.warn("could not read entries", ioe);
            }
        }
    }

    private void handleArchiveByFile(File file) throws IOException {
        try {
            log.debug("archive: " + file);
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                this.handleItem(name);
            }
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    private void handleDirectory(File file, String path) {
        log.debug("directory: " + file);
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
                continue;
            }
            this.handleItem(newPath);
        }
    }
}

