/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.framework;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.framework.EntityNotFoundException;
import org.jboss.seam.framework.MutableController;
import org.jboss.seam.international.StatusMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
public abstract class Home<T, E>
extends MutableController<T> {
    private static final long serialVersionUID = -5462396456614090423L;
    private Object id;
    protected E instance;
    private Class<E> entityClass;
    protected Expressions.ValueExpression newInstance;
    private String deletedMessage = "Successfully deleted";
    private String createdMessage = "Successfully created";
    private String updatedMessage = "Successfully updated";

    protected void updatedMessage() {
        this.debug((Object)"updated entity #0 #1", this.getEntityClass().getName(), this.getId());
        this.getStatusMessages().addFromResourceBundleOrDefault(StatusMessage.Severity.INFO, this.getUpdatedMessageKey(), this.getUpdatedMessage(), new Object[0]);
    }

    protected void deletedMessage() {
        this.debug((Object)"deleted entity #0 #1", this.getEntityClass().getName(), this.getId());
        this.getStatusMessages().addFromResourceBundleOrDefault(StatusMessage.Severity.INFO, this.getDeletedMessageKey(), this.getDeletedMessage(), new Object[0]);
    }

    protected void createdMessage() {
        this.debug((Object)"created entity #0 #1", this.getEntityClass().getName(), this.getId());
        this.getStatusMessages().addFromResourceBundleOrDefault(StatusMessage.Severity.INFO, this.getCreatedMessageKey(), this.getCreatedMessage(), new Object[0]);
    }

    @Create
    public void create() {
        if (this.getEntityClass() == null) {
            throw new IllegalStateException("entityClass is null");
        }
    }

    @Transactional
    public E getInstance() {
        this.joinTransaction();
        if (this.instance == null) {
            this.initInstance();
        }
        return this.instance;
    }

    public void clearInstance() {
        this.setInstance(null);
        this.setId(null);
    }

    protected void initInstance() {
        if (this.isIdDefined()) {
            if (!this.isTransactionMarkedRollback()) {
                this.setInstance(this.find());
            }
        } else {
            this.setInstance(this.createInstance());
        }
    }

    protected void joinTransaction() {
    }

    protected E find() {
        return null;
    }

    protected E handleNotFound() {
        throw new EntityNotFoundException(this.getId(), this.getEntityClass());
    }

    protected E createInstance() {
        if (this.newInstance != null) {
            return (E)this.newInstance.getValue();
        }
        if (this.getEntityClass() != null) {
            try {
                return this.getEntityClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public Class<E> getEntityClass() {
        if (this.entityClass == null) {
            Type type = this.getClass().getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)type;
                if (paramType.getActualTypeArguments().length == 2) {
                    if (paramType.getActualTypeArguments()[1] instanceof TypeVariable) {
                        throw new IllegalArgumentException("Could not guess entity class by reflection");
                    }
                    this.entityClass = (Class)paramType.getActualTypeArguments()[1];
                } else {
                    this.entityClass = (Class)paramType.getActualTypeArguments()[0];
                }
            } else {
                throw new IllegalArgumentException("Could not guess entity class by reflection");
            }
        }
        return this.entityClass;
    }

    public void setEntityClass(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        if (this.setDirty(this.id, id)) {
            this.setInstance(null);
        }
        this.id = id;
    }

    protected void assignId(Object id) {
        this.setDirty(this.id, id);
        this.id = id;
    }

    public boolean isIdDefined() {
        return this.getId() != null && !"".equals(this.getId());
    }

    public void setInstance(E instance) {
        this.setDirty(this.instance, instance);
        this.instance = instance;
    }

    public Expressions.ValueExpression getNewInstance() {
        return this.newInstance;
    }

    public void setNewInstance(Expressions.ValueExpression newInstance) {
        this.newInstance = newInstance;
    }

    public String getCreatedMessage() {
        return this.createdMessage;
    }

    public void setCreatedMessage(String createdMessage) {
        this.createdMessage = createdMessage;
    }

    public String getDeletedMessage() {
        return this.deletedMessage;
    }

    public void setDeletedMessage(String deletedMessage) {
        this.deletedMessage = deletedMessage;
    }

    public String getUpdatedMessage() {
        return this.updatedMessage;
    }

    public void setUpdatedMessage(String updatedMessage) {
        this.updatedMessage = updatedMessage;
    }

    protected String getMessageKeyPrefix() {
        String className = this.getEntityClass().getName();
        return className.substring(className.lastIndexOf(46) + 1) + '_';
    }

    protected String getCreatedMessageKey() {
        return this.getMessageKeyPrefix() + "created";
    }

    protected String getUpdatedMessageKey() {
        return this.getMessageKeyPrefix() + "updated";
    }

    protected String getDeletedMessageKey() {
        return this.getMessageKeyPrefix() + "deleted";
    }

    protected void raiseAfterTransactionSuccessEvent() {
        this.raiseTransactionSuccessEvent("org.jboss.seam.afterTransactionSuccess", new Object[0]);
        String simpleEntityName = this.getSimpleEntityName();
        if (simpleEntityName != null) {
            this.raiseTransactionSuccessEvent("org.jboss.seam.afterTransactionSuccess." + simpleEntityName, new Object[0]);
        }
    }

    protected String getSimpleEntityName() {
        String name = this.getEntityName();
        if (name != null) {
            return name.lastIndexOf(".") > 0 && name.lastIndexOf(".") < name.length() ? name.substring(name.lastIndexOf(".") + 1, name.length()) : name;
        }
        return null;
    }

    protected abstract String getEntityName();
}

