/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.SimpleGroup;
import org.jboss.seam.security.SimplePrincipal;

public abstract class RunAsOperation {
    private Principal principal = new SimplePrincipal(null);
    private Subject subject = new Subject();
    private Set<String> roles = new HashSet<String>();
    private boolean systemOp = false;

    public RunAsOperation() {
    }

    public RunAsOperation(boolean systemOp) {
        this();
        systemOp = true;
    }

    public abstract void execute();

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public RunAsOperation addRole(String role) {
        this.roles.add(role);
        return this;
    }

    public boolean isSystemOperation() {
        return this.systemOp;
    }

    public void run() {
        for (String role : this.roles) {
            for (Group sg : this.getSubject().getPrincipals(Group.class)) {
                if (!"Roles".equals(sg.getName())) continue;
                sg.addMember((Principal)new SimplePrincipal(role));
                break;
            }
            SimpleGroup roleGroup = new SimpleGroup("Roles");
            roleGroup.addMember(new SimplePrincipal(role));
            this.getSubject().getPrincipals().add((Principal)((Object)roleGroup));
        }
        Identity.instance().runAs(this);
    }
}

