/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.security.management.RoleConditional;
import org.jboss.seam.annotations.security.management.RoleGroups;
import org.jboss.seam.annotations.security.management.RoleName;
import org.jboss.seam.annotations.security.management.UserEnabled;
import org.jboss.seam.annotations.security.management.UserFirstName;
import org.jboss.seam.annotations.security.management.UserLastName;
import org.jboss.seam.annotations.security.management.UserPassword;
import org.jboss.seam.annotations.security.management.UserPrincipal;
import org.jboss.seam.annotations.security.management.UserRoles;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.management.IdentityManagementException;
import org.jboss.seam.security.management.IdentityStore;
import org.jboss.seam.security.management.NoSuchRoleException;
import org.jboss.seam.security.management.NoSuchUserException;
import org.jboss.seam.security.management.PasswordHash;
import org.jboss.seam.util.AnnotatedBeanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.security.jpaIdentityStore")
@Install(precedence=0, value=false)
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
public class JpaIdentityStore
implements IdentityStore,
Serializable {
    public static final String AUTHENTICATED_USER = "org.jboss.seam.security.management.authenticatedUser";
    public static final String EVENT_USER_CREATED = "org.jboss.seam.security.management.userCreated";
    public static final String EVENT_PRE_PERSIST_USER = "org.jboss.seam.security.management.prePersistUser";
    public static final String EVENT_USER_AUTHENTICATED = "org.jboss.seam.security.management.userAuthenticated";
    private static final LogProvider log = Logging.getLogProvider(JpaIdentityStore.class);
    protected IdentityStore.FeatureSet featureSet;
    private Expressions.ValueExpression<EntityManager> entityManager;
    private Class userClass;
    private Class roleClass;
    private AnnotatedBeanProperty<UserPrincipal> userPrincipalProperty;
    private AnnotatedBeanProperty<UserPassword> userPasswordProperty;
    private AnnotatedBeanProperty<UserRoles> userRolesProperty;
    private AnnotatedBeanProperty<UserEnabled> userEnabledProperty;
    private AnnotatedBeanProperty<UserFirstName> userFirstNameProperty;
    private AnnotatedBeanProperty<UserLastName> userLastNameProperty;
    private AnnotatedBeanProperty<RoleName> roleNameProperty;
    private AnnotatedBeanProperty<RoleGroups> roleGroupsProperty;
    private AnnotatedBeanProperty<RoleConditional> roleConditionalProperty;

    public Set<IdentityStore.Feature> getFeatures() {
        return this.featureSet.getFeatures();
    }

    public void setFeatures(Set<IdentityStore.Feature> features) {
        this.featureSet = new IdentityStore.FeatureSet(features);
    }

    @Override
    public boolean supportsFeature(IdentityStore.Feature feature) {
        return this.featureSet.supports(feature);
    }

    @Create
    public void init() {
        if (this.featureSet == null) {
            this.featureSet = new IdentityStore.FeatureSet();
            this.featureSet.enableAll();
        }
        if (this.entityManager == null) {
            this.entityManager = Expressions.instance().createValueExpression("#{entityManager}", EntityManager.class);
        }
        if (this.userClass == null) {
            log.error("Error in JpaIdentityStore configuration - userClass must be configured.");
            return;
        }
        this.initProperties();
    }

    private void initProperties() {
        this.userPrincipalProperty = AnnotatedBeanProperty.scanForProperty(this.userClass, UserPrincipal.class);
        this.userPasswordProperty = AnnotatedBeanProperty.scanForProperty(this.userClass, UserPassword.class);
        this.userRolesProperty = AnnotatedBeanProperty.scanForProperty(this.userClass, UserRoles.class);
        this.userEnabledProperty = AnnotatedBeanProperty.scanForProperty(this.userClass, UserEnabled.class);
        this.userFirstNameProperty = AnnotatedBeanProperty.scanForProperty(this.userClass, UserFirstName.class);
        this.userLastNameProperty = AnnotatedBeanProperty.scanForProperty(this.userClass, UserLastName.class);
        if (this.roleClass != null) {
            this.roleNameProperty = AnnotatedBeanProperty.scanForProperty(this.roleClass, RoleName.class);
            this.roleGroupsProperty = AnnotatedBeanProperty.scanForProperty(this.roleClass, RoleGroups.class);
            this.roleConditionalProperty = AnnotatedBeanProperty.scanForProperty(this.roleClass, RoleConditional.class);
        }
        if (this.userPrincipalProperty == null) {
            throw new IdentityManagementException("Invalid userClass " + this.userClass.getName() + " - required annotation @UserPrincipal not found on any Field or Method.");
        }
        if (this.userRolesProperty == null) {
            throw new IdentityManagementException("Invalid userClass " + this.userClass.getName() + " - required annotation @UserRoles not found on any Field or Method.");
        }
        if (this.roleClass != null && this.roleNameProperty == null) {
            throw new IdentityManagementException("Invalid roleClass " + this.roleClass.getName() + " - required annotation @RoleName not found on any Field or Method.");
        }
    }

    @Override
    public boolean createUser(String username, String password, String firstname, String lastname) {
        try {
            if (this.userClass == null) {
                throw new IdentityManagementException("Could not create account, userClass not set");
            }
            if (this.userExists(username)) {
                throw new IdentityManagementException("Could not create account, already exists");
            }
            Object user = this.userClass.newInstance();
            this.userPrincipalProperty.setValue(user, username);
            if (this.userFirstNameProperty != null) {
                this.userFirstNameProperty.setValue(user, firstname);
            }
            if (this.userLastNameProperty != null) {
                this.userLastNameProperty.setValue(user, lastname);
            }
            if (password == null) {
                if (this.userEnabledProperty != null) {
                    this.userEnabledProperty.setValue(user, false);
                }
            } else {
                this.userPasswordProperty.setValue(user, this.generatePasswordHash(password, this.getUserAccountSalt(user)));
                if (this.userEnabledProperty != null) {
                    this.userEnabledProperty.setValue(user, true);
                }
            }
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_PRE_PERSIST_USER, user);
            }
            this.persistEntity(user);
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_USER_CREATED, user);
            }
            return true;
        }
        catch (Exception ex) {
            if (ex instanceof IdentityManagementException) {
                throw (IdentityManagementException)ex;
            }
            throw new IdentityManagementException("Could not create account", ex);
        }
    }

    protected String getUserAccountSalt(Object user) {
        return this.userPrincipalProperty.getValue(user).toString();
    }

    @Override
    public boolean createUser(String username, String password) {
        return this.createUser(username, password, null, null);
    }

    @Override
    public boolean deleteUser(String name) {
        Object user = this.lookupUser(name);
        if (user == null) {
            throw new NoSuchUserException("Could not delete, user '" + name + "' does not exist");
        }
        this.removeEntity(user);
        return true;
    }

    @Override
    public boolean grantRole(String username, String role) {
        Object roleToGrant;
        if (this.roleClass == null) {
            return false;
        }
        Object user = this.lookupUser(username);
        if (user == null) {
            if (this.userPasswordProperty != null) {
                throw new NoSuchUserException("Could not grant role, no such user '" + username + "'");
            }
            if (this.createUser(username, null)) {
                user = this.lookupUser(username);
            } else {
                throw new IdentityManagementException("Could not grant role - user does not exist and an attempt to create the user failed.");
            }
        }
        if ((roleToGrant = this.lookupRole(role)) == null) {
            throw new NoSuchRoleException("Could not grant role, role '" + role + "' does not exist");
        }
        AbstractCollection userRoles = (HashSet)this.userRolesProperty.getValue(user);
        if (userRoles == null) {
            if (Set.class.isAssignableFrom(this.userRolesProperty.getPropertyClass())) {
                userRoles = new HashSet();
            } else if (List.class.isAssignableFrom(this.userRolesProperty.getPropertyClass())) {
                userRoles = new ArrayList();
            }
            this.userRolesProperty.setValue(user, userRoles);
        } else if (((Collection)this.userRolesProperty.getValue(user)).contains(roleToGrant)) {
            return false;
        }
        ((Collection)this.userRolesProperty.getValue(user)).add(roleToGrant);
        this.mergeEntity(user);
        return true;
    }

    @Override
    public boolean revokeRole(String username, String role) {
        Object user = this.lookupUser(username);
        if (user == null) {
            throw new NoSuchUserException("Could not revoke role, no such user '" + username + "'");
        }
        Object roleToRevoke = this.lookupRole(role);
        if (roleToRevoke == null) {
            throw new NoSuchRoleException("Could not revoke role, role '" + role + "' does not exist");
        }
        boolean success = ((Collection)this.userRolesProperty.getValue(user)).remove(roleToRevoke);
        if (success) {
            this.mergeEntity(user);
        }
        return success;
    }

    @Override
    public boolean addRoleToGroup(String role, String group) {
        if (this.roleGroupsProperty == null) {
            return false;
        }
        Object targetRole = this.lookupRole(role);
        if (targetRole == null) {
            throw new NoSuchUserException("Could not add role to group, no such role '" + role + "'");
        }
        Object targetGroup = this.lookupRole(group);
        if (targetGroup == null) {
            throw new NoSuchRoleException("Could not grant role, group '" + group + "' does not exist");
        }
        AbstractCollection roleGroups = (HashSet)this.roleGroupsProperty.getValue(targetRole);
        if (roleGroups == null) {
            if (Set.class.isAssignableFrom(this.roleGroupsProperty.getPropertyClass())) {
                roleGroups = new HashSet();
            } else if (List.class.isAssignableFrom(this.roleGroupsProperty.getPropertyClass())) {
                roleGroups = new ArrayList();
            }
            this.roleGroupsProperty.setValue(targetRole, roleGroups);
        } else if (((Collection)this.roleGroupsProperty.getValue(targetRole)).contains(targetGroup)) {
            return false;
        }
        ((Collection)this.roleGroupsProperty.getValue(targetRole)).add(targetGroup);
        this.mergeEntity(targetRole);
        return true;
    }

    @Override
    public boolean removeRoleFromGroup(String role, String group) {
        if (this.roleGroupsProperty == null) {
            return false;
        }
        Object roleToRemove = this.lookupRole(role);
        if (role == null) {
            throw new NoSuchUserException("Could not remove role from group, no such role '" + role + "'");
        }
        Object targetGroup = this.lookupRole(group);
        if (targetGroup == null) {
            throw new NoSuchRoleException("Could not remove role from group, no such group '" + group + "'");
        }
        boolean success = ((Collection)this.roleGroupsProperty.getValue(roleToRemove)).remove(targetGroup);
        if (success) {
            this.mergeEntity(roleToRemove);
        }
        return success;
    }

    @Override
    public boolean createRole(String role) {
        try {
            if (this.roleClass == null) {
                throw new IdentityManagementException("Could not create role, roleClass not set");
            }
            if (this.roleExists(role)) {
                throw new IdentityManagementException("Could not create role, already exists");
            }
            Object instance = this.roleClass.newInstance();
            this.roleNameProperty.setValue(instance, role);
            this.persistEntity(instance);
            return true;
        }
        catch (Exception ex) {
            if (ex instanceof IdentityManagementException) {
                throw (IdentityManagementException)ex;
            }
            throw new IdentityManagementException("Could not create role", ex);
        }
    }

    @Override
    public boolean deleteRole(String role) {
        Object roleToDelete = this.lookupRole(role);
        if (roleToDelete == null) {
            throw new NoSuchRoleException("Could not delete role, role '" + role + "' does not exist");
        }
        this.removeEntity(roleToDelete);
        return true;
    }

    @Override
    public boolean enableUser(String name) {
        if (this.userEnabledProperty == null) {
            log.debug("Can not enable user, no @UserEnabled property configured in userClass " + this.userClass.getName());
            return false;
        }
        Object user = this.lookupUser(name);
        if (user == null) {
            throw new NoSuchUserException("Could not enable user, user '" + name + "' does not exist");
        }
        if (((Boolean)this.userEnabledProperty.getValue(user)).booleanValue()) {
            return false;
        }
        this.userEnabledProperty.setValue(user, true);
        this.mergeEntity(user);
        return true;
    }

    @Override
    public boolean disableUser(String name) {
        if (this.userEnabledProperty == null) {
            log.debug("Can not disable user, no @UserEnabled property configured in userClass " + this.userClass.getName());
            return false;
        }
        Object user = this.lookupUser(name);
        if (user == null) {
            throw new NoSuchUserException("Could not disable user, user '" + name + "' does not exist");
        }
        if (!((Boolean)this.userEnabledProperty.getValue(user)).booleanValue()) {
            return false;
        }
        this.userEnabledProperty.setValue(user, false);
        this.mergeEntity(user);
        return true;
    }

    @Override
    public boolean changePassword(String username, String password) {
        Object user = this.lookupUser(username);
        if (user == null) {
            throw new NoSuchUserException("Could not change password, user '" + username + "' does not exist");
        }
        this.userPasswordProperty.setValue(user, this.generatePasswordHash(password, this.getUserAccountSalt(user)));
        this.mergeEntity(user);
        return true;
    }

    @Override
    public boolean userExists(String name) {
        return this.lookupUser(name) != null;
    }

    @Override
    public boolean roleExists(String name) {
        return this.lookupRole(name) != null;
    }

    @Override
    public boolean isUserEnabled(String name) {
        Object user = this.lookupUser(name);
        return user != null && (this.userEnabledProperty == null || (Boolean)this.userEnabledProperty.getValue(user) == true);
    }

    @Override
    public List<String> getGrantedRoles(String name) {
        Object user = this.lookupUser(name);
        if (user == null) {
            throw new NoSuchUserException("No such user '" + name + "'");
        }
        ArrayList<String> roles = new ArrayList<String>();
        Collection userRoles = (Collection)this.userRolesProperty.getValue(user);
        if (userRoles != null) {
            for (Object role : userRoles) {
                roles.add((String)this.roleNameProperty.getValue(role));
            }
        }
        return roles;
    }

    @Override
    public List<String> getRoleGroups(String name) {
        Collection roleGroups;
        Object role = this.lookupRole(name);
        if (role == null) {
            throw new NoSuchUserException("No such role '" + name + "'");
        }
        ArrayList<String> groups = new ArrayList<String>();
        if (this.roleGroupsProperty != null && (roleGroups = (Collection)this.roleGroupsProperty.getValue(role)) != null) {
            for (Object group : roleGroups) {
                groups.add((String)this.roleNameProperty.getValue(group));
            }
        }
        return groups;
    }

    @Override
    public List<String> getImpliedRoles(String name) {
        Object user = this.lookupUser(name);
        if (user == null) {
            throw new NoSuchUserException("No such user '" + name + "'");
        }
        HashSet<String> roles = new HashSet<String>();
        Collection userRoles = (Collection)this.userRolesProperty.getValue(user);
        if (userRoles != null) {
            for (Object role : userRoles) {
                this.addRoleAndMemberships((String)this.roleNameProperty.getValue(role), roles);
            }
        }
        return new ArrayList<String>(roles);
    }

    private void addRoleAndMemberships(String role, Set<String> roles) {
        if (roles.add(role)) {
            Collection groups;
            Object instance = this.lookupRole(role);
            if (this.roleGroupsProperty != null && (groups = (Collection)this.roleGroupsProperty.getValue(instance)) != null) {
                for (Object group : groups) {
                    this.addRoleAndMemberships((String)this.roleNameProperty.getValue(group), roles);
                }
            }
        }
    }

    private String generatePasswordHash(String password, String salt) {
        String algorithm = this.userPasswordProperty.getAnnotation().hash();
        if (algorithm == null || "".equals(algorithm)) {
            if (salt == null || "".equals(salt)) {
                return PasswordHash.instance().generateHash(password);
            }
            return PasswordHash.instance().generateSaltedHash(password, salt);
        }
        if ("none".equals(algorithm)) {
            return password;
        }
        if (salt == null || "".equals(salt)) {
            return PasswordHash.instance().generateHash(password, algorithm);
        }
        return PasswordHash.instance().generateSaltedHash(password, salt, algorithm);
    }

    @Override
    public boolean authenticate(String username, String password) {
        Object user = this.lookupUser(username);
        if (user == null || this.userEnabledProperty != null && !((Boolean)this.userEnabledProperty.getValue(user)).booleanValue()) {
            return false;
        }
        String passwordHash = this.generatePasswordHash(password, this.getUserAccountSalt(user));
        boolean success = passwordHash.equals(this.userPasswordProperty.getValue(user));
        if (success && Events.exists()) {
            if (Contexts.isEventContextActive()) {
                Contexts.getEventContext().set(AUTHENTICATED_USER, user);
            }
            Events.instance().raiseEvent(EVENT_USER_AUTHENTICATED, user);
        }
        return success;
    }

    @Observer(value={"org.jboss.seam.security.postAuthenticate"})
    public void setUserAccountForSession() {
        if (Contexts.isEventContextActive() && Contexts.isSessionContextActive()) {
            Contexts.getSessionContext().set(AUTHENTICATED_USER, Contexts.getEventContext().get(AUTHENTICATED_USER));
        }
    }

    public Object lookupUser(String username) {
        try {
            Object user = this.lookupEntityManager().createQuery("select u from " + this.userClass.getName() + " u where " + this.userPrincipalProperty.getName() + " = :username").setParameter("username", (Object)username).getSingleResult();
            return user;
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public String getUserName(Object user) {
        return (String)this.userPrincipalProperty.getValue(user);
    }

    public String getRoleName(Object role) {
        return (String)this.roleNameProperty.getValue(role);
    }

    public boolean isRoleConditional(String role) {
        return this.roleConditionalProperty == null ? false : (Boolean)this.roleConditionalProperty.getValue(this.lookupRole(role));
    }

    public Object lookupRole(String role) {
        try {
            Object value = this.lookupEntityManager().createQuery("select r from " + this.roleClass.getName() + " r where " + this.roleNameProperty.getName() + " = :role").setParameter("role", (Object)role).getSingleResult();
            return value;
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<String> listUsers() {
        return this.lookupEntityManager().createQuery("select u." + this.userPrincipalProperty.getName() + " from " + this.userClass.getName() + " u").getResultList();
    }

    @Override
    public List<String> listUsers(String filter) {
        return this.lookupEntityManager().createQuery("select u." + this.userPrincipalProperty.getName() + " from " + this.userClass.getName() + " u where lower(" + this.userPrincipalProperty.getName() + ") like :username").setParameter("username", (Object)("%" + (filter != null ? filter.toLowerCase() : "") + "%")).getResultList();
    }

    @Override
    public List<String> listRoles() {
        return this.lookupEntityManager().createQuery("select r." + this.roleNameProperty.getName() + " from " + this.roleClass.getName() + " r").getResultList();
    }

    @Override
    public List<String> listGrantableRoles() {
        StringBuilder roleQuery = new StringBuilder();
        roleQuery.append("select r.");
        roleQuery.append(this.roleNameProperty.getName());
        roleQuery.append(" from ");
        roleQuery.append(this.roleClass.getName());
        roleQuery.append(" r");
        if (this.roleConditionalProperty != null) {
            roleQuery.append(" where r.");
            roleQuery.append(this.roleConditionalProperty.getName());
            roleQuery.append(" = false");
        }
        return this.lookupEntityManager().createQuery(roleQuery.toString()).getResultList();
    }

    protected void persistEntity(Object entity) {
        this.lookupEntityManager().persist(entity);
    }

    protected Object mergeEntity(Object entity) {
        return this.lookupEntityManager().merge(entity);
    }

    protected void removeEntity(Object entity) {
        this.lookupEntityManager().remove(entity);
    }

    public Class getUserClass() {
        return this.userClass;
    }

    public void setUserClass(Class userClass) {
        this.userClass = userClass;
    }

    public Class getRoleClass() {
        return this.roleClass;
    }

    public void setRoleClass(Class roleClass) {
        this.roleClass = roleClass;
    }

    private EntityManager lookupEntityManager() {
        return this.entityManager.getValue();
    }

    public Expressions.ValueExpression getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(Expressions.ValueExpression expression) {
        this.entityManager = expression;
    }
}

