/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.management.IdentityManagementException;
import org.jboss.seam.security.management.IdentityStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.security.ldapIdentityStore")
@Install(precedence=0, value=false)
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
public class LdapIdentityStore
implements IdentityStore,
Serializable {
    private static final String LDAP_BOOLEAN_TRUE = "TRUE";
    private static final String LDAP_BOOLEAN_FALSE = "FALSE";
    private static final LogProvider log = Logging.getLogProvider(LdapIdentityStore.class);
    protected IdentityStore.FeatureSet featureSet = new IdentityStore.FeatureSet();
    private String serverAddress = "localhost";
    private int serverPort = 389;
    private String userContextDN = "ou=Person,dc=acme,dc=com";
    private String userDNPrefix = "uid=";
    private String userDNSuffix = ",ou=Person,dc=acme,dc=com";
    private String roleContextDN = "ou=Role,dc=acme,dc=com";
    private String roleDNPrefix = "cn=";
    private String roleDNSuffix = ",ou=Roles,dc=acme,dc=com";
    private String bindDN = "cn=Manager,dc=acme,dc=com";
    private String bindCredentials = "secret";
    private String userRoleAttribute = "roles";
    private boolean roleAttributeIsDN = true;
    private String userNameAttribute = "uid";
    private String userPasswordAttribute = "userPassword";
    private String firstNameAttribute = null;
    private String lastNameAttribute = "sn";
    private String fullNameAttribute = "cn";
    private String enabledAttribute = null;
    private String roleNameAttribute = "cn";
    private String objectClassAttribute = "objectClass";
    private String[] roleObjectClasses = new String[]{"organizationalRole"};
    private String[] userObjectClasses = new String[]{"person", "uidObject"};
    private int searchScope = 2;
    private int searchTimeLimit = 10000;

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getUserContextDN() {
        return this.userContextDN;
    }

    public void setUserContextDN(String userContextDN) {
        this.userContextDN = userContextDN;
    }

    public String getRoleContextDN() {
        return this.roleContextDN;
    }

    public void setRoleContextDN(String roleContextDN) {
        this.roleContextDN = roleContextDN;
    }

    public String getUserDNPrefix() {
        return this.userDNPrefix;
    }

    public void setUserDNPrefix(String value) {
        this.userDNPrefix = value;
    }

    public String getUserDNSuffix() {
        return this.userDNSuffix;
    }

    public void setUserDNSuffix(String value) {
        this.userDNSuffix = value;
    }

    public String getRoleDNPrefix() {
        return this.roleDNPrefix;
    }

    public void setRoleDNPrefix(String value) {
        this.roleDNPrefix = value;
    }

    public String getRoleDNSuffix() {
        return this.roleDNSuffix;
    }

    public void setRoleDNSuffix(String value) {
        this.roleDNSuffix = value;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    public String getBindCredentials() {
        return this.bindCredentials;
    }

    public void setBindCredentials(String bindCredentials) {
        this.bindCredentials = bindCredentials;
    }

    public String getUserRoleAttribute() {
        return this.userRoleAttribute;
    }

    public void setUserRoleAttribute(String userRoleAttribute) {
        this.userRoleAttribute = userRoleAttribute;
    }

    public boolean getRoleAttributeIsDN() {
        return this.roleAttributeIsDN;
    }

    public void setRoleAttributeIsDN(boolean value) {
        this.roleAttributeIsDN = value;
    }

    public String getRoleNameAttribute() {
        return this.roleNameAttribute;
    }

    public void setRoleNameAttribute(String roleNameAttribute) {
        this.roleNameAttribute = roleNameAttribute;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    public String getUserPasswordAttribute() {
        return this.userPasswordAttribute;
    }

    public void setUserPasswordAttribute(String userPasswordAttribute) {
        this.userPasswordAttribute = userPasswordAttribute;
    }

    public String getFirstNameAttribute() {
        return this.firstNameAttribute;
    }

    public void setFirstNameAttribute(String firstNameAttribute) {
        this.firstNameAttribute = firstNameAttribute;
    }

    public String getLastNameAttribute() {
        return this.lastNameAttribute;
    }

    public void setLastNameAttribute(String lastNameAttribute) {
        this.lastNameAttribute = lastNameAttribute;
    }

    public String getFullNameAttribute() {
        return this.fullNameAttribute;
    }

    public void setFullNameAttribute(String fullNameAttribute) {
        this.fullNameAttribute = fullNameAttribute;
    }

    public String getEnabledAttribute() {
        return this.enabledAttribute;
    }

    public void setEnabledAttribute(String enabledAttribute) {
        this.enabledAttribute = enabledAttribute;
    }

    public String getObjectClassAttribute() {
        return this.objectClassAttribute;
    }

    public void setObjectClassAttribute(String objectClassAttribute) {
        this.objectClassAttribute = objectClassAttribute;
    }

    public String[] getRoleObjectClasses() {
        return this.roleObjectClasses;
    }

    public void setRoleObjectClass(String[] roleObjectClasses) {
        this.roleObjectClasses = roleObjectClasses;
    }

    public String[] getUserObjectClasses() {
        return this.userObjectClasses;
    }

    public void setUserObjectClasses(String[] userObjectClasses) {
        this.userObjectClasses = userObjectClasses;
    }

    public int getSearchTimeLimit() {
        return this.searchTimeLimit;
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchTimeLimit = searchTimeLimit;
    }

    public String getSearchScope() {
        switch (this.searchScope) {
            case 0: {
                return "OBJECT_SCOPE";
            }
            case 1: {
                return "ONELEVEL_SCOPE";
            }
            case 2: {
                return "SUBTREE_SCOPE";
            }
        }
        return "UNKNOWN";
    }

    public void setSearchScope(String value) {
        if ("OBJECT_SCOPE".equals(value)) {
            this.searchScope = 0;
        } else if ("ONELEVEL_SCOPE".equals(value)) {
            this.searchScope = 1;
        } else {
            this.searchScope = 2;
            if (!"SUBTREE_SCOPE".equals(value)) {
                log.warn("Invalid search scope specified (" + value + ") - search scope set to SUBTREE_SCOPE");
            }
        }
    }

    public Set<IdentityStore.Feature> getFeatures() {
        return this.featureSet.getFeatures();
    }

    public void setFeatures(Set<IdentityStore.Feature> features) {
        this.featureSet = new IdentityStore.FeatureSet(features);
    }

    @Override
    public boolean supportsFeature(IdentityStore.Feature feature) {
        return this.featureSet.supports(feature);
    }

    protected final InitialLdapContext initialiseContext() throws NamingException {
        return this.initialiseContext(this.getBindDN(), this.getBindCredentials());
    }

    protected final InitialLdapContext initialiseContext(String principal, String credentials) throws NamingException {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.setProperty("java.naming.security.authentication", "simple");
        String providerUrl = String.format("ldap://%s:%d", this.getServerAddress(), this.getServerPort());
        env.setProperty("java.naming.provider.url", providerUrl);
        env.setProperty("java.naming.security.principal", principal);
        env.setProperty("java.naming.security.credentials", credentials);
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        return ctx;
    }

    protected String getUserDN(String username) {
        return String.format("%s%s%s", this.getUserDNPrefix(), username, this.getUserDNSuffix());
    }

    protected String getRoleDN(String role) {
        return String.format("%s%s%s", this.getRoleDNPrefix(), role, this.getRoleDNSuffix());
    }

    @Override
    public boolean authenticate(String username, String password) {
        String securityPrincipal = this.getUserDN(username);
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext(securityPrincipal, password);
            if (this.getEnabledAttribute() != null) {
                Attributes attribs = ctx.getAttributes(securityPrincipal, new String[]{this.getEnabledAttribute()});
                Attribute enabledAttrib = attribs.get(this.getEnabledAttribute());
                if (enabledAttrib != null) {
                    for (int r = 0; r < enabledAttrib.size(); ++r) {
                        Object value = enabledAttrib.get(r);
                        if (!LDAP_BOOLEAN_TRUE.equals(value)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean attribs = true;
            return attribs;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Authentication error", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public boolean changePassword(String name, String password) {
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            BasicAttribute passwordAttrib = new BasicAttribute(this.getUserPasswordAttribute(), password);
            ModificationItem mod = new ModificationItem(2, passwordAttrib);
            ctx.modifyAttributes(this.getUserDN(name), new ModificationItem[]{mod});
            boolean bl = true;
            return bl;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Failed to change password", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public boolean createRole(String role) {
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            BasicAttributes roleAttribs = new BasicAttributes();
            BasicAttribute roleClass = new BasicAttribute(this.getObjectClassAttribute());
            for (String objectClass : this.getRoleObjectClasses()) {
                roleClass.add(objectClass);
            }
            roleAttribs.put(roleClass);
            roleAttribs.put(new BasicAttribute(this.getRoleNameAttribute(), role));
            String roleDN = this.getRoleDN(role);
            ctx.createSubcontext(roleDN, (Attributes)roleAttribs);
            boolean bl = true;
            return bl;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Failed to create role", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public boolean createUser(String username, String password, String firstname, String lastname) {
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            BasicAttributes userAttribs = new BasicAttributes();
            BasicAttribute userClass = new BasicAttribute(this.getObjectClassAttribute());
            for (String objectClass : this.getUserObjectClasses()) {
                userClass.add(objectClass);
            }
            userAttribs.put(userClass);
            userAttribs.put(new BasicAttribute(this.getUserNameAttribute(), username));
            userAttribs.put(new BasicAttribute(this.getUserPasswordAttribute(), password));
            if (this.getFirstNameAttribute() != null && firstname != null) {
                userAttribs.put(new BasicAttribute(this.getFirstNameAttribute(), firstname));
            }
            if (this.getLastNameAttribute() != null && lastname != null) {
                userAttribs.put(new BasicAttribute(this.getLastNameAttribute(), lastname));
            }
            if (this.getFullNameAttribute() != null && firstname != null && lastname != null) {
                userAttribs.put(new BasicAttribute(this.getFullNameAttribute(), firstname + " " + lastname));
            }
            if (this.getEnabledAttribute() != null) {
                userAttribs.put(new BasicAttribute(this.getEnabledAttribute(), LDAP_BOOLEAN_TRUE));
            }
            String userDN = String.format("%s=%s,%s", this.getUserNameAttribute(), username, this.getUserContextDN());
            ctx.createSubcontext(userDN, (Attributes)userAttribs);
            boolean bl = true;
            return bl;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Failed to create user", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public boolean createUser(String username, String password) {
        return this.createUser(username, password, null, null);
    }

    @Override
    public boolean deleteRole(String role) {
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String roleDN = String.format("%s=%s,%s", this.getRoleNameAttribute(), role, this.getRoleContextDN());
            ctx.destroySubcontext(roleDN);
            boolean bl = true;
            return bl;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Failed to delete role", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public boolean roleExists(String role) {
        boolean bl;
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            int searchScope = 2;
            int searchTimeLimit = 10000;
            String[] roleAttr = new String[]{this.getRoleNameAttribute()};
            SearchControls controls = new SearchControls();
            controls.setSearchScope(searchScope);
            controls.setReturningAttributes(roleAttr);
            controls.setTimeLimit(searchTimeLimit);
            String roleFilter = "(&(" + this.getObjectClassAttribute() + "={0})(" + this.getRoleNameAttribute() + "={1}))";
            Object[] filterArgs = new Object[]{this.getRoleObjectClasses(), role};
            NamingEnumeration<SearchResult> answer = ctx.search(this.getRoleContextDN(), roleFilter, filterArgs, controls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute user = attrs.get(this.getRoleNameAttribute());
                for (int i = 0; i < user.size(); ++i) {
                    Object value = user.get(i);
                    if (!role.equals(value)) continue;
                    boolean bl2 = true;
                    return bl2;
                }
            }
            answer.close();
            bl = false;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Error getting roles", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
        return bl;
    }

    @Override
    public boolean deleteUser(String name) {
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String userDN = this.getUserDN(name);
            ctx.destroySubcontext(userDN);
            boolean bl = true;
            return bl;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Failed to delete user", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public boolean isUserEnabled(String name) {
        if (this.getEnabledAttribute() == null) {
            return true;
        }
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String userDN = this.getUserDN(name);
            Attributes attribs = ctx.getAttributes(userDN, new String[]{this.getEnabledAttribute()});
            Attribute enabledAttrib = attribs.get(this.getEnabledAttribute());
            if (enabledAttrib != null) {
                for (int r = 0; r < enabledAttrib.size(); ++r) {
                    Object value = enabledAttrib.get(r);
                    if (!LDAP_BOOLEAN_TRUE.equals(value)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Failed to delete user", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public boolean disableUser(String name) {
        if (this.getEnabledAttribute() == null) {
            return false;
        }
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String userDN = this.getUserDN(name);
            BasicAttribute enabledAttrib = new BasicAttribute(this.getEnabledAttribute(), LDAP_BOOLEAN_FALSE);
            ModificationItem mod = new ModificationItem(2, enabledAttrib);
            ctx.modifyAttributes(userDN, new ModificationItem[]{mod});
            boolean bl = true;
            return bl;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Failed to disable user", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public boolean enableUser(String name) {
        if (this.getEnabledAttribute() == null) {
            return false;
        }
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String userDN = this.getUserDN(name);
            BasicAttribute enabledAttrib = new BasicAttribute(this.getEnabledAttribute(), LDAP_BOOLEAN_TRUE);
            ModificationItem mod = new ModificationItem(2, enabledAttrib);
            ctx.modifyAttributes(userDN, new ModificationItem[]{mod});
            boolean bl = true;
            return bl;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Failed to disable user", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public List<String> getGrantedRoles(String name) {
        HashSet<String> userRoles = new HashSet<String>();
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String userFilter = "(" + this.getUserNameAttribute() + "={0})";
            String[] roleAttr = new String[]{this.getUserRoleAttribute()};
            SearchControls controls = new SearchControls();
            controls.setSearchScope(this.searchScope);
            controls.setReturningAttributes(roleAttr);
            controls.setTimeLimit(this.getSearchTimeLimit());
            Object[] filterArgs = new Object[]{name};
            NamingEnumeration<SearchResult> answer = ctx.search(this.getUserContextDN(), userFilter, filterArgs, controls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute roles = attrs.get(this.getUserRoleAttribute());
                if (roles == null) continue;
                for (int r = 0; r < roles.size(); ++r) {
                    Object value = roles.get(r);
                    String roleName = null;
                    if (this.getRoleAttributeIsDN()) {
                        String roleDN = value.toString();
                        String[] returnAttribute = new String[]{this.getRoleNameAttribute()};
                        try {
                            Attributes result2 = ctx.getAttributes(roleDN, returnAttribute);
                            Attribute roles2 = result2.get(this.getRoleNameAttribute());
                            if (roles2 == null) continue;
                            for (int m = 0; m < roles2.size(); ++m) {
                                roleName = (String)roles2.get(m);
                                userRoles.add(roleName);
                            }
                            continue;
                        }
                        catch (NamingException ex) {
                            throw new IdentityManagementException("Failed to query roles", ex);
                        }
                    }
                    roleName = value.toString();
                    userRoles.add(roleName);
                }
            }
            answer.close();
            ArrayList<String> arrayList = new ArrayList<String>(userRoles);
            return arrayList;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Error getting roles", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public List<String> getImpliedRoles(String name) {
        return this.getGrantedRoles(name);
    }

    @Override
    public boolean grantRole(String name, String role) {
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String userDN = this.getUserDN(name);
            BasicAttribute roleAttrib = new BasicAttribute(this.getUserRoleAttribute(), this.getRoleAttributeIsDN() ? this.getRoleDN(role) : role);
            ModificationItem mod = new ModificationItem(1, roleAttrib);
            ctx.modifyAttributes(userDN, new ModificationItem[]{mod});
            boolean bl = true;
            return bl;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Failed to grant role", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public boolean revokeRole(String name, String role) {
        block14: {
            InitialLdapContext ctx = null;
            try {
                ctx = this.initialiseContext();
                String userDN = this.getUserDN(name);
                Attributes roleAttribs = ctx.getAttributes(userDN, new String[]{this.getUserRoleAttribute()});
                Attribute roleAttrib = roleAttribs.get(this.getUserRoleAttribute());
                if (roleAttrib == null) break block14;
                boolean modified = false;
                for (int i = roleAttrib.size() - 1; i >= 0; --i) {
                    if (this.getRoleAttributeIsDN()) {
                        Attributes attribs = ctx.getAttributes((String)roleAttrib.get(i), new String[]{this.getRoleNameAttribute()});
                        Attribute roleNameAttrib = attribs.get(this.getRoleNameAttribute());
                        for (int j = 0; j < roleNameAttrib.size(); ++j) {
                            if (!role.equals(roleNameAttrib.get(j))) continue;
                            modified = true;
                            roleAttrib.remove(i);
                        }
                        continue;
                    }
                    if (!role.equals(roleAttrib.get(i))) continue;
                    modified = true;
                    roleAttrib.remove(i);
                }
                if (modified) {
                    ModificationItem mod = new ModificationItem(2, roleAttrib);
                    ctx.modifyAttributes(userDN, new ModificationItem[]{mod});
                }
            }
            catch (NamingException ex) {
                throw new IdentityManagementException("Failed to grant role", ex);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException ex) {}
                }
            }
        }
        return false;
    }

    @Override
    public List<String> listRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String[] roleAttr = new String[]{this.getRoleNameAttribute()};
            SearchControls controls = new SearchControls();
            controls.setSearchScope(this.searchScope);
            controls.setReturningAttributes(roleAttr);
            controls.setTimeLimit(this.getSearchTimeLimit());
            StringBuilder roleFilter = new StringBuilder();
            Object[] filterArgs = new Object[this.getRoleObjectClasses().length];
            for (int i = 0; i < this.getRoleObjectClasses().length; ++i) {
                roleFilter.append("(");
                roleFilter.append(this.getObjectClassAttribute());
                roleFilter.append("={");
                roleFilter.append(i);
                roleFilter.append("})");
                filterArgs[i] = this.getRoleObjectClasses()[i];
            }
            NamingEnumeration<SearchResult> answer = ctx.search(this.getRoleContextDN(), roleFilter.toString(), filterArgs, controls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute user = attrs.get(this.getRoleNameAttribute());
                for (int i = 0; i < user.size(); ++i) {
                    Object value = user.get(i);
                    roles.add(value.toString());
                }
            }
            answer.close();
            ArrayList<String> arrayList = roles;
            return arrayList;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Error getting roles", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public List<String> listGrantableRoles() {
        return this.listRoles();
    }

    @Override
    public List<String> listUsers() {
        return this.listUsers(null);
    }

    @Override
    public List<String> listUsers(String filter) {
        ArrayList<String> users = new ArrayList<String>();
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String[] userAttr = new String[]{this.getUserNameAttribute()};
            SearchControls controls = new SearchControls();
            controls.setSearchScope(this.searchScope);
            controls.setReturningAttributes(userAttr);
            controls.setTimeLimit(this.getSearchTimeLimit());
            StringBuilder userFilter = new StringBuilder();
            Object[] filterArgs = new Object[this.getUserObjectClasses().length];
            for (int i = 0; i < this.getUserObjectClasses().length; ++i) {
                userFilter.append("(");
                userFilter.append(this.getObjectClassAttribute());
                userFilter.append("={");
                userFilter.append(i);
                userFilter.append("})");
                filterArgs[i] = this.getUserObjectClasses()[i];
            }
            NamingEnumeration<SearchResult> answer = ctx.search(this.getUserContextDN(), userFilter.toString(), filterArgs, controls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute user = attrs.get(this.getUserNameAttribute());
                for (int i = 0; i < user.size(); ++i) {
                    Object value = user.get(i);
                    if (filter != null) {
                        if (!value.toString().toLowerCase().contains(filter.toLowerCase())) continue;
                        users.add(value.toString());
                        continue;
                    }
                    users.add(value.toString());
                }
            }
            answer.close();
            ArrayList<String> arrayList = users;
            return arrayList;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Error getting users", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
    }

    @Override
    public boolean userExists(String name) {
        boolean bl;
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String[] userAttr = new String[]{this.getUserNameAttribute()};
            SearchControls controls = new SearchControls();
            controls.setSearchScope(this.searchScope);
            controls.setReturningAttributes(userAttr);
            controls.setTimeLimit(this.getSearchTimeLimit());
            StringBuilder userFilter = new StringBuilder();
            Object[] filterArgs = new Object[this.getUserObjectClasses().length];
            for (int i = 0; i < this.getUserObjectClasses().length; ++i) {
                userFilter.append("(");
                userFilter.append(this.getObjectClassAttribute());
                userFilter.append("={");
                userFilter.append(i);
                userFilter.append("})");
                filterArgs[i] = this.getUserObjectClasses()[i];
            }
            NamingEnumeration<SearchResult> answer = ctx.search(this.getUserContextDN(), userFilter.toString(), filterArgs, controls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute user = attrs.get(this.getUserNameAttribute());
                for (int i = 0; i < user.size(); ++i) {
                    Object value = user.get(i);
                    if (!name.equals(value)) continue;
                    answer.close();
                    boolean bl2 = true;
                    return bl2;
                }
            }
            answer.close();
            bl = false;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Error getting users", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {}
            }
        }
        return bl;
    }

    @Override
    public List<String> getRoleGroups(String name) {
        return null;
    }

    @Override
    public boolean addRoleToGroup(String role, String group) {
        return false;
    }

    @Override
    public boolean removeRoleFromGroup(String role, String group) {
        return false;
    }
}

