/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.security.management.IdentityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.security.management.roleAction")
@Scope(value=ScopeType.CONVERSATION)
public class RoleAction
implements Serializable {
    private String role;
    private List<String> groups;
    @In
    IdentityManager identityManager;

    @Begin
    public void createRole() {
        this.groups = new ArrayList<String>();
    }

    @Begin
    public void editRole(String role) {
        this.role = role;
        this.groups = this.identityManager.getRoleGroups(role);
    }

    public String save() {
        if (this.identityManager.roleExists(this.role)) {
            return this.saveExistingRole();
        }
        return this.saveNewRole();
    }

    private String saveNewRole() {
        boolean success = this.identityManager.createRole(this.role);
        if (success) {
            for (String r : this.groups) {
                this.identityManager.addRoleToGroup(this.role, r);
            }
            Conversation.instance().end();
        }
        return "success";
    }

    private String saveExistingRole() {
        List<String> grantedRoles = this.identityManager.getRoleGroups(this.role);
        if (grantedRoles != null) {
            for (String r : grantedRoles) {
                if (this.groups.contains(r)) continue;
                this.identityManager.removeRoleFromGroup(this.role, r);
            }
        }
        for (String r : this.groups) {
            if (grantedRoles != null && grantedRoles.contains(r)) continue;
            this.identityManager.addRoleToGroup(this.role, r);
        }
        Conversation.instance().end();
        return "success";
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }
}

