/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.servlet.ServletRequestSessionMap;
import org.jboss.seam.web.ServletContexts;

public abstract class ContextualHttpServletRequest {
    private static final LogProvider log = Logging.getLogProvider(ContextualHttpServletRequest.class);
    private final HttpServletRequest request;

    public ContextualHttpServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public abstract void process() throws Exception;

    public void run() throws ServletException, IOException {
        log.debug("beginning request");
        ServletLifecycle.beginRequest(this.request);
        ServletContexts.instance().setRequest(this.request);
        this.restoreConversationId();
        Manager.instance().restoreConversation();
        ServletLifecycle.resumeConversation(this.request);
        this.handleConversationPropagation();
        if (this.request.getSession(false) == null) {
            this.request.getSession(true);
        }
        try {
            this.process();
            Manager.instance().endRequest(new ServletRequestSessionMap(this.request));
            ServletLifecycle.endRequest(this.request);
        }
        catch (IOException ioe) {
            Lifecycle.endRequest();
            log.warn("ended request due to exception", ioe);
            throw ioe;
        }
        catch (ServletException se) {
            Lifecycle.endRequest();
            log.warn("ended request due to exception", se);
            throw se;
        }
        catch (Exception e) {
            Lifecycle.endRequest();
            log.warn("ended request due to exception", e);
            throw new ServletException((Throwable)e);
        }
        finally {
            log.debug("ended request");
        }
    }

    protected void handleConversationPropagation() {
        Manager.instance().handleConversationPropagation(this.request.getParameterMap());
    }

    protected void restoreConversationId() {
        ConversationPropagation.instance().restoreConversationId(this.request.getParameterMap());
    }
}

