/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.File;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.deployment.DotPageDotXmlDeploymentHandler;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class WarRootDeploymentStrategy
extends DeploymentStrategy {
    private static LogProvider log = Logging.getLogProvider(WarRootDeploymentStrategy.class);
    private ClassLoader classLoader;
    private File[] warRoot;
    public static final String HANDLERS_KEY = "org.jboss.seam.deployment.deploymentHandlers";
    public static final String NAME = "warRootDeploymentStrategy";

    public WarRootDeploymentStrategy(ClassLoader classLoader, File warRoot) {
        this.classLoader = classLoader;
        this.warRoot = new File[1];
        if (warRoot != null) {
            this.warRoot[0] = warRoot;
        } else {
            log.warn("Unable to discover war root, .page.xml files won't be found");
            this.warRoot = new File[0];
        }
        this.getDeploymentHandlers().put("org.jboss.seam.deployment.DotPageDotXmlDeploymentHandler", new DotPageDotXmlDeploymentHandler());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected String getDeploymentHandlersKey() {
        return HANDLERS_KEY;
    }

    public void handle(String name) {
        if (!name.startsWith("WEB-INF") && !name.startsWith("/WEB-INF")) {
            super.handle(name);
        }
    }

    public void scan() {
        this.getScanner().scanDirectories(this.warRoot);
    }
}

