/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.PerNestedConversation;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.AbstractMutable;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.navigation.Pages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.faces.redirect")
@BypassInterceptors
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@PerNestedConversation
public class Redirect
extends AbstractMutable
implements Serializable {
    private static final long serialVersionUID = 6947384474861235210L;
    private String viewId;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private boolean conversationPropagationEnabled = true;
    private boolean conversationBegun;

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.setDirty(this.viewId, viewId);
        this.viewId = viewId;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameter(String name, Object value) {
        Object old = this.parameters.put(name, value);
        this.setDirty(old, value);
    }

    public void captureCurrentRequest() {
        this.parameters.clear();
        FacesContext context = FacesContext.getCurrentInstance();
        this.parameters.putAll(context.getExternalContext().getRequestParameterMap());
        this.viewId = Pages.getViewId(context);
        this.setDirty();
    }

    public void captureCurrentView() {
        FacesContext context = FacesContext.getCurrentInstance();
        this.parameters = Pages.instance().getStringValuesFromPageContext(context);
        if (context.getExternalContext().getRequestParameterMap().containsKey("actionMethod")) {
            this.parameters.put("actionMethod", context.getExternalContext().getRequestParameterMap().get("actionMethod"));
        }
        this.viewId = Pages.getViewId(context);
        this.conversationBegun = Conversation.instance().begin(true, false);
        this.setDirty();
        Contexts.getConversationContext().flush();
    }

    public boolean isConversationPropagationEnabled() {
        return this.conversationPropagationEnabled;
    }

    public void setConversationPropagationEnabled(boolean conversationPropagationEnabled) {
        this.conversationPropagationEnabled = conversationPropagationEnabled;
    }

    public void execute() {
        FacesManager.instance().redirect(this.viewId, this.parameters, this.conversationPropagationEnabled);
    }

    public boolean returnToCapturedView() {
        if (this.viewId != null) {
            if (this.conversationBegun) {
                Conversation.instance().end();
            }
            this.execute();
            return true;
        }
        return false;
    }

    public static Redirect instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (Redirect)Component.getInstance(Redirect.class, ScopeType.CONVERSATION);
    }
}

