/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.navigation;

import java.util.Map;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.navigation.ConversationIdParameter;

public class NaturalConversationIdParameter
implements ConversationIdParameter {
    private String name;
    private String parameterName;
    private Expressions.ValueExpression vb;

    public NaturalConversationIdParameter(String name, String paramName, String expression) {
        this.name = name;
        this.parameterName = paramName;
        this.vb = expression != null ? Expressions.instance().createValueExpression(expression) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getInitialConversationId(Map parameters) {
        String id = this.getRequestConversationId(parameters);
        return id == null ? this.getConversationId() : id;
    }

    public String getRequestConversationId(Map parameters) {
        String value = ConversationPropagation.getRequestParameterValue(parameters, this.parameterName);
        if (value == null) {
            return null;
        }
        return this.name + ':' + value;
    }

    public String getConversationId() {
        return this.name + ':' + this.getParameterValue();
    }

    public String getParameterValue() {
        Object value = this.vb.getValue();
        if (value == null) {
            throw new IllegalStateException("conversation id evaluated to null: " + this.name);
        }
        return this.vb.getValue().toString();
    }

    public String getParameterValue(String value) {
        return value.startsWith(this.name + ":") ? value.substring(this.name.length() + 1) : value;
    }
}

