/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.init;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Namespace;
import org.jboss.seam.annotations.Role;
import org.jboss.seam.annotations.Roles;
import org.jboss.seam.bpm.Jbpm;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.deployment.ClassDescriptor;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.deployment.FileDescriptor;
import org.jboss.seam.deployment.HotDeploymentStrategy;
import org.jboss.seam.deployment.SeamDeploymentProperties;
import org.jboss.seam.deployment.StandardDeploymentStrategy;
import org.jboss.seam.deployment.TimestampCheckForwardingDeploymentStrategy;
import org.jboss.seam.deployment.WarRootDeploymentStrategy;
import org.jboss.seam.exception.Exceptions;
import org.jboss.seam.init.ComponentDescriptor;
import org.jboss.seam.init.DependencyManager;
import org.jboss.seam.init.FactoryDescriptor;
import org.jboss.seam.init.NamespaceDescriptor;
import org.jboss.seam.init.NamespacePackageResolver;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.util.Conversions;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Strings;
import org.jboss.seam.util.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Initialization {
    public static final String COMPONENT_NAMESPACE = "http://jboss.com/products/seam/components";
    public static final String COMPONENT_SUFFIX = ".component";
    public static final String DUPLICATE_JARS_PATTERNS = "org.jboss.seam.init.duplicateJarsPatterns";
    private static final LogProvider log = Logging.getLogProvider(Initialization.class);
    private ServletContext servletContext;
    private Map<String, Conversions.PropertyValue> properties = new HashMap<String, Conversions.PropertyValue>();
    private Map<String, Set<ComponentDescriptor>> componentDescriptors = new HashMap<String, Set<ComponentDescriptor>>();
    private List<FactoryDescriptor> factoryDescriptors = new ArrayList<FactoryDescriptor>();
    private Set<Class> installedComponentClasses = new HashSet<Class>();
    private Map<String, NamespaceDescriptor> namespaceMap = new HashMap<String, NamespaceDescriptor>();
    private NamespacePackageResolver namespacePackageResolver = new NamespacePackageResolver();
    private Map<String, EventListenerDescriptor> eventListenerDescriptors = new HashMap<String, EventListenerDescriptor>();
    private Collection<String> globalImports = new ArrayList<String>();
    private StandardDeploymentStrategy standardDeploymentStrategy;
    private HotDeploymentStrategy hotDeploymentStrategy;
    private WarRootDeploymentStrategy warRootDeploymentStrategy;
    private File warClassesDirectory;
    private File warLibDirectory;
    private File hotDeployDirectory;
    private File warRoot;
    private Set<String> nonPropertyAttributes = new HashSet<String>();

    public Initialization(ServletContext servletContext) {
        this.nonPropertyAttributes.add("name");
        this.nonPropertyAttributes.add("installed");
        this.nonPropertyAttributes.add("scope");
        this.nonPropertyAttributes.add("startup");
        this.nonPropertyAttributes.add("startupDepends");
        this.nonPropertyAttributes.add("class");
        this.nonPropertyAttributes.add("jndi-name");
        this.nonPropertyAttributes.add("precedence");
        this.nonPropertyAttributes.add("auto-create");
        this.servletContext = servletContext;
        this.warRoot = Resources.getRealFile(servletContext, "/");
        this.warClassesDirectory = Resources.getRealFile(servletContext, "/WEB-INF/classes");
        this.warLibDirectory = Resources.getRealFile(servletContext, "/WEB-INF/lib");
        this.hotDeployDirectory = Resources.getRealFile(servletContext, "/WEB-INF/dev");
    }

    public Initialization create() {
        this.standardDeploymentStrategy = new StandardDeploymentStrategy(Thread.currentThread().getContextClassLoader());
        this.standardDeploymentStrategy.scan();
        this.addNamespaces();
        this.initComponentsFromXmlDocument("/WEB-INF/components.xml");
        this.initComponentsFromXmlDocument("/WEB-INF/events.xml");
        this.initComponentsFromXmlDocuments();
        this.initPropertiesFromServletContext();
        this.initPropertiesFromResource();
        this.initJndiProperties();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initComponentsFromXmlDocuments() {
        Enumeration<URL> resources;
        try {
            resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/components.xml");
        }
        catch (IOException ioe) {
            throw new RuntimeException("error scanning META-INF/components.xml files", ioe);
        }
        ArrayList seenDocuments = new ArrayList();
        Properties replacements = this.getReplacements();
        HashSet<Pattern> duplicateJarPatterns = new HashSet<Pattern>();
        for (String duplicateJarRegex : new HashSet<String>(new SeamDeploymentProperties(Thread.currentThread().getContextClassLoader()).getPropertyValues(DUPLICATE_JARS_PATTERNS))) {
            duplicateJarPatterns.add(Pattern.compile(duplicateJarRegex));
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            boolean skip = false;
            String path = url.getPath();
            String prefixPattern = "^(\\S*/)([\\S^/]*.jar)(\\S*)$";
            Pattern pattern = Pattern.compile(prefixPattern);
            Matcher matcher = pattern.matcher(path);
            if (matcher.matches()) {
                String jarName = matcher.group(2);
                String fileName = matcher.group(3);
                HashSet<String> documentNames = new HashSet<String>();
                for (Pattern duplicateJarPattern : duplicateJarPatterns) {
                    Matcher duplicateMatcher = duplicateJarPattern.matcher(jarName);
                    if (duplicateMatcher.matches()) {
                        jarName = duplicateMatcher.group(1);
                    }
                    documentNames.add(jarName + fileName);
                }
                for (String documentName : documentNames) {
                    if (!seenDocuments.contains(documentName)) continue;
                    skip = true;
                }
                seenDocuments.addAll(documentNames);
            }
            if (!skip) {
                try {
                    InputStream stream = url.openStream();
                    log.debug("reading " + url);
                    try {
                        this.installComponentsFromXmlElements(XML.getRootElement(stream), replacements);
                        continue;
                    }
                    finally {
                        Resources.closeStream(stream);
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("error while reading " + url, e);
                }
            }
            log.trace("skipping read of duplicate components.xml " + url);
        }
    }

    private void initComponentsFromXmlDocument(String resource) {
        InputStream stream = Resources.getResourceAsStream(resource, this.servletContext);
        if (stream != null) {
            log.info("reading " + resource);
            try {
                this.installComponentsFromXmlElements(XML.getRootElement(stream), this.getReplacements());
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading /WEB-INF/components.xml", e);
            }
            finally {
                Resources.closeStream(stream);
            }
        }
    }

    private Properties getReplacements() {
        Properties properties;
        InputStream replaceStream = null;
        try {
            Properties replacements = new Properties();
            replaceStream = Resources.getResourceAsStream("/components.properties", this.servletContext);
            if (replaceStream != null) {
                replacements.load(replaceStream);
            }
            properties = replacements;
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException("error reading components.properties", ioe);
            }
            catch (Throwable throwable) {
                Resources.closeStream(replaceStream);
                throw throwable;
            }
        }
        Resources.closeStream(replaceStream);
        return properties;
    }

    private List<Element> elements(Element rootElement, String name) {
        return rootElement.elements(name);
    }

    private void installComponentsFromXmlElements(Element rootElement, Properties replacements) throws DocumentException, ClassNotFoundException {
        for (Element importElement : this.elements(rootElement, "import")) {
            this.globalImports.add(importElement.getTextTrim());
        }
        for (Element component : this.elements(rootElement, "component")) {
            this.installComponentFromXmlElement(component, component.attributeValue("name"), component.attributeValue("class"), replacements);
        }
        for (Element factory : this.elements(rootElement, "factory")) {
            this.installFactoryFromXmlElement(factory);
        }
        for (Element event : this.elements(rootElement, "event")) {
            this.installEventListenerFromXmlElement(event);
        }
        for (Element elem : rootElement.elements()) {
            String ns = elem.getNamespace().getURI();
            NamespaceDescriptor nsInfo = this.resolveNamespace(ns);
            if (nsInfo == null) {
                if (ns.equals(COMPONENT_NAMESPACE)) continue;
                log.warn("namespace declared in components.xml does not resolve to a package: " + ns);
                continue;
            }
            String name = elem.attributeValue("name");
            String elemName = Initialization.toCamelCase(elem.getName(), true);
            String className = elem.attributeValue("class");
            if (className == null) {
                for (String packageName : nsInfo.getPackageNames()) {
                    try {
                        className = packageName + '.' + elemName;
                        Reflections.classForName(className);
                        break;
                    }
                    catch (ClassNotFoundException ex) {
                        className = null;
                    }
                }
            }
            try {
                Install install;
                Class clazz = Reflections.classForName(className);
                Name nameAnnotation = clazz.getAnnotation(Name.class);
                if (name == null && nameAnnotation != null) {
                    name = nameAnnotation.value();
                }
                if (nameAnnotation != null && nameAnnotation.value().equals(name) && ((install = clazz.getAnnotation(Install.class)) == null || install.value())) {
                    className = null;
                }
            }
            catch (ClassNotFoundException cnfe) {
                className = null;
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading element " + elemName + " with component name " + name + " and component class " + className);
            }
            if (name == null) {
                String prefix = nsInfo.getComponentPrefix();
                String componentName = Initialization.toCamelCase(elem.getName(), false);
                name = Strings.isEmpty(prefix) ? componentName : prefix + '.' + componentName;
            }
            this.installComponentFromXmlElement(elem, name, className, replacements);
        }
    }

    private NamespaceDescriptor resolveNamespace(String namespace) {
        if (Strings.isEmpty(namespace) || namespace.equals(COMPONENT_NAMESPACE)) {
            return null;
        }
        NamespaceDescriptor descriptor = this.namespaceMap.get(namespace);
        if (descriptor == null) {
            try {
                String packageName = this.namespacePackageResolver.resolve(namespace);
                descriptor = new NamespaceDescriptor(namespace, packageName);
                this.namespaceMap.put(namespace, descriptor);
            }
            catch (Exception e) {
                log.warn("Could not determine java package for namespace: " + namespace, e);
            }
        }
        return descriptor;
    }

    private void installEventListenerFromXmlElement(Element event) {
        String type = event.attributeValue("type");
        if (type == null) {
            throw new IllegalArgumentException("must specify type for <event/> declaration");
        }
        EventListenerDescriptor eventListener = this.eventListenerDescriptors.get(type);
        if (eventListener == null) {
            eventListener = new EventListenerDescriptor(type);
            this.eventListenerDescriptors.put(type, eventListener);
        }
        List actions = event.elements("action");
        for (Element action : actions) {
            String execute = action.attributeValue("execute");
            if (execute == null) {
                String actionExpression = action.attributeValue("expression");
                if (actionExpression != null) {
                    log.warn("<action expression=\"" + actionExpression + "\" /> has been deprecated, use <action execute=\"" + actionExpression + "\" /> instead");
                    execute = actionExpression;
                } else {
                    throw new IllegalArgumentException("must specify execute for <action/> declaration");
                }
            }
            eventListener.getListenerMethodBindings().add(execute);
        }
    }

    private void installFactoryFromXmlElement(Element factory) {
        String scopeName = factory.attributeValue("scope");
        String name = factory.attributeValue("name");
        if (name == null) {
            throw new IllegalArgumentException("must specify name in <factory/> declaration");
        }
        String method = factory.attributeValue("method");
        String value = factory.attributeValue("value");
        if (method == null && value == null) {
            throw new IllegalArgumentException("must specify either method or value in <factory/> declaration for variable: " + name);
        }
        ScopeType scope = scopeName == null ? ScopeType.UNSPECIFIED : ScopeType.valueOf(scopeName.toUpperCase());
        boolean autoCreate = Boolean.parseBoolean(factory.attributeValue("auto-create"));
        this.factoryDescriptors.add(new FactoryDescriptor(name, scope, method, value, autoCreate));
    }

    private String replace(String value, Properties replacements) {
        if (value.startsWith("@")) {
            value = replacements.getProperty(value.substring(1, value.length() - 1));
        }
        return value;
    }

    private void installComponentFromXmlElement(Element component, String name, String className, Properties replacements) throws ClassNotFoundException {
        String qualifiedPropName;
        String[] startupDepends;
        String installText = component.attributeValue("installed");
        boolean installed = false;
        if (installText == null || Boolean.parseBoolean(this.replace(installText, replacements))) {
            installed = true;
        }
        String scopeName = component.attributeValue("scope");
        String jndiName = component.attributeValue("jndi-name");
        String precedenceString = component.attributeValue("precedence");
        int precedence = precedenceString == null ? 20 : Integer.valueOf(precedenceString);
        ScopeType scope = scopeName == null ? null : ScopeType.valueOf(scopeName.toUpperCase());
        String autocreateAttribute = component.attributeValue("auto-create");
        Boolean autoCreate = autocreateAttribute == null ? null : Boolean.valueOf(Boolean.parseBoolean(autocreateAttribute));
        String startupAttribute = component.attributeValue("startup");
        Boolean startup = startupAttribute == null ? null : Boolean.valueOf(Boolean.parseBoolean(startupAttribute));
        String startupDependsAttribute = component.attributeValue("startupDepends");
        String[] stringArray = startupDepends = startupDependsAttribute == null ? new String[]{} : startupDependsAttribute.split(" ");
        if (className != null) {
            Class<?> clazz = this.getClassUsingImports(className);
            if (name == null) {
                if (!clazz.isAnnotationPresent(Name.class)) {
                    throw new IllegalArgumentException("Component class must have @Name annotation or name must be specified in components.xml: " + clazz.getName());
                }
                name = clazz.getAnnotation(Name.class).value();
            }
            ComponentDescriptor descriptor = new ComponentDescriptor(name, clazz, scope, autoCreate, startup, startupDepends, jndiName, installed, precedence);
            this.addComponentDescriptor(descriptor);
            this.installedComponentClasses.add(clazz);
        } else if (name == null) {
            throw new IllegalArgumentException("must specify either class or name in <component/> declaration");
        }
        for (Element prop : component.elements()) {
            String propName = prop.attributeValue("name");
            if (propName == null) {
                propName = prop.getQName().getName();
            }
            qualifiedPropName = name + '.' + Initialization.toCamelCase(propName, false);
            this.properties.put(qualifiedPropName, this.getPropertyValue(prop, qualifiedPropName, replacements));
        }
        for (Element prop : component.attributes()) {
            String attributeName = prop.getName();
            if (!this.isProperty(prop.getNamespaceURI(), attributeName)) continue;
            qualifiedPropName = name + '.' + Initialization.toCamelCase(prop.getQName().getName(), false);
            Conversions.PropertyValue propValue = null;
            try {
                propValue = this.getPropertyValue((Attribute)prop, replacements);
                this.properties.put(qualifiedPropName, propValue);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(String.format("Exception setting property %s on component %s.  Expression %s evaluated to %s.", qualifiedPropName, name, prop.getValue(), propValue), ex);
            }
        }
    }

    private boolean isProperty(String namespaceURI, String attributeName) {
        return (namespaceURI == null || namespaceURI.length() == 0) && !this.nonPropertyAttributes.contains(attributeName);
    }

    private Class<?> getClassUsingImports(String className) throws ClassNotFoundException {
        Class clazz = null;
        clazz = Reflections.classForName(className);
        return clazz;
    }

    private void addComponentDescriptor(ComponentDescriptor descriptor) {
        String name = descriptor.getName();
        Set<ComponentDescriptor> set = this.componentDescriptors.get(name);
        if (set == null) {
            set = new TreeSet<ComponentDescriptor>(new ComponentDescriptor.PrecedenceComparator());
            this.componentDescriptors.put(name, set);
        }
        if (!set.isEmpty()) {
            log.info("two components with same name, higher precedence wins: " + name);
        }
        if (!set.add(descriptor)) {
            ComponentDescriptor other = null;
            for (ComponentDescriptor d : set) {
                if (descriptor.compareTo(d) != 0) continue;
                other = d;
                break;
            }
            throw new IllegalStateException("Two components with the same name and precedence - component name: " + name + ", component classes: " + descriptor.getComponentClass().getName() + ", " + (other != null ? other.getComponentClass().getName() : "<unknown>"));
        }
    }

    private Conversions.PropertyValue getPropertyValue(Attribute prop, Properties replacements) {
        return new Conversions.FlatPropertyValue(this.trimmedText(prop, replacements));
    }

    private Conversions.PropertyValue getPropertyValue(Element prop, String propName, Properties replacements) {
        String typeName = prop.attributeValue("type");
        Class<?> type = null;
        try {
            if (typeName != null) {
                type = Class.forName(typeName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find class " + typeName + " when setting up property " + propName);
        }
        List keyElements = prop.elements("key");
        List valueElements = prop.elements("value");
        if (valueElements.isEmpty() && keyElements.isEmpty()) {
            return new Conversions.FlatPropertyValue(this.trimmedText(prop, propName, replacements));
        }
        if (keyElements.isEmpty()) {
            int len = valueElements.size();
            String[] values = new String[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.trimmedText((Element)valueElements.get(i), propName, replacements);
            }
            return new Conversions.MultiPropertyValue(values, type);
        }
        if (valueElements.size() != keyElements.size()) {
            throw new IllegalArgumentException("value elements must match key elements: " + propName);
        }
        LinkedHashMap<String, String> keyedValues = new LinkedHashMap<String, String>();
        for (int i = 0; i < keyElements.size(); ++i) {
            String key = this.trimmedText((Element)keyElements.get(i), propName, replacements);
            String value = this.trimmedText((Element)valueElements.get(i), propName, replacements);
            keyedValues.put(key, value);
        }
        return new Conversions.AssociativePropertyValue(keyedValues, type);
    }

    private String trimmedText(Element element, String propName, Properties replacements) {
        String text = element.getTextTrim();
        if (text == null) {
            throw new IllegalArgumentException("property value must be specified in element body: " + propName);
        }
        return this.replace(text, replacements);
    }

    private String trimmedText(Attribute attribute, Properties replacements) {
        return this.replace(attribute.getText(), replacements);
    }

    public Initialization setProperty(String name, Conversions.PropertyValue value) {
        this.properties.put(name, value);
        return this;
    }

    public Initialization init() {
        log.info("initializing Seam");
        if (this.standardDeploymentStrategy == null) {
            throw new IllegalStateException("No deployment strategy!");
        }
        ServletLifecycle.beginInitialization();
        Contexts.getApplicationContext().set("org.jboss.seam.properties", this.properties);
        this.addComponent(new ComponentDescriptor(Init.class), Contexts.getApplicationContext());
        Init init = (Init)Component.getInstance(Init.class, ScopeType.APPLICATION);
        Contexts.getEventContext().set("deploymentStrategy", this.standardDeploymentStrategy);
        this.scanForComponents();
        ComponentDescriptor desc = this.findDescriptor(Jbpm.class);
        if (desc != null && desc.isInstalled()) {
            init.setJbpmInstalled(true);
        }
        init.checkDefaultInterceptors();
        init.setTimestamp(System.currentTimeMillis());
        this.addSpecialComponents(init);
        this.warRootDeploymentStrategy = new WarRootDeploymentStrategy(Thread.currentThread().getContextClassLoader(), this.warRoot, new File[]{this.warClassesDirectory, this.warLibDirectory, this.hotDeployDirectory});
        Contexts.getEventContext().set("warRootDeploymentStrategy", this.warRootDeploymentStrategy);
        this.warRootDeploymentStrategy.scan();
        init.setWarTimestamp(System.currentTimeMillis());
        this.hotDeploymentStrategy = this.createHotDeployment(Thread.currentThread().getContextClassLoader(), this.isHotDeployEnabled(init));
        Contexts.getEventContext().set("hotDeploymentStrategy", this.hotDeploymentStrategy);
        init.setHotDeployPaths(this.hotDeploymentStrategy.getHotDeploymentPaths());
        if (this.hotDeploymentStrategy.available()) {
            this.hotDeploymentStrategy.scan();
            this.installHotDeployableComponents();
        }
        this.installComponents(init);
        for (String globalImport : this.globalImports) {
            init.importNamespace(globalImport);
        }
        ServletLifecycle.endInitialization();
        log.info("done initializing Seam");
        return this;
    }

    public void redeploy(HttpServletRequest request) throws InterruptedException {
        this.redeploy(request, (Init)ServletLifecycle.getServletContext().getAttribute(Seam.getComponentName(Init.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeploy(HttpServletRequest request, Init init) throws InterruptedException {
        if (!this.isHotDeployEnabled(init)) {
            return;
        }
        ReentrantLock lock = new ReentrantLock();
        if (lock.tryLock(500L, TimeUnit.MILLISECONDS)) {
            try {
                WarRootDeploymentStrategy warRootDeploymentStrategy;
                this.hotDeploymentStrategy = this.createHotDeployment(Thread.currentThread().getContextClassLoader(), this.isHotDeployEnabled(init));
                boolean changed = new TimestampCheckForwardingDeploymentStrategy(){

                    protected DeploymentStrategy delegate() {
                        return Initialization.this.hotDeploymentStrategy;
                    }
                }.changedSince(init.getTimestamp());
                if (this.hotDeploymentStrategy.available() && changed) {
                    ServletLifecycle.beginReinitialization(request);
                    Contexts.getEventContext().set("hotDeploymentStrategy", this.hotDeploymentStrategy);
                    this.hotDeploymentStrategy.scan();
                    if (this.hotDeploymentStrategy.getTimestamp() > init.getTimestamp()) {
                        log.info("redeploying components");
                        Seam.clearComponentNameCache();
                        for (String name : init.getHotDeployableComponents()) {
                            Component component = Component.forName(name);
                            if (component != null) {
                                ScopeType scope = component.getScope();
                                if (scope != ScopeType.STATELESS && scope.isContextActive()) {
                                    scope.getContext().remove(name);
                                }
                                init.removeObserverMethods(component);
                            }
                            Contexts.getApplicationContext().remove(name + COMPONENT_SUFFIX);
                        }
                        init.getHotDeployableComponents().clear();
                        this.installHotDeployableComponents();
                        this.installComponents(init);
                        log.info("done redeploying components");
                    }
                    init.setTimestamp(System.currentTimeMillis());
                    ServletLifecycle.endReinitialization();
                }
                if (changed = new TimestampCheckForwardingDeploymentStrategy(warRootDeploymentStrategy = new WarRootDeploymentStrategy(Thread.currentThread().getContextClassLoader(), this.warRoot, new File[]{this.warClassesDirectory, this.warLibDirectory, this.hotDeployDirectory})){
                    final /* synthetic */ WarRootDeploymentStrategy val$warRootDeploymentStrategy;
                    {
                        this.val$warRootDeploymentStrategy = warRootDeploymentStrategy;
                    }

                    protected DeploymentStrategy delegate() {
                        return this.val$warRootDeploymentStrategy;
                    }
                }.changedSince(init.getWarTimestamp())) {
                    warRootDeploymentStrategy.scan();
                    if (warRootDeploymentStrategy.getTimestamp() > init.getWarTimestamp()) {
                        log.info("redeploying page descriptors...");
                        Pages pages = (Pages)ServletLifecycle.getServletContext().getAttribute(Seam.getComponentName(Pages.class));
                        if (pages != null) {
                            Lifecycle.setupApplication();
                            pages.initialize(warRootDeploymentStrategy.getDotPageDotXmlFileNames());
                            Lifecycle.cleanupApplication();
                        }
                        ServletLifecycle.getServletContext().removeAttribute(Seam.getComponentName(Exceptions.class));
                        init.setWarTimestamp(warRootDeploymentStrategy.getTimestamp());
                        log.info("done redeploying page descriptors");
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void installHotDeployableComponents() {
        for (ClassDescriptor classDescriptor : this.hotDeploymentStrategy.getScannedComponentClasses()) {
            Class<?> scannedClass = classDescriptor.getClazz();
            this.installScannedComponentAndRoles(scannedClass);
        }
    }

    private HotDeploymentStrategy createHotDeployment(ClassLoader classLoader, boolean hotDeployEnabled) {
        if (this.isGroovyPresent()) {
            log.debug("Using Java + Groovy hot deploy");
            return HotDeploymentStrategy.createInstance("org.jboss.seam.deployment.GroovyHotDeploymentStrategy", classLoader, this.hotDeployDirectory, hotDeployEnabled);
        }
        log.debug("Using Java hot deploy");
        return new HotDeploymentStrategy(classLoader, this.hotDeployDirectory, hotDeployEnabled);
    }

    private boolean isHotDeployEnabled(Init init) {
        return init.isDebug();
    }

    private boolean isGroovyPresent() {
        try {
            Reflections.classForName("groovy.lang.GroovyObject");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void scanForComponents() {
        for (ClassDescriptor classDescriptor : this.standardDeploymentStrategy.getAnnotatedComponents()) {
            Class<?> scannedClass = classDescriptor.getClazz();
            this.installScannedComponentAndRoles(scannedClass);
        }
        for (FileDescriptor fileDescriptor : this.standardDeploymentStrategy.getXmlComponents()) {
            this.installComponentsFromDescriptor(fileDescriptor, this.standardDeploymentStrategy.getClassLoader());
        }
    }

    private static String classFilenameFromDescriptor(String descriptor) {
        int pos = descriptor.lastIndexOf(".component.xml");
        if (pos == -1) {
            return null;
        }
        return descriptor.substring(0, pos).replace('/', '.').replace('\\', '.');
    }

    private void installComponentsFromDescriptor(FileDescriptor fileDescriptor, ClassLoader loader) {
        InputStream stream = null;
        try {
            stream = fileDescriptor.getUrl().openStream();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (stream != null) {
            try {
                Properties replacements = this.getReplacements();
                Element root = XML.getRootElement(stream);
                if (root.getName().equals("components")) {
                    this.installComponentsFromXmlElements(root, replacements);
                } else {
                    this.installComponentFromXmlElement(root, root.attributeValue("name"), Initialization.classFilenameFromDescriptor(fileDescriptor.getName()), replacements);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading " + fileDescriptor.getName(), e);
            }
            finally {
                Resources.closeStream(stream);
            }
        }
    }

    private void installScannedComponentAndRoles(Class<?> scannedClass) {
        try {
            if (scannedClass.isAnnotationPresent(Name.class)) {
                this.addComponentDescriptor(new ComponentDescriptor(scannedClass));
            }
            if (scannedClass.isAnnotationPresent(Role.class)) {
                this.installRole(scannedClass, scannedClass.getAnnotation(Role.class));
            }
            if (scannedClass.isAnnotationPresent(Roles.class)) {
                Role[] roles;
                for (Role role : roles = scannedClass.getAnnotation(Roles.class).value()) {
                    this.installRole(scannedClass, role);
                }
            }
        }
        catch (TypeNotPresentException e) {
            log.info("Failed to install " + scannedClass.getName() + ": " + e.getMessage());
        }
    }

    private void installRole(Class<?> scannedClass, Role role) {
        ScopeType scope = Seam.getComponentRoleScope(scannedClass, role);
        this.addComponentDescriptor(new ComponentDescriptor(role.name(), scannedClass, scope));
    }

    private void addNamespace(Package pkg) {
        Namespace ns;
        if (pkg != null && (ns = pkg.getAnnotation(Namespace.class)) != null) {
            log.info("Namespace: " + ns.value() + ", package: " + pkg.getName() + ", prefix: " + ns.prefix());
            NamespaceDescriptor descriptor = this.namespaceMap.get(ns.value());
            if (descriptor != null) {
                descriptor.addPackageName(pkg.getName());
            } else {
                this.namespaceMap.put(ns.value(), new NamespaceDescriptor(ns, pkg));
            }
        }
    }

    private void addNamespaces() {
        for (Package pkg : this.standardDeploymentStrategy.getScannedNamespaces()) {
            this.addNamespace(pkg);
        }
    }

    private void initPropertiesFromServletContext() {
        Enumeration params = this.servletContext.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            this.properties.put(name, new Conversions.FlatPropertyValue(this.servletContext.getInitParameter(name)));
        }
    }

    private void initPropertiesFromResource() {
        Properties props = this.loadFromResource("/seam.properties");
        for (Map.Entry<Object, Object> me : props.entrySet()) {
            this.properties.put((String)me.getKey(), new Conversions.FlatPropertyValue((String)me.getValue()));
        }
    }

    private void initJndiProperties() {
        Properties jndiProperties = new Properties();
        jndiProperties.putAll((Map<?, ?>)this.loadFromResource("/jndi.properties"));
        jndiProperties.putAll((Map<?, ?>)this.loadFromResource("/seam-jndi.properties"));
        Naming.setInitialContextProperties(jndiProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadFromResource(String resource) {
        Properties props = new Properties();
        InputStream stream = Resources.getResourceAsStream(resource, this.servletContext);
        if (stream != null) {
            try {
                log.info("reading properties from: " + resource);
                try {
                    props.load(stream);
                }
                catch (IOException ioe) {
                    log.error("could not read " + resource, ioe);
                }
            }
            finally {
                Resources.closeStream(stream);
            }
        } else {
            log.debug("not found: " + resource);
        }
        return props;
    }

    protected ComponentDescriptor findDescriptor(Class<?> componentClass) {
        for (Set<ComponentDescriptor> components : this.componentDescriptors.values()) {
            for (ComponentDescriptor component : components) {
                if (!component.getComponentClass().equals(componentClass)) continue;
                return component;
            }
        }
        return null;
    }

    private void addSpecialComponents(Init init) {
    }

    private void installComponents(Init init) {
        log.info("Installing components...");
        Context context = Contexts.getApplicationContext();
        DependencyManager manager = new DependencyManager(this.componentDescriptors);
        Set<ComponentDescriptor> installable = manager.installedSet();
        for (ComponentDescriptor componentDescriptor : installable) {
            String compName = componentDescriptor.getName() + COMPONENT_SUFFIX;
            if (context.isSet(compName)) continue;
            this.addComponent(componentDescriptor, context);
            if (componentDescriptor.isAutoCreate()) {
                init.addAutocreateVariable(componentDescriptor.getName());
            }
            if (componentDescriptor.isFilter()) {
                init.addInstalledFilter(componentDescriptor.getName());
            }
            if (componentDescriptor.isResourceProvider()) {
                if (!componentDescriptor.getScope().equals((Object)ScopeType.APPLICATION)) {
                    throw new RuntimeException("Resource providers must be application-scoped components");
                }
                init.addResourceProvider(componentDescriptor.getName());
            }
            if (!componentDescriptor.isPermissionResolver()) continue;
            init.addPermissionResolver(componentDescriptor.getName());
        }
        for (FactoryDescriptor factoryDescriptor : this.factoryDescriptors) {
            if (factoryDescriptor.isValueBinding()) {
                init.addFactoryValueExpression(factoryDescriptor.getName(), factoryDescriptor.getValue(), factoryDescriptor.getScope());
            } else {
                init.addFactoryMethodExpression(factoryDescriptor.getName(), factoryDescriptor.getMethod(), factoryDescriptor.getScope());
            }
            if (!factoryDescriptor.isAutoCreate()) continue;
            init.addAutocreateVariable(factoryDescriptor.getName());
        }
        for (EventListenerDescriptor listenerDescriptor : this.eventListenerDescriptors.values()) {
            for (String expression : listenerDescriptor.getListenerMethodBindings()) {
                init.addObserverMethodExpression(listenerDescriptor.getType(), Expressions.instance().createMethodExpression(expression));
            }
        }
    }

    protected void addComponent(ComponentDescriptor descriptor, Context context) {
        String name = descriptor.getName();
        String componentName = name + COMPONENT_SUFFIX;
        try {
            Component component = new Component(descriptor.getComponentClass(), name, descriptor.getScope(), descriptor.isStartup(), descriptor.getStartupDependencies(), descriptor.getJndiName());
            context.set(componentName, component);
            if (this.hotDeploymentStrategy != null && this.hotDeploymentStrategy.isEnabled() && this.hotDeploymentStrategy.isFromHotDeployClassLoader(descriptor.getComponentClass())) {
                Init.instance().addHotDeployableComponent(component.getName());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not create Component: " + name, e);
        }
    }

    private static String toCamelCase(String hyphenated, boolean initialUpper) {
        StringTokenizer tokens = new StringTokenizer(hyphenated, "-");
        StringBuilder result = new StringBuilder(hyphenated.length());
        String firstToken = tokens.nextToken();
        if (initialUpper) {
            result.append(Character.toUpperCase(firstToken.charAt(0))).append(firstToken.substring(1));
        } else {
            result.append(firstToken);
        }
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            result.append(Character.toUpperCase(token.charAt(0))).append(token.substring(1));
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventListenerDescriptor {
        private String type;
        private List<String> listenerMethodBindings = new ArrayList<String>();

        EventListenerDescriptor(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public List<String> getListenerMethodBindings() {
            return this.listenerMethodBindings;
        }

        public String toString() {
            return "EventListenerDescriptor(" + this.type + ')';
        }
    }
}

