/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.async.AbstractDispatcher;
import org.jboss.seam.async.Dispatcher;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;

@Interceptor(stateless=true, type=InterceptorType.CLIENT)
public class AsynchronousInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 9194177339867853303L;
    private static final String REENTRANT = "org.jboss.seam.async.AsynchronousIntercepter.REENTRANT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        boolean scheduleAsync;
        boolean bl = scheduleAsync = invocation.getMethod().isAnnotationPresent(Asynchronous.class) && (!this.isExecutingAsynchronousCall() || Contexts.getEventContext().isSet(REENTRANT));
        if (scheduleAsync) {
            Dispatcher dispatcher = AbstractDispatcher.instance();
            if (dispatcher == null) {
                throw new IllegalStateException("org.jboss.seam.async.dispatcher is not installed in components.xml");
            }
            Object timer = dispatcher.scheduleInvocation(invocation, this.getComponent());
            return timer != null && invocation.getMethod().getReturnType().isAssignableFrom(timer.getClass()) ? timer : null;
        }
        boolean setFlag = false;
        if (this.isExecutingAsynchronousCall()) {
            Contexts.getEventContext().set(REENTRANT, true);
            setFlag = true;
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (setFlag) {
                Contexts.getEventContext().remove(REENTRANT);
            }
        }
    }

    private boolean isExecutingAsynchronousCall() {
        return Contexts.getEventContext().isSet("org.jboss.seam.core.executingAsynchronousCall");
    }

    public boolean isInterceptorEnabled() {
        return this.getComponent().getType().isEjb() && this.getComponent().businessInterfaceHasAnnotation(Asynchronous.class) || this.getComponent().getType() == ComponentType.JAVA_BEAN && this.getComponent().beanClassHasAnnotation(Asynchronous.class);
    }
}

