/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.faces.model.SelectItem;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Manager;
import org.jboss.seam.web.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="org.jboss.seam.faces.switcher")
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@BypassInterceptors
public class Switcher
implements Serializable {
    private static final long serialVersionUID = -6403911073853051938L;
    private List<SelectItem> selectItems;
    private String conversationIdOrOutcome;
    private String resultingConversationIdOrOutcome;

    @Create
    public void createSelectItems() {
        ConversationEntries conversationEntries = ConversationEntries.getInstance();
        if (conversationEntries == null) {
            this.selectItems = Collections.EMPTY_LIST;
        } else {
            TreeSet<ConversationEntry> orderedEntries = new TreeSet<ConversationEntry>();
            orderedEntries.addAll(conversationEntries.getConversationEntries());
            this.selectItems = new ArrayList<SelectItem>(conversationEntries.size());
            for (ConversationEntry entry : orderedEntries) {
                if (!entry.isDisplayable() || Session.instance().isInvalid()) continue;
                this.selectItems.add(new SelectItem((Object)entry.getId(), entry.getDescription()));
            }
        }
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    private String getLongRunningConversationId() {
        Manager manager = Manager.instance();
        if (manager.isLongRunningConversation()) {
            return manager.getCurrentConversationId();
        }
        if (manager.isNestedConversation()) {
            return manager.getParentConversationId();
        }
        return null;
    }

    public String getConversationIdOrOutcome() {
        return this.resultingConversationIdOrOutcome == null ? this.getLongRunningConversationId() : this.resultingConversationIdOrOutcome;
    }

    public void setConversationIdOrOutcome(String selectedId) {
        this.conversationIdOrOutcome = selectedId;
    }

    public String select() {
        String actualOutcome;
        boolean isOutcome;
        boolean bl = isOutcome = this.conversationIdOrOutcome == null || !Character.isDigit(this.conversationIdOrOutcome.charAt(0)) && this.conversationIdOrOutcome.indexOf(58) < 0;
        if (isOutcome) {
            this.resultingConversationIdOrOutcome = this.conversationIdOrOutcome;
            actualOutcome = this.conversationIdOrOutcome;
        } else {
            ConversationEntry ce = ConversationEntries.instance().getConversationEntry(this.conversationIdOrOutcome);
            if (ce != null) {
                this.resultingConversationIdOrOutcome = ce.getId();
                ce.redirect();
            }
            actualOutcome = null;
        }
        return actualOutcome;
    }
}

