/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.international.TimeZoneWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.international.timeZones")
public class TimeZones {
    private static final String TIMEZONE_ID_PREFIXES = "^(Africa|America|Asia|Atlantic|Australia|Europe|Indian|Pacific)/.*";
    private boolean wrap = true;
    private List<TimeZone> timeZones = null;

    @Create
    public void init() {
        String[] timeZoneIds;
        this.timeZones = new ArrayList<TimeZone>();
        for (String id : timeZoneIds = TimeZone.getAvailableIDs()) {
            if (!id.matches(TIMEZONE_ID_PREFIXES)) continue;
            this.timeZones.add(this.wrap ? new TimeZoneWrapper(TimeZone.getTimeZone(id)) : TimeZone.getTimeZone(id));
        }
        Collections.sort(this.timeZones, new Comparator<TimeZone>(){

            @Override
            public int compare(TimeZone a, TimeZone b) {
                return a.getID().compareTo(b.getID());
            }
        });
    }

    @Unwrap
    public List<TimeZone> getTimeZones() {
        return this.timeZones;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }
}

